/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.ssl;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u000b2\u00020\u0001:\u0003\u000b\f\rB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/httpClient/execution/ssl/SslCertStore;", "", "()V", "containsKey", "", "getContainsKey", "()Z", "keyStore", "Ljava/security/KeyStore;", "getKeyStore", "()Ljava/security/KeyStore;", "Companion", "Raw", "Ready", "Lcom/intellij/httpClient/execution/ssl/SslCertStore$Raw;", "Lcom/intellij/httpClient/execution/ssl/SslCertStore$Ready;", "intellij.httpClient.executor"})
public abstract class SslCertStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String KEY_ALIAS = "key";
    @NotNull
    private static final String JKS_STORE = "JKS";

    private SslCertStore() {
    }

    public boolean getContainsKey() {
        return true;
    }

    @NotNull
    public abstract KeyStore getKeyStore();

    public /* synthetic */ SslCertStore(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/httpClient/execution/ssl/SslCertStore$Companion;", "", "()V", "JKS_STORE", "", "KEY_ALIAS", "createKeyStore", "Ljava/security/KeyStore;", "intellij.httpClient.executor"})
    public static final class Companion {
        private Companion() {
        }

        private final KeyStore createKeyStore() {
            KeyStore keyStore;
            KeyStore $this$createKeyStore_u24lambda_u240 = keyStore = KeyStore.getInstance(SslCertStore.JKS_STORE);
            boolean bl = false;
            $this$createKeyStore_u24lambda_u240.load(null, null);
            KeyStore keyStore2 = keyStore;
            Intrinsics.checkNotNullExpressionValue((Object)keyStore2, (String)"apply(...)");
            return keyStore2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u0014\u0010\u0015\u001a\u00020\u00132\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/httpClient/execution/ssl/SslCertStore$Raw;", "Lcom/intellij/httpClient/execution/ssl/SslCertStore;", "()V", "certificates", "", "Ljava/security/cert/Certificate;", "containsKey", "", "getContainsKey", "()Z", "keyStore", "Ljava/security/KeyStore;", "getKeyStore", "()Ljava/security/KeyStore;", "passphrase", "", "privateKey", "Ljava/security/PrivateKey;", "addCertificate", "", "certificate", "addIntermediates", "", "addPrivateKey", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nsslConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 sslConfiguration.kt\ncom/intellij/httpClient/execution/ssl/SslCertStore$Raw\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,213:1\n37#2,2:214\n*S KotlinDebug\n*F\n+ 1 sslConfiguration.kt\ncom/intellij/httpClient/execution/ssl/SslCertStore$Raw\n*L\n188#1:214,2\n*E\n"})
    public static final class Raw
    extends SslCertStore {
        @NotNull
        private final List<Certificate> certificates = new ArrayList();
        private PrivateKey privateKey;
        @Nullable
        private String passphrase;

        public Raw() {
            super(null);
        }

        @Override
        public boolean getContainsKey() {
            return this.privateKey != null;
        }

        public final void addCertificate(@NotNull Certificate certificate) {
            Intrinsics.checkNotNullParameter((Object)certificate, (String)"certificate");
            this.certificates.add(0, certificate);
        }

        public final void addIntermediates(@NotNull List<? extends Certificate> certificates) {
            Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
            CollectionsKt.addAll((Collection)this.certificates, (Iterable)certificates);
        }

        public final void addPrivateKey(@NotNull PrivateKey privateKey, @Nullable String passphrase) {
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            this.privateKey = privateKey;
            this.passphrase = passphrase;
        }

        @Override
        @NotNull
        public KeyStore getKeyStore() {
            KeyStore keyStore;
            if (!(this.privateKey != null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(!((Collection)this.certificates).isEmpty())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            KeyStore $this$_get_keyStore__u24lambda_u240 = keyStore = Companion.createKeyStore();
            boolean bl = false;
            PrivateKey privateKey = this.privateKey;
            if (privateKey == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"privateKey");
                privateKey = null;
            }
            Collection $this$toTypedArray$iv = this.certificates;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            KeyStore.Entry entry = new KeyStore.PrivateKeyEntry(privateKey, thisCollection$iv.toArray(new Certificate[0]));
            String string = this.passphrase;
            if (string == null) {
                string = "";
            }
            char[] cArray = string.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            $this$_get_keyStore__u24lambda_u240.setEntry(SslCertStore.KEY_ALIAS, entry, new KeyStore.PasswordProtection(cArray));
            return keyStore;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/httpClient/execution/ssl/SslCertStore$Ready;", "Lcom/intellij/httpClient/execution/ssl/SslCertStore;", "keyStore", "Ljava/security/KeyStore;", "(Ljava/security/KeyStore;)V", "getKeyStore", "()Ljava/security/KeyStore;", "intellij.httpClient.executor"})
    public static final class Ready
    extends SslCertStore {
        @NotNull
        private final KeyStore keyStore;

        public Ready(@NotNull KeyStore keyStore) {
            Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
            super(null);
            this.keyStore = keyStore;
        }

        @Override
        @NotNull
        public KeyStore getKeyStore() {
            return this.keyStore;
        }
    }
}

