/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl.engineV2;

import com.intellij.httpClient.execution.HttpRequestConfig;
import com.intellij.httpClient.execution.RestClientRequest;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\u0003R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/httpClient/execution/impl/engineV2/RedirectionChecker;", "", "isEnabled", "", "limit", "", "(ZI)V", "current", "Ljava/util/concurrent/atomic/AtomicInteger;", "redirectAvailable", "Key", "intellij.httpClient.executor"})
public final class RedirectionChecker {
    @NotNull
    public static final Key Key = new Key(null);
    private final boolean isEnabled;
    private final int limit;
    @NotNull
    private final AtomicInteger current;
    public static final int REDIRECTION_LIMIT = 50;
    @NotNull
    private static final Set<String> laxRedirectionMethods;
    @NotNull
    private static final Set<Integer> redirectionStatuses;
    public static final int REDIRECTION_STATUS_WITH_SPECIAL_HANDLING = 302;

    private RedirectionChecker(boolean isEnabled, int limit) {
        this.isEnabled = isEnabled;
        this.limit = limit;
        this.current = new AtomicInteger(0);
    }

    /* synthetic */ RedirectionChecker(boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 50;
        }
        this(bl, n);
    }

    public final boolean redirectAvailable() {
        return this.isEnabled && this.current.incrementAndGet() <= this.limit;
    }

    public /* synthetic */ RedirectionChecker(boolean isEnabled, int limit, DefaultConstructorMarker $constructor_marker) {
        this(isEnabled, limit);
    }

    static {
        Object[] objectArray = new String[]{"GET", "POST", "HEAD", "DELETE"};
        laxRedirectionMethods = SetsKt.setOf((Object[])objectArray);
        objectArray = new Integer[]{301, 302, 303, 307, 308};
        redirectionStatuses = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/httpClient/execution/impl/engineV2/RedirectionChecker$Key;", "", "()V", "REDIRECTION_LIMIT", "", "REDIRECTION_STATUS_WITH_SPECIAL_HANDLING", "laxRedirectionMethods", "", "", "getLaxRedirectionMethods", "()Ljava/util/Set;", "redirectionStatuses", "getRedirectionStatuses", "fromRequestAndConfig", "Lcom/intellij/httpClient/execution/impl/engineV2/RedirectionChecker;", "request", "Lcom/intellij/httpClient/execution/RestClientRequest;", "config", "Lcom/intellij/httpClient/execution/HttpRequestConfig;", "limit", "intellij.httpClient.executor"})
    public static final class Key {
        private Key() {
        }

        @NotNull
        public final RedirectionChecker fromRequestAndConfig(@NotNull RestClientRequest request2, @NotNull HttpRequestConfig config, int limit) {
            Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            boolean isEnabled = config.isFollowRedirects() && this.getLaxRedirectionMethods().contains(request2.httpMethod);
            return new RedirectionChecker(isEnabled, limit, null);
        }

        public static /* synthetic */ RedirectionChecker fromRequestAndConfig$default(Key key2, RestClientRequest restClientRequest, HttpRequestConfig httpRequestConfig, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 50;
            }
            return key2.fromRequestAndConfig(restClientRequest, httpRequestConfig, n);
        }

        @NotNull
        public final Set<String> getLaxRedirectionMethods() {
            return laxRedirectionMethods;
        }

        @NotNull
        public final Set<Integer> getRedirectionStatuses() {
            return redirectionStatuses;
        }

        public /* synthetic */ Key(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

