/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.impl;

import com.intellij.httpClient.execution.adapters.HttpClientResponseHeader;
import com.intellij.httpClient.execution.common.CommonClientBodyFileHint;
import com.intellij.httpClient.execution.impl.HttpRequestHandlerUtil;
import com.intellij.httpClient.execution.impl.HttpRequestResponseFileNameHint;
import com.intellij.httpClient.http.request.run.HttpRequestExecutionHelperService;
import com.intellij.openapi.fileTypes.FileType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/httpClient/execution/impl/HttpClientBodyFileHint;", "Lcom/intellij/httpClient/execution/common/CommonClientBodyFileHint;", "contentDispositionHeader", "Lcom/intellij/httpClient/execution/adapters/HttpClientResponseHeader;", "mimeType", "", "(Lcom/intellij/httpClient/execution/adapters/HttpClientResponseHeader;Ljava/lang/String;)V", "fileExtensionHint", "getFileExtensionHint", "()Ljava/lang/String;", "fileNameHint", "getFileNameHint", "fileTypeHint", "Lcom/intellij/openapi/fileTypes/FileType;", "getFileTypeHint", "()Lcom/intellij/openapi/fileTypes/FileType;", "intellij.httpClient.executor"})
public final class HttpClientBodyFileHint
implements CommonClientBodyFileHint {
    @Nullable
    private final String fileExtensionHint;
    @Nullable
    private final String fileNameHint;
    @Nullable
    private final FileType fileTypeHint;

    public HttpClientBodyFileHint(@Nullable HttpClientResponseHeader contentDispositionHeader, @NotNull String mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        HttpRequestResponseFileNameHint fileNameHint = HttpRequestHandlerUtil.access$parseFileNameHint(contentDispositionHeader);
        String nameHint = null;
        String extensionHint = null;
        if (fileNameHint instanceof HttpRequestResponseFileNameHint.FullFileName) {
            nameHint = ((HttpRequestResponseFileNameHint.FullFileName)fileNameHint).getName();
        } else if (fileNameHint instanceof HttpRequestResponseFileNameHint.FileExtension) {
            extensionHint = ((HttpRequestResponseFileNameHint.FileExtension)fileNameHint).getExtension();
        }
        if (extensionHint == null) {
            extensionHint = HttpRequestHandlerUtil.suggestExtensionByMimeType(mimeType);
        }
        HttpRequestExecutionHelperService httpRequestExecutionHelperService = HttpRequestExecutionHelperService.getInstance();
        this.fileTypeHint = httpRequestExecutionHelperService != null ? httpRequestExecutionHelperService.suggestFileType(mimeType) : null;
        this.fileNameHint = nameHint;
        this.fileExtensionHint = extensionHint;
    }

    @Override
    @Nullable
    public String getFileExtensionHint() {
        return this.fileExtensionHint;
    }

    @Override
    @Nullable
    public String getFileNameHint() {
        return this.fileNameHint;
    }

    @Override
    @Nullable
    public FileType getFileTypeHint() {
        return this.fileTypeHint;
    }
}

