/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.terminal;

import com.intellij.execution.CommandLineUtil;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.ShellChannelBuilder;
import com.intellij.ssh.SshException;
import com.intellij.ssh.channels.ShellChannel;
import com.intellij.ssh.process.SshShellProcess;
import com.intellij.ssh.ui.SshPasswordPrompt;
import com.jediterm.terminal.TtyConnector;
import com.jetbrains.gateway.ssh.dialogs.GatewaySshPasswordPrompt;
import com.jetbrains.gateway.terminal.JschProcessTtyConnector;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u001f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/gateway/terminal/SshTerminalDirectRunner;", "Lorg/jetbrains/plugins/terminal/AbstractTerminalRunner;", "Lcom/intellij/ssh/process/SshShellProcess;", "project", "Lcom/intellij/openapi/project/Project;", "myCredentials", "Lcom/intellij/remote/RemoteCredentials;", "myDefaultCharset", "Ljava/nio/charset/Charset;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/remote/RemoteCredentials;Ljava/nio/charset/Charset;)V", "shellChannel", "Lcom/intellij/ssh/channels/ShellChannel;", "getShellChannel", "()Lcom/intellij/ssh/channels/ShellChannel;", "createProcess", "options", "Lorg/jetbrains/plugins/terminal/ShellStartupOptions;", "createShellChannel", "createTtyConnector", "Lcom/jediterm/terminal/TtyConnector;", "process", "getCurrentWorkingDir", "", "state", "Lorg/jetbrains/plugins/terminal/TerminalTabState;", "getDefaultTabTitle", "Companion", "intellij.gateway.terminal"})
public final class SshTerminalDirectRunner
extends AbstractTerminalRunner<SshShellProcess> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RemoteCredentials myCredentials;
    @NotNull
    private final Charset myDefaultCharset;

    public SshTerminalDirectRunner(@Nullable Project project, @NotNull RemoteCredentials myCredentials, @NotNull Charset myDefaultCharset) {
        Intrinsics.checkNotNullParameter((Object)myCredentials, (String)"myCredentials");
        Intrinsics.checkNotNullParameter((Object)myDefaultCharset, (String)"myDefaultCharset");
        Project project2 = project;
        Intrinsics.checkNotNull((Object)project2);
        super(project2);
        this.myCredentials = myCredentials;
        this.myDefaultCharset = myDefaultCharset;
    }

    @NotNull
    public SshShellProcess createProcess(@NotNull ShellStartupOptions options) throws ExecutionException {
        SshShellProcess sshShellProcess;
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        try {
            ShellChannel channel = this.getShellChannel();
            String string = options.getWorkingDirectory();
            if (string != null) {
                String it = string;
                boolean bl = false;
                SshTerminalDirectRunner.Companion.issueCdCommand(channel, it);
            }
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            TerminalUsageTriggerCollector.triggerSshShellStarted((Project)project);
            sshShellProcess = new SshShellProcess(channel);
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage(), e);
        }
        return sshShellProcess;
    }

    private final ShellChannel getShellChannel() throws RemoteSdkException {
        return this.createShellChannel();
    }

    private final ShellChannel createShellChannel() throws RemoteSdkException {
        ShellChannel shellChannel;
        try {
            shellChannel = ShellChannelBuilder.openChannel$default((ShellChannelBuilder)((ShellChannelBuilder)RemoteCredentialsUtil.connectionBuilder$default((RemoteCredentials)this.myCredentials, (Project)this.myProject, null, (boolean)false, (SshPasswordPrompt)((SshPasswordPrompt)new GatewaySshPasswordPrompt()), (int)6, null).shellBuilder().withAllocatePty(true)), (int)0, (int)1, null);
        }
        catch (SshException e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
        return shellChannel;
    }

    @Nullable
    public String getCurrentWorkingDir(@Nullable TerminalTabState state) {
        TerminalTabState terminalTabState = state;
        return terminalTabState != null ? terminalTabState.myWorkingDirectory : null;
    }

    @NotNull
    public TtyConnector createTtyConnector(@NotNull SshShellProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        return (TtyConnector)new JschProcessTtyConnector(process, this.myDefaultCharset);
    }

    @NotNull
    public String getDefaultTabTitle() {
        return this.myCredentials.getHost() + ":" + this.myCredentials.getLiteralPort();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/gateway/terminal/SshTerminalDirectRunner$Companion;", "", "()V", "issueCdCommand", "", "channel", "Lcom/intellij/ssh/channels/ShellChannel;", "directory", "", "intellij.gateway.terminal"})
    public static final class Companion {
        private Companion() {
        }

        private final void issueCdCommand(ShellChannel channel, String directory) throws IOException {
            String cdCommand = StringsKt.trimIndent((String)("\n            cd " + CommandLineUtil.posixQuote((String)directory) + "\n            \n            "));
            OutputStream outputStream = channel.getOutputStream();
            String string = cdCommand;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            outputStream.write(byArray);
            channel.getOutputStream().flush();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

