/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.clangd.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.completion.ClangdCodeCompletionProviderBase;
import com.jetbrains.cidr.lang.completion.ClangdLookupElement;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionKind;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.settings.OCCodeInsightSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.radler.clangd.CompletionComparisonCollector;
import com.jetbrains.cidr.radler.clangd.RadClangAnnotatorUtilKt;
import com.jetbrains.rider.cpp.fileType.CppHeaderFileType;
import com.jetbrains.rider.cpp.fileType.CppSourceFileType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadClangdCodeCompletionProviderImpl
extends ClangdCodeCompletionProviderBase {
    @NonNls
    protected static final String TEMPLATE_REGEX = "\\n|(<caret>)|(<#(.*)#>)";
    private long myCompletionStartTimeMillis = 0L;
    private long myRiderFirstResultMillis = 0L;
    private long myFirstLookupItemMillis = 0L;
    private HashMap<String, Long> myRiderResultTimes;
    private long myRiderAllResultsMillis = 0L;
    private long myClangdFirstResultMillis = 0L;
    private HashMap<String, Long> myClangdResultTimes;
    private long myClangdAllResultsMillis = 0L;
    private ArrayList<LookupElement> myClangdHiddenResults;

    private static boolean showClangdCompletion(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(0);
        }
        return Registry.is((String)"com.jetbrains.cidr.radler.clangd.completion.enable") || RadClangAnnotatorUtilKt.shouldSupportViaClangd(originalFile);
    }

    protected LookupElementBuilder createSnippetLookup(@NotNull CLionCompletionItem completion) {
        if (completion == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(1);
        }
        String template = ((TextEdit)completion.getTextEdit().getLeft()).getNewText();
        String data = template.replaceAll(TEMPLATE_REGEX, "").trim();
        return LookupElementBuilder.create((Object)completion, (String)data);
    }

    protected boolean isCppFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(2);
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        return file2 instanceof VirtualFileWithId && fileTypeManager.isFileOfType(file2, (FileType)CppSourceFileType.INSTANCE) || fileTypeManager.isFileOfType(file2, (FileType)CppHeaderFileType.INSTANCE);
    }

    protected InsertHandler<LookupElement> createClangdInsertHandler(@NotNull CLionCompletionItem completion, int prefixLength, String charBeforePrefix, Position completionCaretPosition) {
        if (completion == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(3);
        }
        return (context, item) -> {};
    }

    protected void runNameSuggestionContributor(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(4);
        }
        if (result == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(5);
        }
    }

    private static String extractLabelFromLookupString(@NotNull String lookupString) {
        String label;
        if (lookupString == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(6);
        }
        if ((label = lookupString.trim()).isEmpty()) {
            return label;
        }
        label = label.split(" ")[0];
        return StringUtil.trimEnd((String)StringUtil.trimEnd((String)label, (String)";"), (String)"()");
    }

    protected void runExtraCompletionContributors(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, int invocationCount, boolean allowNameSuggestions) {
        if (parameters == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(7);
        }
        if (result == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(8);
        }
        if (RadClangdCodeCompletionProviderImpl.showClangdCompletion(parameters.getOriginalFile())) {
            return;
        }
        Ref firstResult = new Ref((Object)true);
        result.runRemainingContributors(parameters, completionResult -> {
            if (((Boolean)firstResult.get()).booleanValue()) {
                firstResult.set((Object)false);
                this.myRiderFirstResultMillis = System.currentTimeMillis() - this.myCompletionStartTimeMillis;
            }
            String label = RadClangdCodeCompletionProviderImpl.extractLabelFromLookupString(completionResult.getLookupElement().getLookupString());
            this.myRiderResultTimes.put(label, System.currentTimeMillis() - this.myCompletionStartTimeMillis);
            result.passResult(completionResult);
        });
        this.myRiderAllResultsMillis = System.currentTimeMillis() - this.myCompletionStartTimeMillis;
    }

    protected boolean isUDLElement(PsiElement psiContextElement) {
        return false;
    }

    @Nullable
    protected IElementType getCodeFragmentType(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Nullable
    protected VirtualFile getVirtualFileForCodeFragment(@NotNull PsiFile psiFile, @NotNull VirtualFile virtualFile, IElementType fragmentElementType) {
        if (psiFile == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(10);
        }
        if (virtualFile == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(11);
        }
        return null;
    }

    protected int getCompletionKind(@NotNull CompletionParameters parameters, IElementType fragmentElementType, boolean isUDL) {
        if (parameters == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(12);
        }
        int completionKind = CLionCompletionKind.Default.getValue();
        CompletionType completionType = parameters.getCompletionType();
        if (completionType == CompletionType.SMART) {
            completionKind = CLionCompletionKind.Smart.getValue();
        }
        if (completionType == CompletionType.SMART || parameters.getInvocationCount() > 1) {
            completionKind |= CLionCompletionKind.NestedNamespaces.getValue();
        }
        if (!OCCodeInsightSettings.getInstance().ALLOW_IMPORT_IN_COMPLETION || isUDL || parameters.getInvocationCount() <= 1) {
            completionKind |= CLionCompletionKind.DisableIndex.getValue();
        }
        return completionKind;
    }

    protected OCResolveConfiguration getActiveResolveConfiguration(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(13);
        }
        if (project == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(14);
        }
        List configs = OCWorkspace.getInstance((Project)project).getConfigurationsForFile(virtualFile);
        return (OCResolveConfiguration)OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project, (Collection)configs).first;
    }

    protected void addElement(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull LookupElement element) {
        if (parameters == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(15);
        }
        if (result == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(16);
        }
        if (element == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(17);
        }
        if (RadClangdCodeCompletionProviderImpl.showClangdCompletion(parameters.getOriginalFile())) {
            result.addElement(element);
            return;
        }
        if (element instanceof ClangdLookupElement) {
            if (this.myClangdFirstResultMillis < 0L) {
                this.myClangdFirstResultMillis = System.currentTimeMillis() - this.myCompletionStartTimeMillis;
            }
            String label = RadClangdCodeCompletionProviderImpl.extractLabelFromLookupString(element.getLookupString());
            this.myClangdResultTimes.put(label, System.currentTimeMillis() - this.myCompletionStartTimeMillis);
            this.myClangdHiddenResults.add(element);
        }
    }

    protected void addLookupAdvertisement(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, @NotNull @NlsContexts.PopupAdvertisement String text) {
        if (parameters == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(18);
        }
        if (result == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(19);
        }
        if (text == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(20);
        }
        if (RadClangdCodeCompletionProviderImpl.showClangdCompletion(parameters.getOriginalFile())) {
            result.addLookupAdvertisement(text);
        }
    }

    protected void consume(@NotNull ClangLanguageService clangdService, @NotNull CompletionParameters parameters, @NotNull VirtualFile virtualFile, @Nullable OCResolveConfiguration resolveConfiguration, @NotNull CompletionResultSet result, @NotNull Either<List<CLionCompletionItem>, CLionCompletionList> completionResult, int line, int column, @NotNull String fileText, String charBeforePrefix, Position completionCaretPosition, Position extraPositionOffset, Position fakeEditorOffset, @NotNull Pair<Integer, ArrayList<String>> postfixTemplates, int completionKind, ClangUrlConverter urlConverter) throws ExecutionException, TimeoutException {
        if (clangdService == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(21);
        }
        if (parameters == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(22);
        }
        if (virtualFile == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(23);
        }
        if (result == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(24);
        }
        if (completionResult == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(25);
        }
        if (fileText == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(26);
        }
        if (postfixTemplates == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(27);
        }
        super.consume(clangdService, parameters, virtualFile, resolveConfiguration, result, completionResult, line, column, fileText, charBeforePrefix, completionCaretPosition, extraPositionOffset, fakeEditorOffset, postfixTemplates, completionKind, urlConverter);
    }

    protected void consumeResult(@NotNull CompletionParameters parameters, @NotNull VirtualFile virtualFile, @Nullable OCResolveConfiguration resolveConfiguration, @NotNull CompletionResultSet result, @NotNull Either<List<CLionCompletionItem>, CLionCompletionList> completionResult, String charBeforePrefix, Position completionCaretPosition, Position extraPositionOffset, Position fakeEditorOffset, ClangUrlConverter urlConverter) {
        if (parameters == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(28);
        }
        if (virtualFile == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(29);
        }
        if (result == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(30);
        }
        if (completionResult == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(31);
        }
        super.consumeResult(parameters, virtualFile, resolveConfiguration, result, completionResult, charBeforePrefix, completionCaretPosition, extraPositionOffset, fakeEditorOffset, urlConverter);
        if (completionResult.isRight() && !((CLionCompletionList)completionResult.getRight()).isIncomplete()) {
            this.myClangdAllResultsMillis = System.currentTimeMillis() - this.myCompletionStartTimeMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompletions(final @NotNull CompletionParameters parameters, @NotNull ProcessingContext context, final @NotNull CompletionResultSet originalResult) {
        LookupEx lookup;
        if (parameters == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(32);
        }
        if (context == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(33);
        }
        if (originalResult == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(34);
        }
        this.myClangdAllResultsMillis = -1L;
        this.myClangdFirstResultMillis = -1L;
        this.myRiderFirstResultMillis = -1L;
        this.myRiderAllResultsMillis = -1L;
        this.myFirstLookupItemMillis = -1L;
        this.myCompletionStartTimeMillis = System.currentTimeMillis();
        if (!RadClangdCodeCompletionProviderImpl.showClangdCompletion(parameters.getOriginalFile())) {
            this.myRiderResultTimes = new HashMap();
            this.myClangdResultTimes = new HashMap();
            this.myClangdHiddenResults = new ArrayList();
        }
        if ((lookup = LookupManager.getActiveLookup((Editor)parameters.getEditor())) != null) {
            lookup.addLookupListener(new LookupListener(){

                public boolean beforeItemSelected(@NotNull LookupEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (RadClangdCodeCompletionProviderImpl.showClangdCompletion(parameters.getOriginalFile())) {
                        return super.beforeItemSelected(event);
                    }
                    @Nullable LookupElement item = event.getItem();
                    if (RadClangdCodeCompletionProviderImpl.this.myFirstLookupItemMillis > 0L && item != null && RadClangdCodeCompletionProviderImpl.this.myClangdHiddenResults != null && RadClangdCodeCompletionProviderImpl.this.myClangdFirstResultMillis > 0L) {
                        String label = RadClangdCodeCompletionProviderImpl.extractLabelFromLookupString(item.getLookupString());
                        Long riderTiming = RadClangdCodeCompletionProviderImpl.this.myRiderResultTimes.getOrDefault(label, 0L);
                        riderTiming = Math.max(riderTiming, RadClangdCodeCompletionProviderImpl.this.myFirstLookupItemMillis);
                        int riderIndex = event.getLookup().getItems().indexOf(item);
                        boolean found = false;
                        for (LookupElement elem : RadClangdCodeCompletionProviderImpl.this.myClangdHiddenResults) {
                            @NotNull String curLabel = RadClangdCodeCompletionProviderImpl.extractLabelFromLookupString(elem.getLookupString());
                            if (!curLabel.equals(label)) continue;
                            found = true;
                            Long clangdTiming = RadClangdCodeCompletionProviderImpl.this.myClangdResultTimes.get(curLabel);
                            int clangdIndex = RadClangdCodeCompletionProviderImpl.this.myClangdHiddenResults.indexOf(elem);
                            CompletionComparisonCollector.COMPLETION_SELECTED.log(parameters.getEditor().getProject(), (Object)originalResult.getPrefixMatcher().getPrefix().length(), (Object)riderIndex, (Object)clangdIndex);
                            if (!ClangDebugLevel.isWarnOrMore()) break;
                            CidrLogService.LOG.warn("Prefix length = " + originalResult.getPrefixMatcher().getPrefix().length() + ", Rider item took " + riderTiming + "ms, index = " + riderIndex + ", Clangd item took " + clangdTiming + "ms, index " + clangdIndex);
                            break;
                        }
                        if (!found) {
                            CompletionComparisonCollector.COMPLETION_SELECTED.log(parameters.getEditor().getProject(), (Object)originalResult.getPrefixMatcher().getPrefix().length(), (Object)riderIndex, (Object)-1);
                            if (ClangDebugLevel.isWarnOrMore()) {
                                CidrLogService.LOG.warn("Rider item took " + riderTiming + "ms, index = " + riderIndex + ", item not found in Clangd");
                            }
                        }
                    }
                    return super.beforeItemSelected(event);
                }

                public void firstElementShown() {
                    RadClangdCodeCompletionProviderImpl.this.myFirstLookupItemMillis = System.currentTimeMillis() - RadClangdCodeCompletionProviderImpl.this.myCompletionStartTimeMillis;
                }

                public void lookupCanceled(@NotNull LookupEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (RadClangdCodeCompletionProviderImpl.showClangdCompletion(parameters.getOriginalFile()) || RadClangdCodeCompletionProviderImpl.this.myFirstLookupItemMillis < 0L) {
                        return;
                    }
                    int differentItemsCount = 0;
                    String topDifferentResult = null;
                    for (LookupElement elem : RadClangdCodeCompletionProviderImpl.this.myClangdHiddenResults) {
                        String label;
                        ClangdLookupElement clangdLookupElem;
                        if (elem instanceof ClangdLookupElement && ((clangdLookupElem = (ClangdLookupElement)elem).getKind() == CompletionItemKind.Text || clangdLookupElem.getKind() == CompletionItemKind.Keyword) || RadClangdCodeCompletionProviderImpl.this.myRiderResultTimes.get(label = RadClangdCodeCompletionProviderImpl.extractLabelFromLookupString(elem.getLookupString())) != null) continue;
                        if (topDifferentResult == null) {
                            topDifferentResult = label;
                        }
                        ++differentItemsCount;
                    }
                    CompletionComparisonCollector.COMPLETION_CANCELLED.log(parameters.getEditor().getProject(), (Object)differentItemsCount);
                    if (ClangDebugLevel.isWarnOrMore()) {
                        CidrLogService.LOG.warn("No item was selected, Clangd has " + differentItemsCount + " items not found by Rider, top item lookup string is " + topDifferentResult);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/jetbrains/cidr/radler/clangd/completion/RadClangdCodeCompletionProviderImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeItemSelected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lookupCanceled";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        try {
            super.addCompletions(parameters, context, originalResult);
        }
        catch (Throwable throwable) {
            if (!RadClangdCodeCompletionProviderImpl.showClangdCompletion(parameters.getOriginalFile())) {
                CompletionComparisonCollector.COMPLETION_CALLED.log(parameters.getEditor().getProject(), new EventPair[]{CompletionComparisonCollector.RIDER_TIME.with((Object)Math.max(this.myRiderFirstResultMillis, this.myFirstLookupItemMillis)), CompletionComparisonCollector.RIDER_ITEMS_COUNT.with((Object)this.myRiderResultTimes.size()), CompletionComparisonCollector.CLANGD_TIME.with((Object)this.myClangdFirstResultMillis), CompletionComparisonCollector.CLANGD_ITEMS_COUNT.with((Object)this.myClangdResultTimes.size())});
                if (ClangDebugLevel.isWarnOrMore()) {
                    CidrLogService.LOG.warn("Rider completion has " + this.myRiderResultTimes.size() + " elements, took " + Math.max(this.myRiderFirstResultMillis, this.myFirstLookupItemMillis) + "ms to get first result, and " + this.myRiderAllResultsMillis + "ms to get all results");
                    CidrLogService.LOG.warn("Clangd completion has " + this.myClangdResultTimes.size() + " elements, took " + this.myClangdFirstResultMillis + "ms to get first result, and " + this.myClangdAllResultsMillis + "ms to get all results");
                }
            }
            throw throwable;
        }
        if (!RadClangdCodeCompletionProviderImpl.showClangdCompletion(parameters.getOriginalFile())) {
            CompletionComparisonCollector.COMPLETION_CALLED.log(parameters.getEditor().getProject(), new EventPair[]{CompletionComparisonCollector.RIDER_TIME.with((Object)Math.max(this.myRiderFirstResultMillis, this.myFirstLookupItemMillis)), CompletionComparisonCollector.RIDER_ITEMS_COUNT.with((Object)this.myRiderResultTimes.size()), CompletionComparisonCollector.CLANGD_TIME.with((Object)this.myClangdFirstResultMillis), CompletionComparisonCollector.CLANGD_ITEMS_COUNT.with((Object)this.myClangdResultTimes.size())});
            if (ClangDebugLevel.isWarnOrMore()) {
                CidrLogService.LOG.warn("Rider completion has " + this.myRiderResultTimes.size() + " elements, took " + Math.max(this.myRiderFirstResultMillis, this.myFirstLookupItemMillis) + "ms to get first result, and " + this.myRiderAllResultsMillis + "ms to get all results");
                CidrLogService.LOG.warn("Clangd completion has " + this.myClangdResultTimes.size() + " elements, took " + this.myClangdFirstResultMillis + "ms to get first result, and " + this.myClangdAllResultsMillis + "ms to get all results");
            }
        }
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            RadClangdCodeCompletionProviderImpl.$$$reportNull$$$0(35);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completion";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 15: 
            case 18: 
            case 22: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: 
            case 8: 
            case 16: 
            case 19: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 11: 
            case 13: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangdService";
                break;
            }
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionResult";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixTemplates";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalResult";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/radler/clangd/completion/RadClangdCodeCompletionProviderImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showClangdCompletion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createSnippetLookup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCppFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createClangdInsertHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "runNameSuggestionContributor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "extractLabelFromLookupString";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "runExtraCompletionContributors";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getCodeFragmentType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getVirtualFileForCodeFragment";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getCompletionKind";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getActiveResolveConfiguration";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "addElement";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "addLookupAdvertisement";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "consume";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeResult";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeCompletion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

