/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.radler.clangd;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.util.DocumentUtil;
import com.jetbrains.cidr.lang.OCLanguageUtilsBase;
import com.jetbrains.cidr.radler.clangd.RadClangAnnotatorUtilKt;
import com.jetbrains.rider.cpp.fileType.CppLanguage;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u000f\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/radler/clangd/RadClangdLineIndentProvider;", "Lcom/intellij/psi/codeStyle/lineIndent/LineIndentProvider;", "()V", "getLineIndent", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "language", "Lcom/intellij/lang/Language;", "offset", "", "isBlockOperation", "", "isSuitableFor", "intellij.rider.plugins.clion.radler"})
public final class RadClangdLineIndentProvider
implements LineIndentProvider {
    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (offset <= 0 || !RadClangAnnotatorUtilKt.shouldSupportViaClangd(project, editor.getVirtualFile())) {
            return null;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int lineStart = DocumentUtil.getLineStartOffset((int)offset, (Document)document2);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile source = psiDocumentManager.getPsiFile(document2);
        if (source != null && !this.isBlockOperation(editor)) {
            String indent;
            ExternalFormatProcessor clangFormat;
            Optional optional = ExternalFormatProcessor.findExternalFormatter((String)"ClangFormat");
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findExternalFormatter(...)");
            ExternalFormatProcessor externalFormatProcessor = clangFormat = (ExternalFormatProcessor)OptionalsKt.getOrNull((Optional)optional);
            String string = indent = externalFormatProcessor != null ? externalFormatProcessor.indent(source, lineStart) : null;
            if (indent != null) {
                return indent;
            }
        }
        return null;
    }

    private final boolean isBlockOperation(Editor editor) {
        return OCLanguageUtilsBase.INSIDE_TYPING_ACTION_HINT.get((UserDataHolder)editor.getDocument()) == Boolean.valueOf(true);
    }

    public boolean isSuitableFor(@Nullable Language language) {
        return CppLanguage.INSTANCE.is(language);
    }
}

