/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.platform.diagnostics.adapters.nativeServer;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionNativeServerLogger;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.util.Key;
import java.time.LocalDateTime;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.local.generation.model.remote.NativeServerDiagnosticCallback;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u001c\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00072\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/adapters/nativeServer/NativeServerDiagnostic;", "Lorg/jetbrains/completion/full/line/local/generation/model/remote/NativeServerDiagnosticCallback;", "logger", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionNativeServerLogger;", "(Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionNativeServerLogger;)V", "logsHistory", "Ljava/util/concurrent/LinkedBlockingQueue;", "", "writeLock", "Ljava/util/concurrent/locks/ReentrantLock;", "connectionAddress", "", "hostname", "port", "", "getLogsAttachment", "Lcom/intellij/openapi/diagnostic/Attachment;", "grpcChannelStateChanged", "connectivityState", "onTextAvailable", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "processTerminated", "processWillTerminate", "willBeDestroyed", "", "startNotified", "updateHistory", "newMessage", "Companion", "intellij.fullLine"})
public final class NativeServerDiagnostic
implements NativeServerDiagnosticCallback {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final MLCompletionNativeServerLogger logger;
    @NotNull
    private final LinkedBlockingQueue<String> logsHistory;
    @NotNull
    private final ReentrantLock writeLock;
    @Deprecated
    public static final int maxHistorySize = 1000;

    public NativeServerDiagnostic(@NotNull MLCompletionNativeServerLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.logsHistory = new LinkedBlockingQueue();
        this.writeLock = new ReentrantLock();
    }

    @Override
    public void grpcChannelStateChanged(@NotNull String connectivityState) {
        Intrinsics.checkNotNullParameter((Object)connectivityState, (String)"connectivityState");
        String message = "New GRPC channel state is " + connectivityState;
        this.logger.debug(message);
        NativeServerDiagnostic.updateHistory$default(this, message, null, 2, null);
        this.logger.grpcChannelState(connectivityState);
    }

    public void startNotified(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = "Full line native server is started";
        this.logger.info(message);
        NativeServerDiagnostic.updateHistory$default(this, message, null, 2, null);
        this.logger.processStarted();
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = "Full line native server is terminated with exit code " + event.getExitCode();
        this.logger.info(message);
        NativeServerDiagnostic.updateHistory$default(this, message, null, 2, null);
        this.logger.processTerminated(event.getExitCode());
    }

    public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String message = "Full line native server will be terminated. Will be destroyed: " + willBeDestroyed;
        this.logger.info(message);
        NativeServerDiagnostic.updateHistory$default(this, message, null, 2, null);
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        String message = event.getText();
        if (ProcessOutputType.isStderr(outputType)) {
            Intrinsics.checkNotNull((Object)message);
            this.logger.warn(message);
        } else {
            Intrinsics.checkNotNull((Object)message);
            this.logger.debug(message);
        }
        this.updateHistory(message, outputType.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateHistory(String newMessage, String outputType) {
        Lock lock = this.writeLock;
        lock.lock();
        try {
            boolean bl = false;
            while (this.logsHistory.size() > 1000) {
                this.logsHistory.poll();
            }
            LocalDateTime localDateTime = LocalDateTime.now();
            String string = outputType;
            if (string == null) {
                string = "EVENT";
            }
            this.logsHistory.put("[" + localDateTime + ", " + string + "] " + newMessage);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    static /* synthetic */ void updateHistory$default(NativeServerDiagnostic nativeServerDiagnostic, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        nativeServerDiagnostic.updateHistory(string, string2);
    }

    @Override
    @NotNull
    public Attachment getLogsAttachment() {
        return new Attachment("inference_service.log", CollectionsKt.joinToString$default((Iterable)this.logsHistory, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
    }

    @Override
    public void connectionAddress(@NotNull String hostname, int port) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        String message = "Full line native server address is " + hostname + ":" + port;
        this.logger.info(message);
        NativeServerDiagnostic.updateHistory$default(this, message, null, 2, null);
        this.logger.connectionAddress(hostname, port);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/completion/full/line/platform/diagnostics/adapters/nativeServer/NativeServerDiagnostic$Companion;", "", "()V", "maxHistorySize", "", "intellij.fullLine"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

