/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.generation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.local.generation.IndexToValue;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a#\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f\u001a3\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\u0010\u0012\u001a&\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\u0004\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u00142\u0006\u0010\u0016\u001a\u00020\fH\u0000\u001a\u0014\u0010\u0017\u001a\u00020\u0007*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\fH\u0000\u001a\u0014\u0010\u0017\u001a\u00020\f*\u00020\f2\u0006\u0010\u0016\u001a\u00020\fH\u0000\u00a8\u0006\u0018"}, d2={"fastExp", "", "value", "logSoftmax", "", "logits", "", "", "fast", "", "([[DZ)V", "topk1d", "", "data", "size", "", "topk2d", "dim", "([[DII)[[I", "slice", "", "T", "indices", "sliceArray", "intellij.fullLine.local"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/jetbrains/completion/full/line/local/generation/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,174:1\n1#2:175\n26#3:176\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/jetbrains/completion/full/line/local/generation/UtilsKt\n*L\n114#1:176\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final int[] sliceArray(@NotNull int[] $this$sliceArray, @NotNull int[] indices) {
        Intrinsics.checkNotNullParameter((Object)$this$sliceArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        int[] result = new int[indices.length];
        int targetIndex = 0;
        for (int sourceIndex : indices) {
            result[targetIndex++] = $this$sliceArray[sourceIndex];
        }
        return result;
    }

    @NotNull
    public static final double[] sliceArray(@NotNull double[] $this$sliceArray, @NotNull int[] indices) {
        Intrinsics.checkNotNullParameter((Object)$this$sliceArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        double[] result = new double[indices.length];
        int targetIndex = 0;
        for (int sourceIndex : indices) {
            result[targetIndex++] = $this$sliceArray[sourceIndex];
        }
        return result;
    }

    @NotNull
    public static final <T> List<T> slice(@NotNull List<? extends T> $this$slice, @NotNull int[] indices) {
        Intrinsics.checkNotNullParameter($this$slice, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        ArrayList<T> result = new ArrayList<T>(indices.length);
        int n = indices.length;
        for (int i = 0; i < n; ++i) {
            int targetIndex = i;
            int sourceIndex = indices[i];
            result.add(targetIndex, $this$slice.get(sourceIndex));
        }
        return result;
    }

    public static final void logSoftmax(@NotNull double[][] logits2, boolean fast) {
        int n;
        Intrinsics.checkNotNullParameter((Object)logits2, (String)"logits");
        int n2 = ((Object[])logits2).length;
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            double d;
            int n3 = i;
            double maxLogit = ArraysKt.maxOrThrow((double[])logits2[n3]);
            n = fast;
            if (n == 1) {
                var10_9 = logits2[n3];
                var22_20 = maxLogit;
                var21_19 = n3;
                var20_18 = dArray;
                var11_12 = 0.0;
                var14_14 = var10_9.length;
                for (var13_13 = 0; var13_13 < var14_14; ++var13_13) {
                    double d2 = var15_15 = var10_9[var13_13];
                    var24_21 = var11_12;
                    boolean bl = false;
                    var26_22 = UtilsKt.fastExp(it - maxLogit);
                    var11_12 = var24_21 + var26_22;
                }
                var24_21 = var11_12;
                v0 = var20_18;
                v1 = var21_19;
                d = var22_20 + RangesKt.coerceAtLeast((double)Math.log(var24_21), (double)0.0);
            } else if (n == 0) {
                var10_9 = logits2[n3];
                var22_20 = maxLogit;
                var11_12 = 0.0;
                var14_14 = var10_9.length;
                for (var13_13 = 0; var13_13 < var14_14; ++var13_13) {
                    it = var15_15 = var10_9[var13_13];
                    var24_21 = var11_12;
                    boolean bl = false;
                    var26_22 = Math.exp(it - maxLogit);
                    var11_12 = var24_21 + var26_22;
                }
                var24_21 = var11_12;
                v0 = var20_18;
                v1 = var21_19;
                d = var22_20 + Math.log(var24_21);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            v0[v1] = d;
        }
        double[] stableLogSumExps = dArray;
        n2 = ((Object[])logits2).length;
        for (int rowId = 0; rowId < n2; ++rowId) {
            double[] logitsRow = logits2[rowId];
            double logSumExp = stableLogSumExps[rowId];
            int colId = 0;
            n = logitsRow.length;
            while (colId < n) {
                int n4 = colId++;
                logitsRow[n4] = logitsRow[n4] - logSumExp;
            }
        }
    }

    public static /* synthetic */ void logSoftmax$default(double[][] dArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        UtilsKt.logSoftmax(dArray, bl);
    }

    public static final double fastExp(double value) {
        long tmp = (long)((double)1512775 * value + (double)1072632447);
        return Double.longBitsToDouble(tmp << 32);
    }

    @NotNull
    public static final int[] topk1d(@NotNull double[] data, int size) {
        int n;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (size == 0) {
            return new int[0];
        }
        PriorityQueue<IndexToValue> queue = new PriorityQueue<IndexToValue>(size);
        double worstValue = 0.0;
        int worstIndex = -1;
        int n2 = data.length;
        for (n = 0; n < n2; ++n) {
            Iterator iter;
            int index = n;
            double value = data[n];
            if (value == Double.NEGATIVE_INFINITY) continue;
            if (queue.size() < size) {
                queue.add(new IndexToValue(index, value));
                if (worstIndex != -1 && !(value < worstValue)) continue;
                worstIndex = index;
                worstValue = value;
                continue;
            }
            if (!(worstValue < value)) continue;
            Intrinsics.checkNotNullExpressionValue(queue.iterator(), (String)"iterator(...)");
            int nextWorstIndex = index;
            double nextWorstValue = value;
            while (iter.hasNext()) {
                IndexToValue next = (IndexToValue)iter.next();
                if (next.getIndex() == worstIndex) {
                    iter.remove();
                    continue;
                }
                if (!(next.getValue() < nextWorstValue)) continue;
                nextWorstValue = next.getValue();
                nextWorstIndex = next.getIndex();
            }
            worstIndex = nextWorstIndex;
            worstValue = nextWorstValue;
            queue.add(new IndexToValue(index, value));
        }
        n = 0;
        n2 = queue.size();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = ((IndexToValue)queue.poll()).getIndex();
        }
        return nArray;
    }

    @NotNull
    public static final int[][] topk2d(@NotNull double[][] data, int size, int dim) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (((Object[])data).length == 0) {
            boolean $i$f$emptyArray = false;
            return new int[0][];
        }
        switch (dim) {
            case 0: {
                int listSize = Math.min(((Object[])data).length, size);
                int n = 0;
                int[][] nArrayArray = new int[listSize][];
                while (n < listSize) {
                    int n2 = n++;
                    nArrayArray[n2] = new int[data[0].length];
                }
                int[][] result = nArrayArray;
                int n3 = data[0].length;
                for (int j = 0; j < n3; ++j) {
                    int n4 = 0;
                    int n5 = ((Object[])data).length;
                    double[] dArray = new double[n5];
                    while (n4 < n5) {
                        int n6 = n4++;
                        dArray[n6] = data[n6][j];
                    }
                    double[] slice = dArray;
                    for (int result[i][j] : UtilsKt.topk1d(slice, size)) {
                    }
                }
                return result;
            }
            case 1: {
                int n = 0;
                int n7 = ((Object[])data).length;
                int[][] nArrayArray = new int[n7][];
                while (n < n7) {
                    int n8 = n++;
                    nArrayArray[n8] = UtilsKt.topk1d(data[n8], size);
                }
                return nArrayArray;
            }
        }
        throw new IllegalArgumentException("Index should be 0 or 1");
    }

    public static /* synthetic */ int[][] topk2d$default(double[][] dArray, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        return UtilsKt.topk2d(dArray, n, n2);
    }
}

