/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PluginPathManager;
import java.io.File;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.completion.full.line.FullLinePluginInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0007J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0012J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0007R\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/completion/full/line/FullLinePluginInfo;", "", "()V", "FULL_LINE_PLUGIN", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getFULL_LINE_PLUGIN", "()Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "FULL_LINE_PLUGIN$delegate", "Lkotlin/Lazy;", "ID", "", "get", "getSourceFile", "Ljava/io/File;", "path", "filename", "lang", "isBundled", "", "isGloballyDisabled", "isMarketplaceBuild", "readSourceFile", "intellij.fullLine.core"})
public final class FullLinePluginInfo {
    @NotNull
    public static final FullLinePluginInfo INSTANCE = new FullLinePluginInfo();
    @NotNull
    public static final String ID = "org.jetbrains.completion.full.line";
    @NotNull
    private static final Lazy FULL_LINE_PLUGIN$delegate = LazyKt.lazy((Function0)FULL_LINE_PLUGIN.2.INSTANCE);

    private FullLinePluginInfo() {
    }

    private final IdeaPluginDescriptor getFULL_LINE_PLUGIN() {
        Lazy lazy = FULL_LINE_PLUGIN$delegate;
        return (IdeaPluginDescriptor)lazy.getValue();
    }

    @Nullable
    public final IdeaPluginDescriptor get() {
        return this.getFULL_LINE_PLUGIN();
    }

    public final boolean isGloballyDisabled() {
        if (AppMode.isRemoteDevHost()) {
            return !Boolean.parseBoolean(System.getProperty("full.line.remotedev"));
        }
        return false;
    }

    public final boolean isMarketplaceBuild() {
        IdeaPluginDescriptor ideaPluginDescriptor = this.get();
        return ideaPluginDescriptor != null ? !ideaPluginDescriptor.isBundled() : false;
    }

    public final boolean isBundled() {
        IdeaPluginDescriptor ideaPluginDescriptor = this.get();
        return ideaPluginDescriptor != null ? ideaPluginDescriptor.isBundled() : false;
    }

    @TestOnly
    @NotNull
    public final File getSourceFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = PluginPathManager.getPluginHome((String)"full-line");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getPluginHome(...)");
        return FilesKt.resolve((File)file, (String)path);
    }

    @TestOnly
    @NotNull
    public final File getSourceFile(@NotNull String filename, @NotNull String lang) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        return this.getSourceFile(lang + "/testResources/" + filename);
    }

    @TestOnly
    @NotNull
    public final String readSourceFile(@NotNull String filename, @NotNull String lang) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        return FilesKt.readText$default((File)this.getSourceFile(lang + "/testResources/" + filename), null, (int)1, null);
    }
}

