/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.karma.execution;

import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.runners.RerunTestsAction;
import com.intellij.execution.runners.RerunTestsNotification;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.karma.execution.KarmaConsoleView;
import com.intellij.javascript.karma.execution.KarmaRunConfiguration;
import com.intellij.javascript.karma.execution.KarmaRunProgramRunner;
import com.intellij.javascript.karma.util.KarmaUtil;
import com.intellij.javascript.nodejs.debug.NodeDebuggableRunProfileState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0007H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/karma/execution/KarmaRunProgramRunner;", "Lcom/intellij/execution/runners/AsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "getRunnerId", "Companion", "intellij.karma"})
public final class KarmaRunProgramRunner
extends AsyncProgramRunner<RunnerSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getRunnerId() {
        return "KarmaJavaScriptTestRunnerRun";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return Intrinsics.areEqual((Object)"Run", (Object)executorId) && profile instanceof KarmaRunConfiguration;
    }

    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Promise promise = Companion.executeAsync(environment, state).then(arg_0 -> KarmaRunProgramRunner.execute$lambda$0((Function1)new Function1<ExecutionResult, RunContentDescriptor>(state, environment){
            final /* synthetic */ RunProfileState $state;
            final /* synthetic */ ExecutionEnvironment $environment;
            {
                this.$state = $state;
                this.$environment = $environment;
                super(1);
            }

            @Nullable
            public final RunContentDescriptor invoke(ExecutionResult executionResult) {
                KarmaConsoleView consoleView = KarmaConsoleView.get(executionResult, this.$state);
                RunContentDescriptor runContentDescriptor = KarmaUtil.createDefaultDescriptor(executionResult, this.$environment);
                Intrinsics.checkNotNullExpressionValue((Object)runContentDescriptor, (String)"createDefaultDescriptor(...)");
                RunContentDescriptor descriptor = runContentDescriptor;
                if (consoleView == null) {
                    return descriptor;
                }
                if (executionResult.getProcessHandler() instanceof NopProcessHandler) {
                    consoleView.getKarmaServer().onBrowsersReady(() -> execute.1.invoke$lambda$0(descriptor));
                } else {
                    RerunTestsNotification.showRerunNotification((RunContentDescriptor)this.$environment.getContentToReuse(), (ExecutionConsole)executionResult.getExecutionConsole());
                    RerunTestsAction.register((RunContentDescriptor)descriptor);
                }
                return descriptor;
            }

            private static final void invoke$lambda$0(RunContentDescriptor $descriptor) {
                Intrinsics.checkNotNullParameter((Object)$descriptor, (String)"$descriptor");
                ExecutionUtil.restartIfActive((RunContentDescriptor)$descriptor);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return promise;
    }

    private static final RunContentDescriptor execute$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (RunContentDescriptor)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/karma/execution/KarmaRunProgramRunner$Companion;", "", "()V", "executeAsync", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ExecutionResult;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "intellij.karma"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Promise<ExecutionResult> executeAsync(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
            Promise promise;
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            FileDocumentManager.getInstance().saveAllDocuments();
            if (state instanceof NodeDebuggableRunProfileState) {
                NodeDebuggableRunProfileState nodeDebuggableRunProfileState = (NodeDebuggableRunProfileState)state;
                Project project = environment.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                RunProfile runProfile = environment.getRunProfile();
                Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"getRunProfile(...)");
                promise = NodeDebuggableRunProfileState.Companion.execute(nodeDebuggableRunProfileState, project, runProfile, null);
            } else {
                ExecutionResult executionResult = state.execute(environment.getExecutor(), environment.getRunner());
                Intrinsics.checkNotNull((Object)executionResult);
                promise = Promises.resolvedPromise((Object)executionResult);
            }
            return promise;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

