/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.ide.impl.TrustedProjects;
import com.intellij.ide.trustedProjects.TrustedProjectsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.InitialVfsRefreshService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vcs.roots.VcsRootProblemNotifier;
import com.intellij.openapi.vcs.roots.VcsRootScanner;
import com.intellij.openapi.vcs.roots.VcsRootScannerKt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import java.util.Collection;
import java.util.List;
import java.util.MissingResourceException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\fH\u0016J\u0016\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\b\u0010\u0012\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/roots/VcsRootScanner;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "rootProblemNotifier", "Lcom/intellij/openapi/vcs/roots/VcsRootProblemNotifier;", "kotlin.jvm.PlatformType", "scanRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "dispose", "filesChanged", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "scheduleScan", "Companion", "DetectRootsStartupActivity", "TrustListener", "intellij.platform.vcs.impl"})
public final class VcsRootScanner
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final VcsRootProblemNotifier rootProblemNotifier;
    @NotNull
    private final MutableSharedFlow<Unit> scanRequests;

    public VcsRootScanner(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.rootProblemNotifier = VcsRootProblemNotifier.createInstance(this.project);
        this.scanRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        AsyncVfsEventsPostProcessor.getInstance().addListener(this::filesChanged, (Disposable)this);
        VcsRootChecker.EXTENSION_POINT_NAME.addChangeListener(this::scheduleScan, (Disposable)this);
        VcsEP.EP_NAME.addChangeListener(this::scheduleScan, (Disposable)this);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ VcsRootScanner this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)((Flow)this.this$0.scanRequests), (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS)), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ VcsRootScanner this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                            int label;
                                            final /* synthetic */ VcsRootScanner this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            /*
                                             * Unable to fully structure code
                                             */
                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)var1_1);
                                                        $this$service$iv = (ComponentManager)VcsRootScanner.access$getProject$p(this.this$0);
                                                        $i$f$service = false;
                                                        serviceClass$iv = InitialVfsRefreshService.class;
                                                        v0 = $this$service$iv.getService(serviceClass$iv);
                                                        if (v0 == null) {
                                                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                                                        }
                                                        this.label = 1;
                                                        v1 = ((InitialVfsRefreshService)v0).awaitInitialVfsRefreshFinished((Continuation)this);
                                                        if (v1 == var5_2) {
                                                            return var5_2;
                                                        }
                                                        ** GOTO lbl19
                                                    }
                                                    case 1: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v1 = $result;
lbl19:
                                                        // 2 sources

                                                        this.label = 2;
                                                        v2 = CoroutinesKt.coroutineToIndicator((Function0)((Function0)new Function0<Unit>(){

                                                            public final void invoke() {
                                                                this$0.rootProblemNotifier.rescanAndNotifyIfNeeded();
                                                            }
                                                        }), (Continuation)((Continuation)this));
                                                        if (v2 == var5_2) {
                                                            return var5_2;
                                                        }
                                                        ** GOTO lbl27
                                                    }
                                                    case 2: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        v2 = $result;
lbl27:
                                                        // 2 sources

                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull Unit p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void dispose() {
    }

    private final void filesChanged(List<? extends VFileEvent> events) {
        List checkers = VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList();
        if (checkers.isEmpty()) {
            return;
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            if (file == null || !file.isDirectory()) continue;
            Companion.visitDirsRecursivelyWithoutExcluded(this.project, file, true, (Function1<? super VirtualFile, VirtualFileVisitor.Result>)((Function1)new Function1<VirtualFile, VirtualFileVisitor.Result>((List<? extends VcsRootChecker>)checkers, this, file){
                final /* synthetic */ List<VcsRootChecker> $checkers;
                final /* synthetic */ VcsRootScanner this$0;
                final /* synthetic */ VirtualFile $file;
                {
                    this.$checkers = $checkers;
                    this.this$0 = $receiver;
                    this.$file = $file;
                    super(1);
                }

                @NotNull
                public final VirtualFileVisitor.Result invoke(@NotNull VirtualFile dir) {
                    Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                    String string = dir.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (com.intellij.openapi.vcs.roots.VcsRootScanner$Companion.access$isVcsDir(VcsRootScanner.Companion, this.$checkers, string)) {
                        VcsRootScanner.access$scheduleScan(this.this$0);
                        VirtualFileVisitor.Result result2 = VirtualFileVisitor.skipTo((VirtualFile)this.$file);
                        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"skipTo(...)");
                        return result2;
                    }
                    VirtualFileVisitor.Result result3 = VirtualFileVisitor.CONTINUE;
                    Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"CONTINUE");
                    return result3;
                }
            }));
        }
    }

    private final void scheduleScan() {
        if (VcsRootChecker.EXTENSION_POINT_NAME.getExtensionList().isEmpty()) {
            return;
        }
        ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("VcsRootScanner.scheduleScan");
        if (!VcsUtil.shouldDetectVcsMappingsFor((Project)this.project)) {
            return;
        }
        if (!this.scanRequests.tryEmit((Object)Unit.INSTANCE)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }

    @JvmStatic
    public static final void visitDirsRecursivelyWithoutExcluded(@NotNull Project project, @NotNull VirtualFile root, boolean visitIgnoredFoldersThemselves, @NotNull Function1<? super VirtualFile, VirtualFileVisitor.Result> processor2) {
        Companion.visitDirsRecursivelyWithoutExcluded(project, root, visitIgnoredFoldersThemselves, processor2);
    }

    @JvmStatic
    public static final boolean isUnderIgnoredDirectory(@NotNull Project project, @Nullable Pattern ignorePattern, @Nullable VirtualFile dir) {
        return Companion.isUnderIgnoredDirectory(project, ignorePattern, dir);
    }

    @JvmStatic
    @Nullable
    public static final Pattern parseDirIgnorePattern() {
        return Companion.parseDirIgnorePattern();
    }

    public static final /* synthetic */ Project access$getProject$p(VcsRootScanner $this) {
        return $this.project;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u001e\u0010\r\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0007J4\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\b2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001a0\u0019H\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/roots/VcsRootScanner$Companion;", "", "()V", "getInstance", "Lcom/intellij/openapi/vcs/roots/VcsRootScanner;", "project", "Lcom/intellij/openapi/project/Project;", "isUnderIgnoredDirectory", "", "ignorePattern", "Ljava/util/regex/Pattern;", "dir", "Lcom/intellij/openapi/vfs/VirtualFile;", "isVcsDir", "checkers", "", "Lcom/intellij/openapi/vcs/VcsRootChecker;", "filePath", "", "parseDirIgnorePattern", "visitDirsRecursivelyWithoutExcluded", "", "root", "visitIgnoredFoldersThemselves", "processor", "Lkotlin/Function1;", "Lcom/intellij/openapi/vfs/VirtualFileVisitor$Result;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nVcsRootScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsRootScanner.kt\ncom/intellij/openapi/vcs/roots/VcsRootScanner$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,224:1\n31#2,2:225\n1747#3,3:227\n*S KotlinDebug\n*F\n+ 1 VcsRootScanner.kt\ncom/intellij/openapi/vcs/roots/VcsRootScanner$Companion\n*L\n74#1:225,2\n121#1:227,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VcsRootScanner getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<VcsRootScanner> serviceClass$iv = VcsRootScanner.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (VcsRootScanner)object;
        }

        @JvmStatic
        public final void visitDirsRecursivelyWithoutExcluded(@NotNull Project project, @NotNull VirtualFile root, boolean visitIgnoredFoldersThemselves, @NotNull Function1<? super VirtualFile, VirtualFileVisitor.Result> processor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter(processor2, (String)"processor");
            ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
            ProjectFileIndex fileIndex = projectFileIndex;
            VirtualFileVisitor.Option option = VirtualFileVisitor.limit((int)Registry.intValue((String)"vcs.root.detector.folder.depth"));
            Intrinsics.checkNotNullExpressionValue((Object)option, (String)"limit(...)");
            VirtualFileVisitor.Option depthLimit = option;
            Pattern ignorePattern = this.parseDirIgnorePattern();
            if (this.isUnderIgnoredDirectory(project, ignorePattern, visitIgnoredFoldersThemselves ? root.getParent() : root)) {
                return;
            }
            VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS, depthLimit};
            VirtualFileVisitor.Option[] optionArray2 = optionArray;
            VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(visitIgnoredFoldersThemselves, processor2, project, ignorePattern, fileIndex, optionArray2){
                final /* synthetic */ boolean $visitIgnoredFoldersThemselves;
                final /* synthetic */ Function1<VirtualFile, VirtualFileVisitor.Result> $processor;
                final /* synthetic */ Project $project;
                final /* synthetic */ Pattern $ignorePattern;
                final /* synthetic */ ProjectFileIndex $fileIndex;
                {
                    this.$visitIgnoredFoldersThemselves = $visitIgnoredFoldersThemselves;
                    this.$processor = $processor;
                    this.$project = $project;
                    this.$ignorePattern = $ignorePattern;
                    this.$fileIndex = $fileIndex;
                    super($super_call_param$1);
                }

                @NotNull
                public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                    VirtualFileVisitor.Result apply;
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    if (!file.isDirectory()) {
                        VirtualFileVisitor.Result result2 = VirtualFileVisitor.CONTINUE;
                        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"CONTINUE");
                        return result2;
                    }
                    if (this.$visitIgnoredFoldersThemselves && !Intrinsics.areEqual((Object)(apply = (VirtualFileVisitor.Result)this.$processor.invoke((Object)file)), (Object)VirtualFileVisitor.CONTINUE)) {
                        return apply;
                    }
                    if (VcsRootScannerKt.access$isIgnoredDirectory(this.$project, this.$ignorePattern, file)) {
                        VirtualFileVisitor.Result result3 = VirtualFileVisitor.SKIP_CHILDREN;
                        Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"SKIP_CHILDREN");
                        return result3;
                    }
                    Object object = ReadAction.compute(() -> visitDirsRecursivelyWithoutExcluded.1.visitFileEx$lambda$0(this.$project, this.$fileIndex, file));
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
                    if (((Boolean)object).booleanValue()) {
                        VirtualFileVisitor.Result result4 = VirtualFileVisitor.SKIP_CHILDREN;
                        Intrinsics.checkNotNullExpressionValue((Object)result4, (String)"SKIP_CHILDREN");
                        return result4;
                    }
                    if (!this.$visitIgnoredFoldersThemselves && !Intrinsics.areEqual((Object)(apply = (VirtualFileVisitor.Result)this.$processor.invoke((Object)file)), (Object)VirtualFileVisitor.CONTINUE)) {
                        return apply;
                    }
                    VirtualFileVisitor.Result result5 = VirtualFileVisitor.CONTINUE;
                    Intrinsics.checkNotNullExpressionValue((Object)result5, (String)"CONTINUE");
                    return result5;
                }

                private static final Boolean visitFileEx$lambda$0(Project $project, ProjectFileIndex $fileIndex, VirtualFile $file) {
                    Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                    Intrinsics.checkNotNullParameter((Object)$fileIndex, (String)"$fileIndex");
                    Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
                    return $project.isDisposed() || !$fileIndex.isInContent($file);
                }
            }));
        }

        private final boolean isVcsDir(List<? extends VcsRootChecker> checkers, String filePath) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = checkers;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        VcsRootChecker it = (VcsRootChecker)element$iv;
                        boolean bl2 = false;
                        if (!it.isVcsDir(filePath)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @JvmStatic
        public final boolean isUnderIgnoredDirectory(@NotNull Project project, @Nullable Pattern ignorePattern, @Nullable VirtualFile dir) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            for (VirtualFile parent = dir; parent != null; parent = parent.getParent()) {
                if (!VcsRootScannerKt.access$isIgnoredDirectory(project, ignorePattern, parent)) continue;
                return true;
            }
            return false;
        }

        @JvmStatic
        @Nullable
        public final Pattern parseDirIgnorePattern() {
            try {
                return Pattern.compile(Registry.stringValue((String)"vcs.root.detector.ignore.pattern"));
            }
            catch (MissingResourceException e) {
                VcsRootScannerKt.access$getLOG$p().warn((Throwable)e);
                return null;
            }
            catch (PatternSyntaxException e) {
                VcsRootScannerKt.access$getLOG$p().warn((Throwable)e);
                return null;
            }
        }

        public static final /* synthetic */ boolean access$isVcsDir(Companion $this, List checkers, String filePath) {
            return $this.isVcsDir(checkers, filePath);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/roots/VcsRootScanner$DetectRootsStartupActivity;", "Lcom/intellij/openapi/vcs/impl/VcsStartupActivity;", "()V", "order", "", "getOrder", "()I", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class DetectRootsStartupActivity
    implements VcsStartupActivity {
        @Override
        public int getOrder() {
            return VcsInitObject.AFTER_COMMON.getOrder();
        }

        @Override
        public void runActivity(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            if (!TrustedProjects.isTrusted((Project)project)) {
                return;
            }
            ProjectLevelVcsManagerEx.MAPPING_DETECTION_LOG.debug("VcsRootScanner.start activity");
            Companion.getInstance(project).scheduleScan();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/roots/VcsRootScanner$TrustListener;", "Lcom/intellij/ide/trustedProjects/TrustedProjectsListener;", "()V", "onProjectTrusted", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.vcs.impl"})
    public static final class TrustListener
    implements TrustedProjectsListener {
        public void onProjectTrusted(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ProjectLevelVcsManager.getInstance((Project)project).runAfterInitialization(() -> TrustListener.onProjectTrusted$lambda$0(project));
        }

        private static final void onProjectTrusted$lambda$0(Project $project) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Companion.getInstance($project).scheduleScan();
        }
    }
}

