/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.impl.RepositoryBrowserPanel;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0001\u0010\u0013\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/impl/RepositoryBrowser;", "", "()V", "TOOLWINDOW_ID", "", "getIcon", "Ljavax/swing/Icon;", "registerRepositoriesToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "showRepositoryBrowser", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;", "localRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "title", "intellij.platform.vcs.impl"})
public final class RepositoryBrowser {
    @NotNull
    public static final RepositoryBrowser INSTANCE = new RepositoryBrowser();
    @NotNull
    public static final String TOOLWINDOW_ID = "Repositories";

    private RepositoryBrowser() {
    }

    public final void showRepositoryBrowser(@NotNull Project project, @NotNull AbstractVcsVirtualFile root, @NotNull VirtualFile localRoot, @NlsContexts.TabTitle @NotNull String title2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)root), (String)"root");
        Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindow toolWindow = toolWindowManager.getToolWindow(TOOLWINDOW_ID);
        if (toolWindow == null) {
            toolWindow = this.registerRepositoriesToolWindow(toolWindowManager);
        }
        ToolWindow repoToolWindow = toolWindow;
        Content[] contentArray = repoToolWindow.getContentManager().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        for (Content content : contentArray) {
            RepositoryBrowserPanel component;
            JComponent jComponent = content.getComponent();
            RepositoryBrowserPanel repositoryBrowserPanel = jComponent instanceof RepositoryBrowserPanel ? (RepositoryBrowserPanel)jComponent : null;
            if (repositoryBrowserPanel == null || !Intrinsics.areEqual((Object)((Object)(component = repositoryBrowserPanel).getRoot()), (Object)((Object)root))) continue;
            repoToolWindow.getContentManager().setSelectedContent(content);
            repoToolWindow.activate(null);
            return;
        }
        RepositoryBrowserPanel contentPanel = new RepositoryBrowserPanel(project, root, localRoot);
        Content content = ContentFactory.getInstance().createContent((JComponent)contentPanel, title2, true);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        repoToolWindow.getContentManager().addContent(content2);
        repoToolWindow.getContentManager().setSelectedContent(content2, true);
        repoToolWindow.activate(null);
    }

    private final ToolWindow registerRepositoriesToolWindow(ToolWindowManager toolWindowManager) {
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
        Supplier supplier = VcsBundle.messagePointer((String)"RepositoryBrowser.toolwindow.name", (Object[])new Object[0]);
        Icon icon = this.getIcon();
        Intrinsics.checkNotNull((Object)toolWindowAnchor);
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(new RegisterToolWindowTask(TOOLWINDOW_ID, toolWindowAnchor, null, false, true, false, false, null, icon, supplier, 236, null));
        ContentManagerWatcher.watchContentManager((ToolWindow)toolWindow, (ContentManager)toolWindow.getContentManager());
        return toolWindow;
    }

    private final Icon getIcon() {
        return ExperimentalUI.Companion.isNewUI() ? AllIcons.Toolwindows.Repositories : null;
    }
}

