/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\f0\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/changes/ProjectExcludesIgnoredFileProvider;", "Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;", "()V", "getIgnoredFiles", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getIgnoredGroupDescription", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getProjectExcludePaths", "isIgnoredFile", "", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nProjectExcludesIgnoredFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectExcludesIgnoredFileProvider.kt\ncom/intellij/openapi/vcs/changes/ProjectExcludesIgnoredFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1549#2:63\n1620#2,3:64\n*S KotlinDebug\n*F\n+ 1 ProjectExcludesIgnoredFileProvider.kt\ncom/intellij/openapi/vcs/changes/ProjectExcludesIgnoredFileProvider\n*L\n60#1:63\n60#1:64,3\n*E\n"})
public final class ProjectExcludesIgnoredFileProvider
implements IgnoredFileProvider {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isIgnoredFile(@NotNull Project project, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (!VcsApplicationSettings.getInstance().MARK_EXCLUDED_AS_IGNORED) return false;
        if (Registry.is((String)"ide.hide.excluded.files")) return false;
        VirtualFile virtualFile = filePath.getVirtualFile();
        if (virtualFile == null) return false;
        VirtualFile file = virtualFile;
        boolean bl = false;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        if (!projectFileIndex2.isExcluded(file)) return false;
        if (projectFileIndex2.isUnderIgnored(file)) return false;
        return true;
    }

    @NotNull
    public Set<IgnoredFileDescriptor> getIgnoredFiles(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getProjectExcludePaths(project);
    }

    @NotNull
    public String getIgnoredGroupDescription() {
        String string = VcsBundle.message((String)"changes.project.exclude.paths", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<IgnoredFileDescriptor> getProjectExcludePaths(Project project) {
        void $this$mapTo$iv$iv;
        if (!VcsApplicationSettings.getInstance().MARK_EXCLUDED_AS_IGNORED) {
            return SetsKt.emptySet();
        }
        Comparator<VirtualFile> comparator = ChangesComparator.getVirtualFileComparator(false);
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"getVirtualFileComparator(...)");
        TreeSet excludes = SetsKt.sortedSetOf(comparator, (Object[])new VirtualFile[0]);
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        for (DirectoryIndexExcludePolicy policy : DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)project)) {
            String[] stringArray;
            Intrinsics.checkNotNullExpressionValue((Object)policy.getExcludeUrlsForProject(), (String)"getExcludeUrlsForProject(...)");
            for (String url : stringArray) {
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                if (file == null) continue;
                excludes.add(file);
            }
        }
        for (Module module : ModuleManager.Companion.getInstance(project).getModules()) {
            VirtualFile[] virtualFileArray;
            if (module.isDisposed()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)ModuleRootManager.getInstance((Module)module).getExcludeRoots(), (String)"getExcludeRoots(...)");
            for (VirtualFile excludeRoot : virtualFileArray) {
                if (((Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(fileIndex, excludeRoot){
                    final /* synthetic */ ProjectFileIndex $fileIndex;
                    final /* synthetic */ VirtualFile $excludeRoot;
                    {
                        this.$fileIndex = $fileIndex;
                        this.$excludeRoot = $excludeRoot;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return !this.$fileIndex.isExcluded(this.$excludeRoot);
                    }
                }))).booleanValue()) continue;
                excludes.add(excludeRoot);
            }
        }
        Iterable $this$map$iv = excludes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void file;
            VirtualFile excludeRoot;
            excludeRoot = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(IgnoredBeanFactory.ignoreFile((VirtualFile)file, (Project)project));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

