/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.google.common.collect.ObjectArrays;
import com.intellij.DynamicBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ThreeState;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.PySymbolFieldWithBrowseButton;
import com.jetbrains.python.extensions.ContextAnchor;
import com.jetbrains.python.extensions.ModuleBasedContextAnchor;
import com.jetbrains.python.extensions.ProjectSdkContextAnchor;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.reflection.ReflectionUtilsKt;
import com.jetbrains.python.reflection.SimplePropertiesProvider;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.PyBrowseActionListener;
import com.jetbrains.python.run.PyCommonOptionsFormFactory;
import com.jetbrains.python.run.PythonScriptCommandLineState;
import com.jetbrains.python.run.targetBasedConfiguration.PyRunTargetVariant;
import com.jetbrains.python.testing.OptionHolder;
import com.jetbrains.python.testing.PyAbstractTestConfiguration;
import com.jetbrains.python.testing.PyTestCustomOption;
import com.jetbrains.python.testing.PyTestsSharedKt;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.KCallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyTestSharedForm
implements SimplePropertiesProvider {
    private JPanel myPanel;
    private JPanel myTargets;
    private JPanel myOptionsPanel;
    private JPanel myCustomOptionsPanel;
    private JPanel myPanelForTargetFields;
    private final ButtonGroup myButtonGroup;
    private AbstractPyCommonOptionsForm myOptionsForm;
    private final Map<String, OptionHolder> myCustomOptions;
    private final TextFieldWithBrowseButton myPathTarget;
    private final PySymbolFieldWithBrowseButton myPythonTarget;

    @NotNull
    JPanel getPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            PyTestSharedForm.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @Override
    @NotNull
    public List<String> getPropertyNames() {
        return new ArrayList<String>(this.myCustomOptions.keySet());
    }

    @Override
    public void setPropertyValue(@NotNull String propertyName, @Nullable Object propertyValue) {
        if (propertyName == null) {
            PyTestSharedForm.$$$reportNull$$$0(1);
        }
        this.myCustomOptions.get(propertyName).setValue(propertyValue);
    }

    @Override
    @Nullable
    public Object getPropertyValue(@NotNull String propertyName) {
        if (propertyName == null) {
            PyTestSharedForm.$$$reportNull$$$0(2);
        }
        return this.myCustomOptions.get(propertyName).getValue();
    }

    private PyTestSharedForm(@Nullable Module module, @NotNull PyAbstractTestConfiguration configuration) {
        if (configuration == null) {
            PyTestSharedForm.$$$reportNull$$$0(3);
        }
        this.$$$setupUI$$$();
        this.myButtonGroup = new ButtonGroup();
        this.myCustomOptions = new LinkedHashMap<String, OptionHolder>();
        this.myPathTarget = new TextFieldWithBrowseButton();
        Project project2 = configuration.getProject();
        this.myPathTarget.addBrowseFolderListener((TextBrowseFolderListener)new PyBrowseActionListener(configuration));
        TypeEvalContext context = TypeEvalContext.userInitiated(project2, null);
        ThreeState testClassRequired = configuration.isTestClassRequired();
        ContextAnchor contentAnchor = module != null ? new ModuleBasedContextAnchor(module) : new ProjectSdkContextAnchor(project2, configuration.getSdk());
        this.myPythonTarget = new PySymbolFieldWithBrowseButton(contentAnchor, (Function1<? super PsiElement, Boolean>)((Function1)element -> {
            if (element instanceof PsiDirectory) {
                return true;
            }
            return PyTestsSharedKt.isTestElement(element, testClassRequired, context);
        }), (Function0<? extends VirtualFile>)((Function0)() -> {
            String workingDirectory = configuration.getWorkingDirectory();
            if (StringUtil.isEmpty((String)workingDirectory)) {
                return null;
            }
            return LocalFileSystem.getInstance().findFileByPath(PythonScriptCommandLineState.getExpandedWorkingDir(configuration));
        }));
    }

    public static void setBorderToPanel(@NotNull JPanel panel2, @NotNull @NlsSafe String title) {
        if (panel2 == null) {
            PyTestSharedForm.$$$reportNull$$$0(4);
        }
        if (title == null) {
            PyTestSharedForm.$$$reportNull$$$0(5);
        }
        panel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)title, (boolean)false));
    }

    @NotNull
    public static PyTestSharedForm create(@NotNull PyAbstractTestConfiguration configuration, PyTestCustomOption ... customOptions) {
        if (configuration == null) {
            PyTestSharedForm.$$$reportNull$$$0(6);
        }
        if (customOptions == null) {
            PyTestSharedForm.$$$reportNull$$$0(7);
        }
        PyTestSharedForm form = new PyTestSharedForm(configuration.getModule(), configuration);
        for (PyRunTargetVariant testTargetType : PyRunTargetVariant.values()) {
            JBRadioButton button = new JBRadioButton(StringUtil.capitalize((String)testTargetType.getCustomName().toLowerCase(Locale.getDefault())));
            button.setActionCommand(testTargetType.name());
            button.addActionListener(o -> form.onTargetTypeChanged());
            form.myButtonGroup.add((AbstractButton)button);
            form.myTargets.add((Component)button);
        }
        form.myButtonGroup.getElements().nextElement().setSelected(true);
        form.myOptionsForm = PyCommonOptionsFormFactory.getInstance().createForm(configuration.getCommonOptionsFormData());
        GridConstraints constraints = new GridConstraints();
        constraints.setFill(3);
        form.myOptionsPanel.add((Component)form.myOptionsForm.getMainPanel(), constraints);
        PyTestSharedForm.setBorderToPanel(form.myPanel, configuration.getTestFrameworkName());
        form.addCustomOptions((PyTestCustomOption[])ObjectArrays.concat((Object[])customOptions, (Object)new PyTestCustomOption((KCallable<?>)PyTestsSharedKt.getAdditionalArgumentsProperty(), PyRunTargetVariant.values())));
        configuration.copyTo(ReflectionUtilsKt.getProperties(form, null, true));
        PyTestSharedForm pyTestSharedForm = form;
        if (pyTestSharedForm == null) {
            PyTestSharedForm.$$$reportNull$$$0(8);
        }
        return pyTestSharedForm;
    }

    private void addCustomOptions(PyTestCustomOption ... customOptions) {
        if (customOptions == null) {
            PyTestSharedForm.$$$reportNull$$$0(9);
        }
        if (customOptions.length == 0) {
            return;
        }
        HashMap<String, JBCheckBox> optionValueFields = new HashMap<String, JBCheckBox>();
        for (PyTestCustomOption option : customOptions) {
            JBCheckBox textField = option.isBooleanType() ? new JBCheckBox() : new JBTextField();
            optionValueFields.put(option.getName(), textField);
        }
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = JBUI.insets((int)3);
        constraints.gridy = 0;
        constraints.anchor = 21;
        for (PyTestCustomOption option : customOptions) {
            JComponent field = (JComponent)optionValueFields.get(option.getName());
            JLabel label = new JLabel(option.getLocalizedName());
            label.setHorizontalAlignment(2);
            constraints.fill = 0;
            constraints.gridx = 0;
            constraints.weightx = 0.0;
            this.myCustomOptionsPanel.add((Component)label, constraints);
            constraints.gridx = 1;
            constraints.weightx = 1.0;
            constraints.fill = 2;
            this.myCustomOptionsPanel.add((Component)field, constraints);
            ++constraints.gridy;
            OptionHolder value = option.isBooleanType() ? new OptionHolder(option, label, (JCheckBox)((JBCheckBox)field)) : new OptionHolder(option, label, (JTextComponent)((JBTextField)field));
            this.myCustomOptions.put(option.getName(), value);
        }
    }

    @NotNull
    AbstractPyCommonOptionsForm getOptionsForm() {
        AbstractPyCommonOptionsForm abstractPyCommonOptionsForm = this.myOptionsForm;
        if (abstractPyCommonOptionsForm == null) {
            PyTestSharedForm.$$$reportNull$$$0(10);
        }
        return abstractPyCommonOptionsForm;
    }

    @NotNull
    public String getTarget() {
        String targetText = this.getActiveTextField().getText().trim();
        String string = this.getTargetType() == PyRunTargetVariant.PATH ? FileUtil.toSystemIndependentName((String)targetText) : targetText;
        if (string == null) {
            PyTestSharedForm.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void setTarget(@NotNull String targetText) {
        if (targetText == null) {
            PyTestSharedForm.$$$reportNull$$$0(12);
        }
        this.getActiveTextField().setText(targetText);
    }

    private void onTargetTypeChanged() {
        PyRunTargetVariant targetType = this.getTargetType();
        for (OptionHolder optionHolder : this.myCustomOptions.values()) {
            optionHolder.setType(targetType);
        }
        Arrays.stream(this.myPanelForTargetFields.getComponents()).forEach(this.myPanelForTargetFields::remove);
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.weightx = 1.0;
        if (targetType == PyRunTargetVariant.PATH) {
            this.myPanelForTargetFields.add((Component)this.myPathTarget, cons);
        } else if (targetType == PyRunTargetVariant.PYTHON) {
            this.myPanelForTargetFields.add((Component)((Object)this.myPythonTarget), cons);
        }
    }

    @NotNull
    private TextAccessor getActiveTextField() {
        Object object = this.getTargetType() == PyRunTargetVariant.PATH ? this.myPathTarget : this.myPythonTarget;
        if (object == null) {
            PyTestSharedForm.$$$reportNull$$$0(13);
        }
        return object;
    }

    @NotNull
    public PyRunTargetVariant getTargetType() {
        PyRunTargetVariant pyRunTargetVariant = PyRunTargetVariant.valueOf(this.myButtonGroup.getSelection().getActionCommand());
        if (pyRunTargetVariant == null) {
            PyTestSharedForm.$$$reportNull$$$0(14);
        }
        return pyRunTargetVariant;
    }

    public void setTargetType(@NotNull PyRunTargetVariant target) {
        if (target == null) {
            PyTestSharedForm.$$$reportNull$$$0(15);
        }
        Enumeration<AbstractButton> elements = this.myButtonGroup.getElements();
        while (elements.hasMoreElements()) {
            AbstractButton button = elements.nextElement();
            if (PyRunTargetVariant.valueOf(button.getActionCommand()) != target) continue;
            this.myButtonGroup.setSelected(button.getModel(), true);
            break;
        }
        this.onTargetTypeChanged();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        this.myPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel5).setEnabled(false);
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PyBundle", PyTestSharedForm.class).getString("form.test.shared.test"), (int)0, (int)0, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 7, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PyBundle", PyTestSharedForm.class).getString("form.test.shared.target"));
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myTargets = jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1, 5, 5));
        jPanel6.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCustomOptionsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel5.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
        this.myPanelForTargetFields = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel5.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 9, 12, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/testing/PyTestSharedForm";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customOptions";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetText";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/testing/PyTestSharedForm";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsForm";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTarget";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveTextField";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setPropertyValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setBorderToPanel";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addCustomOptions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setTarget";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setTargetType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 9, 12, 15 -> new IllegalArgumentException(string);
        };
    }
}

