/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.extensions.ModuleExtKt;
import com.jetbrains.python.packaging.PyPIPackageCache;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.statistics.InterpreterTarget;
import com.jetbrains.python.statistics.InterpreterType;
import com.jetbrains.python.statistics.PyPackageUsagesCollectorKt;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\u0004H\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/python/statistics/PyPackageVersionUsagesCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "PYTHON_PACKAGE_INSTALLED", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "PYTHON_PACKAGE_INSTALLED_IN_SDK", "getGroup", "getInstalledPackages", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "getMetrics", "getPackages", "requiresReadAccess", "", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyPackageUsagesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPackageUsagesCollector.kt\ncom/jetbrains/python/statistics/PyPackageVersionUsagesCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n766#2:92\n857#2,2:93\n1855#2,2:95\n766#2:97\n857#2,2:98\n1855#2,2:100\n*S KotlinDebug\n*F\n+ 1 PyPackageUsagesCollector.kt\ncom/jetbrains/python/statistics/PyPackageVersionUsagesCollector\n*L\n50#1:92\n50#1:93,2\n51#1:95,2\n73#1:97\n73#1:98,2\n74#1:100,2\n*E\n"})
public final class PyPackageVersionUsagesCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("python.packages", 6, null, 4, null);
    @NotNull
    private final VarargEventId PYTHON_PACKAGE_INSTALLED;
    @NotNull
    private final VarargEventId PYTHON_PACKAGE_INSTALLED_IN_SDK;

    public PyPackageVersionUsagesCollector() {
        EventField[] eventFieldArray = new EventField[]{PyPackageUsagesCollectorKt.getPACKAGE_FIELD(), PyPackageUsagesCollectorKt.getPACKAGE_VERSION_FIELD()};
        this.PYTHON_PACKAGE_INSTALLED = PyStatisticToolsKt.registerPythonSpecificEvent(this.GROUP, "python_package_installed", eventFieldArray);
        eventFieldArray = new EventField[]{PyStatisticToolsKt.getEXECUTION_TYPE(), PyStatisticToolsKt.getINTERPRETER_TYPE(), PyPackageUsagesCollectorKt.getPACKAGE_FIELD(), PyPackageUsagesCollectorKt.getPACKAGE_VERSION_FIELD()};
        this.PYTHON_PACKAGE_INSTALLED_IN_SDK = this.GROUP.registerVarargEvent("python_packages_installed_in_sdk", eventFieldArray);
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return SetsKt.plus(this.getPackages(project2), (Iterable)this.getInstalledPackages(project2));
    }

    protected boolean requiresReadAccess() {
        return true;
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<MetricEvent> getPackages(Project project2) {
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        PyPIPackageCache pyPIPackageCache = PyPIPackageCache.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)pyPIPackageCache, (String)"getInstance(...)");
        PyPIPackageCache pypiPackages = pyPIPackageCache;
        for (Module module : PyStatisticToolsKt.getModules(project2)) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Sdk sdk2;
            if (ModuleExtKt.getSdk(module) == null || !PythonSdkUtil.isPythonSdk(sdk2)) continue;
            List<EventPair<?>> usageData = PyStatisticToolsKt.getPythonSpecificInfo(sdk2);
            List list = PyPackageManager.getInstance(sdk2).getRequirements(module);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable iterable = list;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PyRequirement it = (PyRequirement)element$iv$iv;
                boolean bl = false;
                if (!pypiPackages.containsPackage(it.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                PyRequirement req;
                block8: {
                    block7: {
                        String string;
                        req = (PyRequirement)element$iv;
                        boolean bl = false;
                        ProgressManager.checkCanceled();
                        List<PyRequirementVersionSpec> list2 = req.getVersionSpecs();
                        Intrinsics.checkNotNullExpressionValue(list2, (String)"getVersionSpecs(...)");
                        object = (PyRequirementVersionSpec)CollectionsKt.firstOrNull(list2);
                        if (object == null || (object = (string = object.getVersion())) == null) break block7;
                        Intrinsics.checkNotNull((Object)object);
                        object = ((Object)StringsKt.trim((CharSequence)string)).toString();
                        if (object != null) break block8;
                    }
                    object = "unknown";
                }
                Object version2 = object;
                ArrayList<EventPair> data = new ArrayList<EventPair>((Collection)usageData);
                StringEventField stringEventField = PyPackageUsagesCollectorKt.getPACKAGE_FIELD();
                String string = req.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                data.add(stringEventField.with((Object)PyStatisticToolsKt.normalizePackageName(string)));
                data.add(PyPackageUsagesCollectorKt.getPACKAGE_VERSION_FIELD().with(version2));
                result2.add(this.PYTHON_PACKAGE_INSTALLED.metric((List)data));
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<MetricEvent> getInstalledPackages(Project project2) {
        HashSet<MetricEvent> result2 = new HashSet<MetricEvent>();
        PyPIPackageCache pyPIPackageCache = PyPIPackageCache.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)pyPIPackageCache, (String)"getInstance(...)");
        PyPIPackageCache pypiPackages = pyPIPackageCache;
        for (Module module : PyStatisticToolsKt.getModules(project2)) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Sdk sdk2;
            if (ModuleExtKt.getSdk(module) == null || !PythonSdkUtil.isPythonSdk(sdk2) || !(sdk2.getSdkAdditionalData() instanceof PythonSdkAdditionalData)) continue;
            InterpreterTarget executionType = PyStatisticToolsKt.getExecutionType(sdk2);
            InterpreterType interpreterType = PyStatisticToolsKt.getInterpreterType(sdk2);
            Iterable iterable = PythonPackageManager.Companion.forSdk(project2, sdk2).getInstalledPackages();
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PythonPackage it = (PythonPackage)element$iv$iv;
                boolean bl = false;
                if (!pypiPackages.containsPackage(it.getName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List list;
                PythonPackage pythonPackage = (PythonPackage)element$iv;
                boolean bl = false;
                String version2 = pythonPackage.getVersion();
                List $this$getInstalledPackages_u24lambda_u244_u24lambda_u243 = list = CollectionsKt.createListBuilder();
                boolean bl2 = false;
                $this$getInstalledPackages_u24lambda_u244_u24lambda_u243.add(PyPackageUsagesCollectorKt.getPACKAGE_FIELD().with((Object)PyStatisticToolsKt.normalizePackageName(pythonPackage.getName())));
                $this$getInstalledPackages_u24lambda_u244_u24lambda_u243.add(PyPackageUsagesCollectorKt.getPACKAGE_VERSION_FIELD().with((Object)version2));
                $this$getInstalledPackages_u24lambda_u244_u24lambda_u243.add(PyStatisticToolsKt.getEXECUTION_TYPE().with((Object)executionType.getValue()));
                $this$getInstalledPackages_u24lambda_u244_u24lambda_u243.add(PyStatisticToolsKt.getINTERPRETER_TYPE().with((Object)interpreterType.getValue()));
                List data = CollectionsKt.build((List)list);
                result2.add(this.PYTHON_PACKAGE_INSTALLED_IN_SDK.metric(data));
            }
        }
        return result2;
    }
}

