/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.spellchecker;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyStringFormatParser;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstStringElement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.impl.PyStringLiteralDecoder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PythonSpellcheckerStrategy
extends SpellcheckingStrategy {
    private final StringLiteralTokenizer myStringLiteralTokenizer = new StringLiteralTokenizer();
    private final FormatStringTokenizer myFormatStringTokenizer = new FormatStringTokenizer();

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof PyStringLiteralExpression) {
            PyBinaryExpression binaryExpression;
            InjectedLanguageManager injectionManager = InjectedLanguageManager.getInstance((Project)element.getProject());
            if (element.getTextLength() >= 2 && injectionManager.getInjectedPsiFiles(element) != null) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    PythonSpellcheckerStrategy.$$$reportNull$$$0(0);
                }
                return tokenizer;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof PyBinaryExpression && element == (binaryExpression = (PyBinaryExpression)parent).getLeftExpression() && binaryExpression.getOperator() == PyTokenTypes.PERC) {
                FormatStringTokenizer formatStringTokenizer = this.myFormatStringTokenizer;
                if (formatStringTokenizer == null) {
                    PythonSpellcheckerStrategy.$$$reportNull$$$0(1);
                }
                return formatStringTokenizer;
            }
            StringLiteralTokenizer stringLiteralTokenizer = this.myStringLiteralTokenizer;
            if (stringLiteralTokenizer == null) {
                PythonSpellcheckerStrategy.$$$reportNull$$$0(2);
            }
            return stringLiteralTokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            PythonSpellcheckerStrategy.$$$reportNull$$$0(3);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/spellchecker/PythonSpellcheckerStrategy", "getTokenizer"));
    }

    private static class StringLiteralTokenizer
    extends Tokenizer<PyStringLiteralExpression> {
        private StringLiteralTokenizer() {
        }

        public void tokenize(@NotNull PyStringLiteralExpression element, @NotNull TokenConsumer consumer) {
            if (element == null) {
                StringLiteralTokenizer.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                StringLiteralTokenizer.$$$reportNull$$$0(1);
            }
            PlainTextSplitter splitter = PlainTextSplitter.getInstance();
            for (PyStringElement stringElement : element.getStringElements()) {
                List<TextRange> literalPartRanges = stringElement.isFormatted() ? ((PyFormattedStringElement)stringElement).getLiteralPartRanges() : Collections.singletonList(stringElement.getContentRange());
                PyStringLiteralDecoder decoder = new PyStringLiteralDecoder((PyAstStringElement)stringElement);
                boolean containsEscapes = stringElement.textContains('\\');
                for (TextRange literalPartRange : literalPartRanges) {
                    List escapeAwareRanges = stringElement.isRaw() || !containsEscapes ? Collections.singletonList(literalPartRange) : ContainerUtil.map((Collection)decoder.decodeRange(literalPartRange), x -> (TextRange)x.getFirst());
                    for (TextRange escapeAwareRange : escapeAwareRanges) {
                        String valueText = escapeAwareRange.substring(stringElement.getText());
                        consumer.consumeToken((PsiElement)stringElement, valueText, false, escapeAwareRange.getStartOffset(), TextRange.allOf((String)valueText), (Splitter)splitter);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/spellchecker/PythonSpellcheckerStrategy$StringLiteralTokenizer";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FormatStringTokenizer
    extends Tokenizer<PyStringLiteralExpression> {
        private FormatStringTokenizer() {
        }

        public void tokenize(@NotNull PyStringLiteralExpression element, @NotNull TokenConsumer consumer) {
            if (element == null) {
                FormatStringTokenizer.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                FormatStringTokenizer.$$$reportNull$$$0(1);
            }
            String stringValue = element.getStringValue();
            List<PyStringFormatParser.FormatStringChunk> chunks = PyStringFormatParser.parsePercentFormat(stringValue);
            PlainTextSplitter splitter = PlainTextSplitter.getInstance();
            for (PyStringFormatParser.FormatStringChunk chunk : chunks) {
                if (!(chunk instanceof PyStringFormatParser.ConstantChunk)) continue;
                int startIndex = element.valueOffsetToTextOffset(chunk.getStartIndex());
                int endIndex = element.valueOffsetToTextOffset(chunk.getEndIndex());
                String text = element.getText().substring(startIndex, endIndex);
                consumer.consumeToken((PsiElement)element, text, false, startIndex, TextRange.allOf((String)text), (Splitter)splitter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/spellchecker/PythonSpellcheckerStrategy$FormatStringTokenizer";
            objectArray[2] = "tokenize";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

