/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.icons.PythonIcons;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PyFlavorData;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.VirtualEnvReader;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VirtualEnvSdkFlavor
extends CPythonSdkFlavor<PyFlavorData.Empty> {
    private static final Set<String> NAMES = Set.of("jython", "pypy", "python", "jython.bat", "pypy.exe", "python.exe");
    private static final Pattern PATTERN = Pattern.compile("");

    private VirtualEnvSdkFlavor() {
    }

    public static VirtualEnvSdkFlavor getInstance() {
        return (VirtualEnvSdkFlavor)PythonSdkFlavor.EP_NAME.findExtension(VirtualEnvSdkFlavor.class);
    }

    @Override
    public boolean isPlatformIndependent() {
        return true;
    }

    @Override
    @NotNull
    public Class<PyFlavorData.Empty> getFlavorDataClass() {
        return PyFlavorData.Empty.class;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull Path> suggestLocalHomePaths(@Nullable Module module, @Nullable UserDataHolder context) {
        Collection collection = (Collection)ReadAction.compute(() -> {
            VirtualFile dir;
            ArrayList<Path> candidates = new ArrayList<Path>();
            VirtualFile baseDirFromModule = module == null ? null : BasePySdkExtKt.getBaseDir(module);
            Path baseDirFromContext = context == null ? null : (Path)context.getUserData(PySdkExtKt.getBASE_DIR());
            VirtualEnvReader reader = VirtualEnvReader.getInstance();
            if (baseDirFromModule != null) {
                candidates.addAll(reader.findLocalInterpreters(baseDirFromModule.toNioPath(), NAMES, PATTERN));
            } else if (baseDirFromContext != null && (dir = VfsUtil.findFile((Path)baseDirFromContext, (boolean)false)) != null) {
                candidates.addAll(reader.findLocalInterpreters(dir.toNioPath(), NAMES, PATTERN));
            }
            candidates.addAll(reader.findVEnvInterpreters(NAMES, PATTERN));
            candidates.addAll(reader.findPyenvInterpreters(NAMES, PATTERN));
            return ContainerUtil.filter(candidates, path2 -> PythonSdkUtil.isVirtualEnv(path2.toString()));
        });
        if (collection == null) {
            VirtualEnvSdkFlavor.$$$reportNull$$$0(0);
        }
        return collection;
    }

    public static Path getDefaultLocation() {
        return VirtualEnvReader.getInstance().getVEnvRootDir();
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            VirtualEnvSdkFlavor.$$$reportNull$$$0(1);
        }
        if (!super.isValidSdkPath(file)) {
            return false;
        }
        return PythonSdkUtil.getVirtualEnvRoot(file.getPath()) != null;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = PythonIcons.Python.Virtualenv;
        if (icon == null) {
            VirtualEnvSdkFlavor.$$$reportNull$$$0(2);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/flavors/VirtualEnvSdkFlavor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestLocalHomePaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/flavors/VirtualEnvSdkFlavor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

