/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.google.common.io.Resources;
import com.intellij.openapi.util.Version;
import com.intellij.util.Url;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.Product;
import com.jetbrains.python.sdk.Release;
import com.jetbrains.python.sdk.Sdks;
import com.jetbrains.python.sdk.SdksKeeper;
import com.jetbrains.python.sdk.SdksKt;
import com.jetbrains.python.sdk.UrlDeserializer;
import com.jetbrains.python.sdk.UrlSerializer;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0014\b\u0002\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0002J\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0017J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/python/sdk/SdksKeeper;", "", "()V", "configUrl", "Ljava/net/URL;", "sdks", "Lcom/jetbrains/python/sdk/Sdks;", "getSdks", "()Lcom/jetbrains/python/sdk/Sdks;", "sdks$delegate", "Lkotlin/Lazy;", "condaReleases", "", "Lcom/jetbrains/python/sdk/Release;", "products", "", "Lcom/jetbrains/python/sdk/Product;", "([Lcom/jetbrains/python/sdk/Product;)Ljava/util/List;", "deserialize", "content", "", "load", "pythonReleasesByLanguageLevel", "", "Lcom/jetbrains/python/psi/LanguageLevel;", "serialize", "intellij.python.sdk"})
@SourceDebugExtension(value={"SMAP\nSdks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sdks.kt\ncom/jetbrains/python/sdk/SdksKeeper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,175:1\n1603#2,9:176\n1855#2:185\n1856#2:188\n1612#2:189\n1490#2:190\n1520#2,3:191\n1523#2,3:201\n766#2:204\n857#2,2:205\n1#3:186\n1#3:187\n372#4,7:194\n*S KotlinDebug\n*F\n+ 1 Sdks.kt\ncom/jetbrains/python/sdk/SdksKeeper\n*L\n140#1:176,9\n140#1:185\n140#1:188\n140#1:189\n142#1:190\n142#1:191,3\n142#1:201,3\n146#1:204\n146#1:205,2\n140#1:187\n142#1:194,7\n*E\n"})
public final class SdksKeeper {
    @NotNull
    public static final SdksKeeper INSTANCE = new SdksKeeper();
    @Nullable
    private static final URL configUrl = Sdks.class.getResource("/sdks.json");
    @NotNull
    private static final Lazy sdks$delegate = LazyKt.lazy((Function0)sdks.2.INSTANCE);

    private SdksKeeper() {
    }

    @NotNull
    public final Sdks getSdks() {
        Lazy lazy = sdks$delegate;
        return (Sdks)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<LanguageLevel, List<Release>> pythonReleasesByLanguageLevel() {
        void $this$groupByTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.getSdks().getPython();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Release release = (Release)element$iv$iv;
            boolean bl2 = false;
            Version version2 = Version.parseVersion((String)release.getVersion());
            if (version2 != null && (version2 = SdksKt.toLanguageLevel(version2)) != null) {
                Version it = version2;
                boolean bl3 = false;
                pair = TuplesKt.to((Object)it, (Object)release);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-SdksKeeper$pythonReleasesByLanguageLevel$42 = false;
            LanguageLevel key$iv$iv = (LanguageLevel)it2.getFirst();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-SdksKeeper$pythonReleasesByLanguageLevel$42 = (Pair)element$iv$iv;
            List list = list$iv$iv;
            boolean bl = false;
            list.add((Release)it.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Release> condaReleases(Product ... products) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)products, (String)"products");
        Iterable $this$filter$iv = this.getSdks().getConda();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Release it = (Release)element$iv$iv;
            boolean bl = false;
            if (!ArraysKt.contains((Object[])products, (Object)((Object)it.getProduct()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List condaReleases$default(SdksKeeper sdksKeeper, Product[] productArray, int n, Object object) {
        if ((n & 1) != 0) {
            Product[] productArray2 = new Product[]{Product.Miniconda, Product.Anaconda};
            productArray = productArray2;
        }
        return sdksKeeper.condaReleases(productArray);
    }

    private final Sdks deserialize(String content2) {
        Object object;
        try {
            object = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null).registerModule((Module)new SimpleModule().addDeserializer(Url.class, (JsonDeserializer)new UrlDeserializer())).readValue(content2, Sdks.class);
            Intrinsics.checkNotNull((Object)object);
            object = (Sdks)object;
        }
        catch (Exception ex) {
            SdksKt.access$getLOG$p().error("Json syntax error in the " + configUrl, (Throwable)ex);
            object = new Sdks(null, null, 3, null);
        }
        return object;
    }

    @NotNull
    public final String serialize(@NotNull Sdks sdks2) {
        Intrinsics.checkNotNullParameter((Object)sdks2, (String)"sdks");
        String string = ExtensionsKt.jacksonObjectMapper$default(null, (int)1, null).registerModule((Module)new SimpleModule().addSerializer(Url.class, (JsonSerializer)new UrlSerializer())).setSerializationInclusion(JsonInclude.Include.NON_NULL).writeValueAsString((Object)sdks2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }

    private final String load() {
        String string;
        URL uRL = configUrl;
        if (uRL != null) {
            URL it = uRL;
            boolean bl = false;
            string = Resources.toString((URL)it, (Charset)StandardCharsets.UTF_8);
        } else {
            string = null;
        }
        return string;
    }

    public static final /* synthetic */ Sdks access$deserialize(SdksKeeper $this, String content2) {
        return $this.deserialize(content2);
    }

    public static final /* synthetic */ String access$load(SdksKeeper $this) {
        return $this.load();
    }
}

