/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.traceBackParsers.LinkInTrace;
import com.jetbrains.python.traceBackParsers.TraceBackParser;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0014R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/run/PythonTracebackFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "workingDirectory", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "myWorkingDirectory", "getProject", "()Lcom/intellij/openapi/project/Project;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "entireLength", "", "findFileByName", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileName", "intellij.python.community.impl"})
public class PythonTracebackFilter
implements Filter {
    @NotNull
    private final Project project;
    @Nullable
    private final String myWorkingDirectory;

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public PythonTracebackFilter(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.myWorkingDirectory = project2.getBasePath();
    }

    public PythonTracebackFilter(@NotNull Project project2, @Nullable String workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.myWorkingDirectory = workingDirectory;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line2, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line2, (String)"line");
        Intrinsics.checkNotNullExpressionValue((Object)TraceBackParser.PARSERS, (String)"PARSERS");
        for (TraceBackParser parser : TraceBackParser.PARSERS) {
            String extension;
            LinkInTrace linkInTrace = parser.findLinkInTrace(line2);
            if (linkInTrace == null) continue;
            int lineNumber = linkInTrace.getLineNumber();
            String string = linkInTrace.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            VirtualFile vFile = this.findFileByName(string);
            if (vFile == null) continue;
            if (!vFile.isDirectory() && (extension = vFile.getExtension()) != null && !Intrinsics.areEqual((Object)extension, (Object)"py")) {
                return null;
            }
            OpenFileHyperlinkInfo hyperlink = new OpenFileHyperlinkInfo(this.project, vFile, lineNumber - 1);
            int textStartOffset = entireLength - line2.length();
            int startPos = linkInTrace.getStartPos();
            int endPos = linkInTrace.getEndPos();
            return new Filter.Result(startPos + textStartOffset, endPos + textStartOffset, (HyperlinkInfo)hyperlink);
        }
        return null;
    }

    @Nullable
    protected VirtualFile findFileByName(@NotNull String fileName) {
        String string;
        Object object;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (StringsKt.startsWith$default((String)fileName, (String)"~", (boolean)false, (int)2, null)) {
            CharSequence charSequence = fileName;
            object = new Regex("~");
            String string2 = SystemProperties.getUserHome();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUserHome(...)");
            String string3 = string2;
            string = object.replaceFirst(charSequence, string3);
        } else {
            string = fileName;
        }
        String preparedName = string;
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(preparedName);
        if (vFile == null && !((object = (CharSequence)this.myWorkingDirectory) == null || StringsKt.isBlank((CharSequence)object))) {
            vFile = LocalFileSystem.getInstance().findFileByIoFile(new File(this.myWorkingDirectory, preparedName));
        }
        return vFile;
    }
}

