/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.RemoteSdkPropertiesHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonSshInterpreterManager;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.UnixPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.WinPythonSdkFlavor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRemoteSdkAdditionalData
extends PythonSdkAdditionalData
implements PyRemoteSdkAdditionalDataBase {
    public static final String PYCHARM_HELPERS = ".pycharm_helpers";
    private static final String SKELETONS_PATH = "SKELETONS_PATH";
    private static final String VERSION = "VERSION";
    private static final String RUN_AS_ROOT_VIA_SUDO = "RUN_AS_ROOT_VIA_SUDO";
    private final RemoteConnectionCredentialsWrapper myWrapper = new RemoteConnectionCredentialsWrapper();
    private final RemoteSdkPropertiesHolder myRemoteSdkProperties = new RemoteSdkPropertiesHolder(".pycharm_helpers");
    private String mySkeletonsPath;
    private String myVersionString;

    public PyRemoteSdkAdditionalData(String interpreterPath) {
        this(interpreterPath, false);
    }

    public PyRemoteSdkAdditionalData(String interpreterPath, boolean runAsRootViaSudo) {
        super(PyRemoteSdkAdditionalData.computeFlavor(interpreterPath));
        this.setInterpreterPath(interpreterPath);
        this.setRunAsRootViaSudo(runAsRootViaSudo);
    }

    @NotNull
    public RemoteConnectionCredentialsWrapper connectionCredentials() {
        RemoteConnectionCredentialsWrapper remoteConnectionCredentialsWrapper = this.myWrapper;
        if (remoteConnectionCredentialsWrapper == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(0);
        }
        return remoteConnectionCredentialsWrapper;
    }

    @Nullable
    private static PythonSdkFlavor<?> computeFlavor(@Nullable String sdkPath) {
        if (sdkPath != null) {
            for (PythonSdkFlavor<?> flavor : PyRemoteSdkAdditionalData.getApplicableFlavors(sdkPath.contains("\\"))) {
                if (!flavor.isValidSdkPath(new File(sdkPath))) continue;
                return flavor;
            }
        }
        return null;
    }

    private static List<PythonSdkFlavor<?>> getApplicableFlavors(boolean isWindows) {
        ArrayList result2 = new ArrayList();
        if (isWindows) {
            result2.add(WinPythonSdkFlavor.getInstance());
        } else {
            result2.add(UnixPythonSdkFlavor.getInstance());
        }
        result2.addAll(PythonSdkFlavor.getPlatformIndependentFlavors());
        return result2;
    }

    public String getSkeletonsPath() {
        return this.mySkeletonsPath;
    }

    public void setSkeletonsPath(String path2) {
        this.mySkeletonsPath = path2;
    }

    public <C> void setCredentials(Key<C> key, C credentials) {
        this.myWrapper.setCredentials(key, credentials);
    }

    public CredentialsType<?> getRemoteConnectionType() {
        return this.myWrapper.getRemoteConnectionType();
    }

    public void switchOnConnectionType(CredentialsCase ... cases) {
        this.myWrapper.switchType(cases);
    }

    public String getInterpreterPath() {
        return this.myRemoteSdkProperties.getInterpreterPath();
    }

    public void setInterpreterPath(String interpreterPath) {
        this.myRemoteSdkProperties.setInterpreterPath(interpreterPath);
    }

    public boolean isRunAsRootViaSudo() {
        return this.myRemoteSdkProperties.isRunAsRootViaSudo();
    }

    public void setRunAsRootViaSudo(boolean runAsRootViaSudo) {
        this.myRemoteSdkProperties.setRunAsRootViaSudo(runAsRootViaSudo);
    }

    public String getHelpersPath() {
        return this.myRemoteSdkProperties.getHelpersPath();
    }

    public void setHelpersPath(String helpersPath) {
        this.myRemoteSdkProperties.setHelpersPath(helpersPath);
    }

    public String getDefaultHelpersName() {
        return this.myRemoteSdkProperties.getDefaultHelpersName();
    }

    @NotNull
    public PathMappingSettings getPathMappings() {
        PathMappingSettings pathMappingSettings = this.myRemoteSdkProperties.getPathMappings();
        if (pathMappingSettings == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(1);
        }
        return pathMappingSettings;
    }

    public void setPathMappings(@Nullable PathMappingSettings pathMappings) {
        this.myRemoteSdkProperties.setPathMappings(pathMappings);
    }

    public boolean isHelpersVersionChecked() {
        return this.myRemoteSdkProperties.isHelpersVersionChecked();
    }

    public void setHelpersVersionChecked(boolean helpersVersionChecked) {
        this.myRemoteSdkProperties.setHelpersVersionChecked(helpersVersionChecked);
    }

    public void setSdkId(String sdkId) {
        throw new IllegalStateException("sdkId in this class is constructed based on fields, so it can't be set");
    }

    public String getSdkId() {
        return PyRemoteSdkAdditionalData.constructSdkID(this.myWrapper, this.myRemoteSdkProperties);
    }

    public String getPresentableDetails() {
        return this.myWrapper.getPresentableDetails(this.myRemoteSdkProperties.getInterpreterPath());
    }

    private static String constructSdkID(RemoteConnectionCredentialsWrapper wrapper2, RemoteSdkPropertiesHolder properties) {
        return wrapper2.getId() + properties.getInterpreterPath();
    }

    public boolean isValid() {
        return this.myRemoteSdkProperties.isValid();
    }

    public void setValid(boolean valid) {
        this.myRemoteSdkProperties.setValid(valid);
    }

    public RemoteCredentials getRemoteCredentials(@Nullable Project project2, boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        PythonSshInterpreterManager manager = PythonSshInterpreterManager.Factory.getInstance();
        if (manager == null) {
            throw new IllegalStateException("No plugin");
        }
        return manager.getRemoteCredentials(this.myWrapper, project2, allowSynchronousInteraction);
    }

    public void produceRemoteCredentials(@Nullable Project project2, boolean allowSynchronousInteraction, @NotNull Consumer<RemoteCredentials> consumer) {
        PythonSshInterpreterManager manager;
        if (consumer == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(2);
        }
        if ((manager = PythonSshInterpreterManager.Factory.getInstance()) == null) {
            throw new IllegalStateException("No plugin");
        }
        manager.produceRemoteCredentials(this.myWrapper, project2, allowSynchronousInteraction, consumer);
    }

    public boolean connectionEquals(PyRemoteSdkAdditionalData data) {
        return this.myWrapper.equals((Object)data.myWrapper);
    }

    public Object getRemoteSdkDataKey() {
        return this.myWrapper.getConnectionKey();
    }

    @Override
    @NotNull
    public PyRemoteSdkAdditionalData copy() {
        PyRemoteSdkAdditionalData copy = new PyRemoteSdkAdditionalData(this.myRemoteSdkProperties.getInterpreterPath(), this.isRunAsRootViaSudo());
        this.copyTo(copy);
        PyRemoteSdkAdditionalData pyRemoteSdkAdditionalData = copy;
        if (pyRemoteSdkAdditionalData == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(3);
        }
        return pyRemoteSdkAdditionalData;
    }

    public void copyTo(@NotNull PyRemoteSdkAdditionalData copy) {
        if (copy == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(4);
        }
        copy.setSkeletonsPath(this.mySkeletonsPath);
        copy.setVersionString(this.myVersionString);
        this.myRemoteSdkProperties.copyTo((RemoteSdkProperties)copy.myRemoteSdkProperties);
        this.myWrapper.copyTo(copy.myWrapper);
    }

    @Override
    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(5);
        }
        super.save(rootElement);
        this.myRemoteSdkProperties.save(rootElement);
        rootElement.setAttribute(SKELETONS_PATH, StringUtil.notNullize((String)this.getSkeletonsPath()));
        rootElement.setAttribute(VERSION, StringUtil.notNullize((String)this.getVersionString()));
        rootElement.setAttribute(RUN_AS_ROOT_VIA_SUDO, Boolean.toString(this.isRunAsRootViaSudo()));
        this.myWrapper.save(rootElement);
    }

    @NotNull
    public static PyRemoteSdkAdditionalData loadRemote(@NotNull Sdk sdk2, @Nullable Element element) {
        if (sdk2 == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(6);
        }
        String path2 = sdk2.getHomePath();
        assert (path2 != null);
        PyRemoteSdkAdditionalData data = new PyRemoteSdkAdditionalData(RemoteSdkProperties.getInterpreterPathFromFullPath((String)path2), false);
        data.load(element);
        if (element != null) {
            CredentialsManager.getInstance().loadCredentials(path2, element, (RemoteSdkAdditionalData)data);
            if (data.myWrapper.getRemoteConnectionType().hasPrefix("ssh://")) {
                CredentialsManager.updateOutdatedSdk((RemoteSdkAdditionalData)data, null);
            }
            data.myRemoteSdkProperties.load(element);
            data.setSkeletonsPath(StringUtil.nullize((String)element.getAttributeValue(SKELETONS_PATH)));
            String helpersPath = StringUtil.nullize((String)element.getAttributeValue("PYCHARM_HELPERS_PATH"));
            if (helpersPath != null) {
                data.setHelpersPath(helpersPath);
            }
            data.setVersionString(StringUtil.nullize((String)element.getAttributeValue(VERSION)));
            data.setRunAsRootViaSudo(StringUtil.equals((CharSequence)element.getAttributeValue(RUN_AS_ROOT_VIA_SUDO), (CharSequence)"true"));
        }
        PyRemoteSdkAdditionalData pyRemoteSdkAdditionalData = data;
        if (pyRemoteSdkAdditionalData == null) {
            PyRemoteSdkAdditionalData.$$$reportNull$$$0(7);
        }
        return pyRemoteSdkAdditionalData;
    }

    @Override
    public void setVersionString(String versionString) {
        this.myVersionString = versionString;
    }

    @Override
    public String getVersionString() {
        return this.myVersionString;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteSdkAdditionalData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "connectionCredentials";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappings";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteSdkAdditionalData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRemote";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "produceRemoteCredentials";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadRemote";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

