/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes;

import com.intellij.openapi.util.Key;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.refactoring.classes.DependencyVisitor;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class PyDependenciesComparator
implements Comparator<PyElement>,
Serializable {
    private static final Key<UUID> UUID_KEY = new Key("pyUUIDKey");
    private static final Key<Set<UUID>> DEPENDENCIES_KEY = new Key("pyUUIDDependencies");
    public static final PyDependenciesComparator INSTANCE = new PyDependenciesComparator();

    private PyDependenciesComparator() {
    }

    @NotNull
    private static <T> T getObject(@NotNull Key<T> key, @NotNull PyElement element, @NotNull Supplier<T> create) {
        Object value;
        if (key == null) {
            PyDependenciesComparator.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PyDependenciesComparator.$$$reportNull$$$0(1);
        }
        if (create == null) {
            PyDependenciesComparator.$$$reportNull$$$0(2);
        }
        if ((value = element.getCopyableUserData(key)) == null) {
            value = create.get();
            element.putCopyableUserData(key, value);
        }
        Object object = value;
        if (object == null) {
            PyDependenciesComparator.$$$reportNull$$$0(3);
        }
        return (T)object;
    }

    public int compareAndStoreDependency(@NotNull PyElement o1, @NotNull PyElement o2) {
        if (o1 == null) {
            PyDependenciesComparator.$$$reportNull$$$0(4);
        }
        if (o2 == null) {
            PyDependenciesComparator.$$$reportNull$$$0(5);
        }
        UUID o1UUID = PyDependenciesComparator.getObject(UUID_KEY, o1, () -> UUID.randomUUID());
        UUID o2UUID = PyDependenciesComparator.getObject(UUID_KEY, o2, () -> UUID.randomUUID());
        int result2 = this.compare(o1, o2);
        if (result2 > 0) {
            PyDependenciesComparator.getObject(DEPENDENCIES_KEY, o1, () -> new HashSet()).add(o2UUID);
        } else if (result2 < 0) {
            PyDependenciesComparator.getObject(DEPENDENCIES_KEY, o2, () -> new HashSet()).add(o1UUID);
        }
        return result2;
    }

    public static void clearDependencyInfo(@NotNull Iterable<PyElement> elements) {
        if (elements == null) {
            PyDependenciesComparator.$$$reportNull$$$0(6);
        }
        for (PyElement element : elements) {
            element.putCopyableUserData(UUID_KEY, null);
            element.putCopyableUserData(DEPENDENCIES_KEY, null);
        }
    }

    @Override
    public int compare(@NotNull PyElement o1, @NotNull PyElement o2) {
        if (o1 == null) {
            PyDependenciesComparator.$$$reportNull$$$0(7);
        }
        if (o2 == null) {
            PyDependenciesComparator.$$$reportNull$$$0(8);
        }
        if (PyDependenciesComparator.depends(o1, o2)) {
            return 1;
        }
        if (PyDependenciesComparator.depends(o2, o1)) {
            return -1;
        }
        return PyDependenciesComparator.getBlockType(o1).compareTo(PyDependenciesComparator.getBlockType(o2));
    }

    @NotNull
    private static BlockType getBlockType(@NotNull PyElement statement) {
        if (statement == null) {
            PyDependenciesComparator.$$$reportNull$$$0(9);
        }
        for (BlockType type2 : BlockType.values()) {
            if (!type2.myClass.isAssignableFrom(statement.getClass())) continue;
            BlockType blockType = type2;
            if (blockType == null) {
                PyDependenciesComparator.$$$reportNull$$$0(10);
            }
            return blockType;
        }
        BlockType blockType = BlockType.OTHER;
        if (blockType == null) {
            PyDependenciesComparator.$$$reportNull$$$0(11);
        }
        return blockType;
    }

    public static boolean depends(@NotNull PyElement o1, @NotNull PyElement o2) {
        Set dependencies;
        UUID uuid2;
        if (o1 == null) {
            PyDependenciesComparator.$$$reportNull$$$0(12);
        }
        if (o2 == null) {
            PyDependenciesComparator.$$$reportNull$$$0(13);
        }
        if ((uuid2 = (UUID)o2.getCopyableUserData(UUID_KEY)) != null && (dependencies = (Set)o1.getCopyableUserData(DEPENDENCIES_KEY)) != null) {
            return dependencies.contains(uuid2);
        }
        DependencyVisitor visitor2 = new DependencyVisitor(o2);
        o1.accept(visitor2);
        return visitor2.isDependencyFound();
    }

    public static void copyDependencyInfo(@NotNull PyElement from, @NotNull PyFunction to) {
        if (from == null) {
            PyDependenciesComparator.$$$reportNull$$$0(14);
        }
        if (to == null) {
            PyDependenciesComparator.$$$reportNull$$$0(15);
        }
        to.putCopyableUserData(UUID_KEY, (UUID)from.getCopyableUserData(UUID_KEY));
        to.putCopyableUserData(DEPENDENCIES_KEY, (Set)from.getCopyableUserData(DEPENDENCIES_KEY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "create";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/PyDependenciesComparator";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/PyDependenciesComparator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getObject";
                break;
            }
            case 3: 
            case 10: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "compareAndStoreDependency";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "clearDependencyInfo";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBlockType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "depends";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyDependencyInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 10, 11 -> new IllegalStateException(string);
        };
    }

    private static enum BlockType {
        DOC(PyExpressionStatement.class),
        DECLARATION(PyAssignmentStatement.class),
        METHOD(PyFunction.class),
        OTHER(PyElement.class);

        @NotNull
        private final Class<? extends PyElement> myClass;

        private BlockType(Class<? extends PyElement> aClass) {
            if (aClass == null) {
                BlockType.$$$reportNull$$$0(0);
            }
            this.myClass = aClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/jetbrains/python/refactoring/classes/PyDependenciesComparator$BlockType", "<init>"));
        }
    }
}

