/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.changeSignature;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.PyPsiIndexUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.refactoring.changeSignature.PyChangeSignatureDialog;
import com.jetbrains.python.refactoring.changeSignature.PyMethodDescriptor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyChangeSignatureHandler
implements ChangeSignatureHandler {
    @Nullable
    public PsiElement findTargetMember(@NotNull PsiFile file, @NotNull Editor editor2) {
        if (file == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(1);
        }
        PsiElement element = PyUtil.findNonWhitespaceAtOffset(file, editor2.getCaretModel().getOffset());
        return this.findTargetMember(element);
    }

    @Nullable
    public PsiElement findTargetMember(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        TypeEvalContext context = TypeEvalContext.codeInsightFallback(element.getProject());
        PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PyCallExpression.class);
        if (callExpression != null) {
            PyResolveContext resolveContext = PyResolveContext.implicitContext(context);
            PyCallable resolved = (PyCallable)ContainerUtil.getFirstItem(callExpression.multiResolveCalleeFunction(resolveContext));
            return resolved instanceof PyFunction && PyiUtil.isOverload((PsiElement)resolved, context) ? PyiUtil.getImplementation((PyFunction)resolved, context) : resolved;
        }
        PyFunction parent = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (parent != null && PyiUtil.isOverload(parent, context)) {
            return null;
        }
        return parent;
    }

    public void invoke(@NotNull Project project2, Editor editor2, PsiFile file, DataContext dataContext) {
        PsiElement element;
        if (project2 == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(2);
        }
        if ((element = this.findTargetMember(file, editor2)) == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        PyChangeSignatureHandler.invokeOnElement(project2, element, editor2);
    }

    public void invoke(@NotNull Project project2, PsiElement @NotNull [] elements, @Nullable DataContext dataContext) {
        if (project2 == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(3);
        }
        if (elements == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(4);
        }
        if (elements.length != 1) {
            return;
        }
        Editor editor2 = dataContext == null ? null : (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PyChangeSignatureHandler.invokeOnElement(project2, elements[0], editor2);
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return PyBundle.message("refactoring.change.signature.error.wrong.caret.position.method.name", new Object[0]);
    }

    private static void invokeOnElement(Project project2, PsiElement element, Editor editor2) {
        PyParameter[] parameters;
        if (element instanceof PyLambdaExpression) {
            PyChangeSignatureHandler.showCannotRefactorErrorHint(project2, editor2, PyBundle.message("refactoring.change.signature.error.lambda.call", new Object[0]));
            return;
        }
        if (!(element instanceof PyFunction)) {
            PyChangeSignatureHandler.showCannotRefactorErrorHint(project2, editor2, PyBundle.message("refactoring.change.signature.error.wrong.caret.position.method.name", new Object[0]));
            return;
        }
        PyFunction function = (PyFunction)element;
        if (PyPsiIndexUtil.isNotUnderSourceRoot(project2, element.getContainingFile())) {
            PyChangeSignatureHandler.showCannotRefactorErrorHint(project2, editor2, PyBundle.message("refactoring.change.signature.error.not.under.source.root", new Object[0]));
            return;
        }
        PyFunction superMethod = PyChangeSignatureHandler.getSuperMethod(function);
        if (superMethod == null) {
            return;
        }
        if (!superMethod.equals(element)) {
            element = superMethod;
            if (PyPsiIndexUtil.isNotUnderSourceRoot(project2, superMethod.getContainingFile())) {
                return;
            }
        }
        for (PyParameter p : parameters = function.getParameterList().getParameters()) {
            if (!(p instanceof PyTupleParameter)) continue;
            PyChangeSignatureHandler.showCannotRefactorErrorHint(project2, editor2, PyBundle.message("refactoring.change.signature.error.tuple.parameters", new Object[0]));
            return;
        }
        PyMethodDescriptor method = new PyMethodDescriptor((PyFunction)element);
        PyChangeSignatureDialog dialog2 = new PyChangeSignatureDialog(project2, method);
        dialog2.show();
    }

    private static void showCannotRefactorErrorHint(@NotNull Project project2, @Nullable Editor editor2, @NotNull @NlsContexts.DialogMessage String details) {
        if (project2 == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(5);
        }
        if (details == null) {
            PyChangeSignatureHandler.$$$reportNull$$$0(6);
        }
        String message = RefactoringBundle.getCannotRefactorMessage((String)details);
        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor2, (String)message, (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (String)"refactoring.renameRefactorings");
    }

    @Nullable
    protected static PyFunction getSuperMethod(@Nullable PyFunction function) {
        if (function == null) {
            return null;
        }
        PyClass containingClass = function.getContainingClass();
        if (containingClass == null) {
            return function;
        }
        if (PyUtil.isInitOrNewMethod(function)) {
            return function;
        }
        PyFunction deepestSuperMethod = PySuperMethodsSearch.findDeepestSuperMethod(function);
        if (!deepestSuperMethod.equals(function)) {
            String baseClassName;
            PyClass baseClass = deepestSuperMethod.getContainingClass();
            PyBuiltinCache cache = PyBuiltinCache.getInstance(baseClass);
            String string = baseClassName = baseClass == null ? "" : baseClass.getName();
            if (cache.isBuiltin(baseClass)) {
                return function;
            }
            String message = PyBundle.message("refactoring.change.signature.find.usages.of.base.class", function.getName(), containingClass.getName(), baseClassName);
            int choice = Messages.showYesNoCancelDialog((Project)function.getProject(), (String)message, (String)RefactoringBundle.message((String)"changeSignature.refactoring.name"), (Icon)Messages.getQuestionIcon());
            return switch (choice) {
                case 0 -> deepestSuperMethod;
                case 1 -> function;
                default -> null;
            };
        }
        return function;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "details";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/refactoring/changeSignature/PyChangeSignatureHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetMember";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showCannotRefactorErrorHint";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

