/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.search.PySearchUtilBase;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class PySearchScopeBuilder {
    private static final Set<String> STDLIB_TEST_DIRS = Set.of("bsddb/test", "ctypes/test", "distutils/tests", "email/test", "idlelib/idle_test", "importlib/test", "json/tests", "lib-tk/test", "lib2to3/tests", "sqlite3/test", "test", "tkinter/test", "unittest/test");
    private static final Set<String> TEST_ROOT_NAMES = Set.of("test", "tests");
    private static final Set<String> BUNDLED_DEPS_ROOT_NAMES = Set.of("_vendor", "vendor", "vendored", "_vendored_packages");
    private static final Set<String> THIRD_PARTY_PACKAGE_ROOT_NAMES = Set.of("site-packages", "dist-packages");
    private boolean myExcludeStdlibTests;
    private boolean myExcludeThirdPartyTypeShedStubs;
    private boolean myExcludePythonSkeletonsStubs;
    private boolean myExcludeThirdPartyBundledDeps;
    private boolean myExcludeThirdPartyTests;
    @NotNull
    private final Project myProject;
    @Nullable
    private final Sdk mySdk;

    @NotNull
    public static PySearchScopeBuilder forPythonSdk(@NotNull Project project2, @NotNull Sdk sdk2) {
        if (project2 == null) {
            PySearchScopeBuilder.$$$reportNull$$$0(0);
        }
        if (sdk2 == null) {
            PySearchScopeBuilder.$$$reportNull$$$0(1);
        }
        return new PySearchScopeBuilder(project2, sdk2);
    }

    @NotNull
    public static PySearchScopeBuilder forPythonSdkOf(@NotNull PsiElement element) {
        if (element == null) {
            PySearchScopeBuilder.$$$reportNull$$$0(2);
        }
        return new PySearchScopeBuilder(element.getProject(), PySearchScopeBuilder.findPythonSdkForElement(element));
    }

    private PySearchScopeBuilder(@NotNull Project project2, @Nullable Sdk sdk2) {
        if (project2 == null) {
            PySearchScopeBuilder.$$$reportNull$$$0(3);
        }
        this.myExcludeStdlibTests = false;
        this.myExcludeThirdPartyTypeShedStubs = false;
        this.myExcludePythonSkeletonsStubs = false;
        this.myExcludeThirdPartyBundledDeps = false;
        this.myExcludeThirdPartyTests = false;
        this.myProject = project2;
        this.mySdk = sdk2;
    }

    @NotNull
    public PySearchScopeBuilder excludeStandardLibraryTests() {
        this.myExcludeStdlibTests = true;
        PySearchScopeBuilder pySearchScopeBuilder = this;
        if (pySearchScopeBuilder == null) {
            PySearchScopeBuilder.$$$reportNull$$$0(4);
        }
        return pySearchScopeBuilder;
    }

    @NotNull
    public PySearchScopeBuilder excludeThirdPartyPackageTypeShedStubs() {
        this.myExcludeThirdPartyTypeShedStubs = true;
        PySearchScopeBuilder pySearchScopeBuilder = this;
        if (pySearchScopeBuilder == null) {
            PySearchScopeBuilder.$$$reportNull$$$0(5);
        }
        return pySearchScopeBuilder;
    }

    @NotNull
    public PySearchScopeBuilder excludePythonSkeletonsStubs() {
        this.myExcludePythonSkeletonsStubs = true;
        PySearchScopeBuilder pySearchScopeBuilder = this;
        if (pySearchScopeBuilder == null) {
            PySearchScopeBuilder.$$$reportNull$$$0(6);
        }
        return pySearchScopeBuilder;
    }

    @NotNull
    public PySearchScopeBuilder excludeThirdPartyPackageBundledDependencies() {
        this.myExcludeThirdPartyBundledDeps = true;
        PySearchScopeBuilder pySearchScopeBuilder = this;
        if (pySearchScopeBuilder == null) {
            PySearchScopeBuilder.$$$reportNull$$$0(7);
        }
        return pySearchScopeBuilder;
    }

    @NotNull
    public PySearchScopeBuilder excludeThirdPartyPackageTests() {
        this.myExcludeThirdPartyTests = true;
        PySearchScopeBuilder pySearchScopeBuilder = this;
        if (pySearchScopeBuilder == null) {
            PySearchScopeBuilder.$$$reportNull$$$0(8);
        }
        return pySearchScopeBuilder;
    }

    @NotNull
    public GlobalSearchScope build() {
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myProject);
        if (this.myExcludeStdlibTests) {
            scope = scope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.buildStdlibTestsScope()));
        }
        if (this.myExcludeThirdPartyTypeShedStubs) {
            scope = scope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.buildThirdPartyTypeShedStubsScope()));
        }
        if (this.myExcludePythonSkeletonsStubs) {
            scope = scope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.buildPythonSkeletonsStubsScope()));
        }
        if (this.myExcludeThirdPartyTests || this.myExcludeThirdPartyBundledDeps) {
            scope = scope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)new QualifiedNameFinder.QualifiedNameBasedScope(this.myProject){

                @Override
                protected boolean containsQualifiedNameInRoot(@NotNull VirtualFile root, @NotNull QualifiedName qName) {
                    if (root == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (qName == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (THIRD_PARTY_PACKAGE_ROOT_NAMES.contains(root.getName())) {
                        List internalQNameComponents = qName.removeHead(1).getComponents();
                        if (PySearchScopeBuilder.this.myExcludeThirdPartyTests) {
                            if (ContainerUtil.exists((Iterable)internalQNameComponents, TEST_ROOT_NAMES::contains)) {
                                return true;
                            }
                        }
                        if (PySearchScopeBuilder.this.myExcludeThirdPartyBundledDeps) {
                            if (ContainerUtil.exists((Iterable)internalQNameComponents, BUNDLED_DEPS_ROOT_NAMES::contains)) {
                                return true;
                            }
                        }
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "root";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "qName";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/python/psi/search/PySearchScopeBuilder$1";
                    objectArray[2] = "containsQualifiedNameInRoot";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            PySearchScopeBuilder.$$$reportNull$$$0(9);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope buildStdlibTestsScope() {
        VirtualFile libDir;
        if (this.mySdk != null && (libDir = PySearchUtilBase.findLibDir(this.mySdk)) != null) {
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)StreamEx.of(STDLIB_TEST_DIRS).map(relPath -> libDir.findFileByRelativePath(relPath)).nonNull().map(dir -> GlobalSearchScopesCore.directoryScope((Project)this.myProject, (VirtualFile)dir, (boolean)true)).reduce((Object)GlobalSearchScope.EMPTY_SCOPE, GlobalSearchScope::union);
            if (globalSearchScope == null) {
                PySearchScopeBuilder.$$$reportNull$$$0(10);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            PySearchScopeBuilder.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope buildThirdPartyTypeShedStubsScope() {
        if (this.mySdk != null) {
            GlobalSearchScope globalSearchScope = (GlobalSearchScope)((StreamEx)StreamEx.of((Object[])this.mySdk.getRootProvider().getFiles(OrderRootType.CLASSES)).filter(root -> PyTypeShed.INSTANCE.isInside((VirtualFile)root) && PyTypeShed.INSTANCE.isInThirdPartyLibraries((VirtualFile)root))).map(dir -> GlobalSearchScopesCore.directoryScope((Project)this.myProject, (VirtualFile)dir, (boolean)true)).reduce((Object)GlobalSearchScope.EMPTY_SCOPE, GlobalSearchScope::union);
            if (globalSearchScope == null) {
                PySearchScopeBuilder.$$$reportNull$$$0(12);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
        if (globalSearchScope == null) {
            PySearchScopeBuilder.$$$reportNull$$$0(13);
        }
        return globalSearchScope;
    }

    @NotNull
    private GlobalSearchScope buildPythonSkeletonsStubsScope() {
        GlobalSearchScope globalSearchScope = PyUserSkeletonsUtil.getUserSkeletonsDirectoryScope(this.myProject);
        if (globalSearchScope == null) {
            PySearchScopeBuilder.$$$reportNull$$$0(14);
        }
        return globalSearchScope;
    }

    @Nullable
    private static Sdk findPythonSdkForElement(@NotNull PsiElement element) {
        Sdk sdk2;
        if (element == null) {
            PySearchScopeBuilder.$$$reportNull$$$0(15);
        }
        Project project2 = element.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module != null && (sdk2 = PythonSdkUtil.findPythonSdk(module)) != null) {
            return sdk2;
        }
        return ProjectRootManager.getInstance((Project)project2).getProjectSdk();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/search/PySearchScopeBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/search/PySearchScopeBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeStandardLibraryTests";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeThirdPartyPackageTypeShedStubs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "excludePythonSkeletonsStubs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeThirdPartyPackageBundledDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeThirdPartyPackageTests";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildStdlibTestsScope";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "buildThirdPartyTypeShedStubsScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPythonSkeletonsStubsScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forPythonSdk";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forPythonSdkOf";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findPythonSdkForElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

