/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageRequirementsSettings;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementParser;
import com.jetbrains.python.packaging.PyRequirementsAnalysisResult;
import com.jetbrains.python.packaging.PyRequirementsFileVisitor;
import com.jetbrains.python.packaging.requirement.PyRequirementVersionSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J$\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0002J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0002J,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00052\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0004H\u0002J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0004H\u0002J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u0004H\u0002J\u001c\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001c0\u000b2\u0006\u0010$\u001a\u00020\u0004H\u0002J&\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0002J\u000e\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u0018R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/python/packaging/PyRequirementsFileVisitor;", "", "importedPackages", "", "", "Lcom/jetbrains/python/packaging/PyPackage;", "settings", "Lcom/jetbrains/python/packaging/PyPackageRequirementsSettings;", "(Ljava/util/Map;Lcom/jetbrains/python/packaging/PyPackageRequirementsSettings;)V", "collectedOutput", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "unchangedInBaseFiles", "unmatchedLines", "compatibleVersion", "", "requirement", "Lcom/jetbrains/python/packaging/PyRequirement;", "version", "specifyVersion", "convertToRequirementsEntry", "doVisitFile", "", "requirementsFile", "Lcom/intellij/psi/PsiFile;", "visitedFiles", "", "formatRequirement", "", "pkg", "lines", "isEditableSelf", "line", "isFileReference", "isSkipableInstallOption", "splitByRequirementsEntries", "requirementsText", "visitBaseFile", "filename", "directory", "Lcom/intellij/psi/PsiDirectory;", "visitRequirementsFile", "Lcom/jetbrains/python/packaging/PyRequirementsAnalysisResult;", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyRequirementsFileVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyRequirementsFileVisitor.kt\ncom/jetbrains/python/packaging/PyRequirementsFileVisitor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,154:1\n1313#2,2:155\n1747#3,3:157\n1855#3,2:160\n1726#3,3:162\n*S KotlinDebug\n*F\n+ 1 PyRequirementsFileVisitor.kt\ncom/jetbrains/python/packaging/PyRequirementsFileVisitor\n*L\n67#1:155,2\n93#1:157,3\n113#1:160,2\n126#1:162,3\n*E\n"})
public final class PyRequirementsFileVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, PyPackage> importedPackages;
    @NotNull
    private final PyPackageRequirementsSettings settings;
    @NotNull
    private final Map<VirtualFile, List<String>> collectedOutput;
    @NotNull
    private final List<String> unmatchedLines;
    @NotNull
    private final List<String> unchangedInBaseFiles;
    @NotNull
    private static final List<String> vcsPrefixes;

    public PyRequirementsFileVisitor(@NotNull Map<String, PyPackage> importedPackages2, @NotNull PyPackageRequirementsSettings settings) {
        Intrinsics.checkNotNullParameter(importedPackages2, (String)"importedPackages");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        this.importedPackages = importedPackages2;
        this.settings = settings;
        this.collectedOutput = new LinkedHashMap();
        this.unmatchedLines = new ArrayList();
        this.unchangedInBaseFiles = new ArrayList();
    }

    @NotNull
    public final PyRequirementsAnalysisResult visitRequirementsFile(@NotNull PsiFile requirementsFile) {
        Intrinsics.checkNotNullParameter((Object)requirementsFile, (String)"requirementsFile");
        Object[] objectArray = new VirtualFile[1];
        Intrinsics.checkNotNullExpressionValue((Object)requirementsFile.getVirtualFile(), (String)"getVirtualFile(...)");
        this.doVisitFile(requirementsFile, SetsKt.mutableSetOf((Object[])objectArray));
        List<String> list = this.collectedOutput.remove(requirementsFile.getVirtualFile());
        Intrinsics.checkNotNull(list);
        List<String> currentFileOutput = list;
        return new PyRequirementsAnalysisResult(currentFileOutput, this.collectedOutput, this.unmatchedLines, this.unchangedInBaseFiles);
    }

    /*
     * WARNING - void declaration
     */
    private final void doVisitFile(PsiFile requirementsFile, Set<VirtualFile> visitedFiles) {
        List outputLines = new ArrayList();
        String string = requirementsFile.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        List<List<String>> entries = this.splitByRequirementsEntries(string);
        for (List<String> lines : entries) {
            String name2;
            List<PyRequirement> parsed;
            String[] stringArray;
            String firstLine;
            if (lines.size() == 1 && (StringsKt.startsWith$default((String)(firstLine = (String)CollectionsKt.first(lines)), (String)"#", (boolean)false, (int)2, null) || StringsKt.isBlank((CharSequence)firstLine))) {
                outputLines.add(firstLine);
                continue;
            }
            String line2 = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)lines), (Function1)doVisitFile.line.1.INSTANCE), (Function1)doVisitFile.line.2.INSTANCE), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            if (this.isSkipableInstallOption(line2)) {
                outputLines.addAll((Collection)lines);
                continue;
            }
            if (this.settings.getModifyBaseFiles() && this.isFileReference(line2)) {
                stringArray = new String[]{" "};
                String filename = (String)StringsKt.split$default((CharSequence)line2, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
                PsiDirectory psiDirectory = requirementsFile.getContainingDirectory();
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"getContainingDirectory(...)");
                this.visitBaseFile(filename, psiDirectory, visitedFiles);
                outputLines.addAll((Collection)lines);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue(PyRequirementParser.fromText(line2, requirementsFile.getVirtualFile(), new LinkedHashSet()), (String)"fromText(...)");
            if (this.isFileReference(line2)) {
                void $this$forEach$iv;
                if (parsed.isEmpty()) {
                    if (this.settings.getRemoveUnused()) continue;
                    outputLines.addAll((Collection)lines);
                    continue;
                }
                stringArray = SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)parsed), (Function1)((Function1)new Function1<PyRequirement, Boolean>(this){
                    final /* synthetic */ PyRequirementsFileVisitor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(PyRequirement it) {
                        Map map = PyRequirementsFileVisitor.access$getImportedPackages$p(this.this$0);
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        String string2 = string.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        String string3 = string2;
                        return map.containsKey(string3);
                    }
                })), (Function1)((Function1)new Function1<PyRequirement, Pair<? extends PyRequirement, ? extends PyPackage>>(this){
                    final /* synthetic */ PyRequirementsFileVisitor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Pair<PyRequirement, PyPackage> invoke(PyRequirement it) {
                        Map map = PyRequirementsFileVisitor.access$getImportedPackages$p(this.this$0);
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        String string2 = string.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                        return TuplesKt.to((Object)it, map.remove(string2));
                    }
                })), (Function1)((Function1)new Function1<Pair<? extends PyRequirement, ? extends PyPackage>, Boolean>(this){
                    final /* synthetic */ PyRequirementsFileVisitor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Pair<? extends PyRequirement, PyPackage> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        Object object = it.getFirst();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-first>(...)");
                        PyRequirement pyRequirement = (PyRequirement)object;
                        Object object2 = it.getSecond();
                        Intrinsics.checkNotNull((Object)object2);
                        String string = ((PyPackage)((Object)object2)).getVersion();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
                        return PyRequirementsFileVisitor.access$compatibleVersion(this.this$0, pyRequirement, string, PyRequirementsFileVisitor.access$getSettings$p(this.this$0).getSpecifyVersion());
                    }
                }));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl = false;
                    String string2 = ((PyRequirement)it.getFirst()).getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    this.unchangedInBaseFiles.add(string2);
                }
                outputLines.addAll((Collection)lines);
                continue;
            }
            if (parsed.isEmpty()) {
                if (this.settings.getRemoveUnused()) {
                    this.unmatchedLines.add(line2);
                    continue;
                }
                outputLines.addAll((Collection)lines);
                continue;
            }
            PyRequirement requirement = (PyRequirement)CollectionsKt.first(parsed);
            String string3 = requirement.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            Intrinsics.checkNotNullExpressionValue((Object)string3.toLowerCase(), (String)"toLowerCase(...)");
            if (this.importedPackages.containsKey(name2)) {
                PyPackage pkg;
                Intrinsics.checkNotNull((Object)((Object)this.importedPackages.remove(name2)));
                Intrinsics.checkNotNull((Object)requirement);
                List<String> formatted = this.formatRequirement(requirement, pkg, lines);
                outputLines.addAll((Collection)formatted);
                continue;
            }
            if (this.settings.getRemoveUnused()) continue;
            outputLines.addAll((Collection)lines);
        }
        Map<VirtualFile, List<String>> map = this.collectedOutput;
        VirtualFile virtualFile = requirementsFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        map.put(virtualFile, outputLines);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final List<String> formatRequirement(PyRequirement requirement, PyPackage pkg, List<String> lines) {
        List list;
        block11: {
            block10: {
                boolean bl;
                block9: {
                    if (requirement.isEditable()) break block10;
                    Iterable $this$any$iv = vcsPrefixes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.startsWith$default((String)((String)CollectionsKt.first((List)lines)), (String)it, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block11;
            }
            list = lines;
            return list;
        }
        if (this.settings.getKeepMatchingSpecifier()) {
            String string = pkg.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersion(...)");
            if (this.compatibleVersion(requirement, string, this.settings.getSpecifyVersion())) {
                list = lines;
                return list;
            }
        }
        list = CollectionsKt.listOf((Object)this.convertToRequirementsEntry(requirement, this.settings, pkg.getVersion()));
        return list;
    }

    private final void visitBaseFile(String filename, PsiDirectory directory2, Set<VirtualFile> visitedFiles) {
        VirtualFile referencedFile = directory2.getVirtualFile().findFileByRelativePath(filename);
        if (referencedFile != null && visitedFiles.add(referencedFile)) {
            PsiFile psiFile = directory2.getManager().findFile(referencedFile);
            Intrinsics.checkNotNull((Object)psiFile);
            PsiFile baseRequirementsFile = psiFile;
            this.doVisitFile(baseRequirementsFile, visitedFiles);
            visitedFiles.remove(referencedFile);
        }
    }

    private final List<List<String>> splitByRequirementsEntries(String requirementsText) {
        List splitList = null;
        splitList = new ArrayList();
        List resultList = new ArrayList();
        if (!StringsKt.isBlank((CharSequence)requirementsText)) {
            Iterable $this$forEach$iv = StringsKt.lines((CharSequence)requirementsText);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                splitList.add(it);
                if (StringsKt.endsWith$default((String)it, (String)"\\", (boolean)false, (int)2, null)) continue;
                resultList.add(splitList);
                splitList = new ArrayList();
            }
        }
        if (!((Collection)splitList).isEmpty()) {
            String string = PyBundle.message("python.requirements.error.ends.with.slash", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = string;
            throw new IllegalStateException(string2.toString());
        }
        return resultList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean compatibleVersion(PyRequirement requirement, String version2, boolean specifyVersion) {
        if (specifyVersion) {
            PyRequirementVersionSpec it;
            List<PyRequirementVersionSpec> list = requirement.getVersionSpecs();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getVersionSpecs(...)");
            if (((Collection)list).isEmpty()) return false;
            boolean bl = true;
            if (!bl) return false;
            List<PyRequirementVersionSpec> list2 = requirement.getVersionSpecs();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getVersionSpecs(...)");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                if (!iterator.hasNext()) return true;
                Object element$iv = iterator.next();
                it = (PyRequirementVersionSpec)element$iv;
                boolean bl2 = false;
            } while (it.matches(version2));
            return false;
        }
        boolean bl = requirement.getVersionSpecs().isEmpty();
        return bl;
    }

    private final String convertToRequirementsEntry(PyRequirement requirement, PyPackageRequirementsSettings settings, String version2) {
        Object packageName2;
        if (settings.getSpecifyVersion()) {
            if (version2 != null) {
                v0 = requirement.getName() + requirement.getExtras() + settings.getVersionSpecifier().getSeparator() + version2;
            } else {
                String string = requirement.getPresentableText();
                v0 = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableText(...)");
            }
        } else {
            v0 = packageName2 = requirement.getName() + requirement.getExtras();
        }
        if (requirement.getInstallOptions().size() == 1) {
            return packageName2;
        }
        String offset = StringsKt.repeat((CharSequence)" ", (int)(((String)packageName2).length() + 1));
        List<String> list = requirement.getInstallOptions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getInstallOptions(...)");
        String installOptions = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)list, (int)1), (CharSequence)("\\\n" + offset), null, null, (int)0, null, null, (int)62, null);
        return (String)packageName2 + " " + installOptions;
    }

    static /* synthetic */ String convertToRequirementsEntry$default(PyRequirementsFileVisitor pyRequirementsFileVisitor, PyRequirement pyRequirement, PyPackageRequirementsSettings pyPackageRequirementsSettings, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        return pyRequirementsFileVisitor.convertToRequirementsEntry(pyRequirement, pyPackageRequirementsSettings, string);
    }

    private final boolean isSkipableInstallOption(String line2) {
        return this.isEditableSelf(line2) || StringsKt.startsWith$default((String)line2, (String)"--", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)line2, (String)"--editable", (boolean)false, (int)2, null) && !this.isFileReference(line2);
    }

    private final boolean isFileReference(String line2) {
        return StringsKt.startsWith$default((String)line2, (String)"-r ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line2, (String)"--requirement ", (boolean)false, (int)2, null);
    }

    private final boolean isEditableSelf(String line2) {
        return StringsKt.startsWith$default((String)line2, (String)"--editable .", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line2, (String)"-e .", (boolean)false, (int)2, null);
    }

    public static final /* synthetic */ Map access$getImportedPackages$p(PyRequirementsFileVisitor $this) {
        return $this.importedPackages;
    }

    public static final /* synthetic */ boolean access$compatibleVersion(PyRequirementsFileVisitor $this, PyRequirement requirement, String version2, boolean specifyVersion) {
        return $this.compatibleVersion(requirement, version2, specifyVersion);
    }

    public static final /* synthetic */ PyPackageRequirementsSettings access$getSettings$p(PyRequirementsFileVisitor $this) {
        return $this.settings;
    }

    static {
        Object[] objectArray = new String[]{"git:", "git+", "svn+", "hg+", "bzr+"};
        vcsPrefixes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/python/packaging/PyRequirementsFileVisitor$Companion;", "", "()V", "vcsPrefixes", "", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

