/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject.steps;

import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.projectWizard.AbstractNewProjectStep;
import com.intellij.ide.util.projectWizard.ProjectSettingsStepBase;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.platform.DirectoryProjectGenerator;
import com.intellij.ui.HideableDecorator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.newProject.PyFrameworkProjectGenerator;
import com.jetbrains.python.newProject.PythonProjectGenerator;
import com.jetbrains.python.newProject.collector.InterpreterStatisticsInfo;
import com.jetbrains.python.newProject.steps.PyAddExistingSdkPanel;
import com.jetbrains.python.newProject.steps.PyAddNewEnvironmentPanel;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PyLazySdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.add.PyAddSdkGroupPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.add.v2.PythonInterpreterSelectionMode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectSpecificSettingsStep<T>
extends ProjectSettingsStepBase<T>
implements DumbAware {
    private boolean myInstallFramework;
    @Nullable
    private PyAddSdkGroupPanel myInterpreterPanel;
    @Nullable
    private HideableDecorator myInterpretersDecorator;

    public ProjectSpecificSettingsStep(@NotNull DirectoryProjectGenerator<T> projectGenerator, @NotNull AbstractNewProjectStep.AbstractCallback<T> callback) {
        if (projectGenerator == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(0);
        }
        if (callback == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(1);
        }
        super(projectGenerator, callback);
    }

    protected JPanel createAndFillContentPanel() {
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            ((PythonProjectGenerator)this.myProjectGenerator).setErrorCallback(this::setErrorText);
        }
        return this.createContentPanelWithAdvancedSettingsPanel();
    }

    @Nullable
    protected JPanel createAdvancedSettings() {
        JComponent advancedSettings = null;
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            advancedSettings = ((PythonProjectGenerator)this.myProjectGenerator).getSettingsPanel((File)this.myProjectDirectory.get());
        } else if (this.myProjectGenerator instanceof WebProjectTemplate) {
            advancedSettings = this.getPeer().getComponent();
        }
        if (advancedSettings != null) {
            JPanel jPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
            HideableDecorator deco = new HideableDecorator(jPanel, PyBundle.message("python.new.project.more.settings", new Object[0]), false);
            if (this.myProjectGenerator instanceof PythonProjectGenerator) {
                ValidationResult result2 = ((PythonProjectGenerator)this.myProjectGenerator).warningValidation(this.getInterpreterPanelSdk());
                deco.setOn(!result2.isOk());
            }
            deco.setContentComponent(advancedSettings);
            return jPanel;
        }
        return null;
    }

    @Nullable
    public Sdk getSdk() {
        if (!(this.myProjectGenerator instanceof PythonProjectGenerator)) {
            return null;
        }
        PyAddSdkGroupPanel interpreterPanel = this.myInterpreterPanel;
        if (interpreterPanel == null) {
            return null;
        }
        PyAddSdkPanel panel2 = interpreterPanel.getSelectedPanel();
        if (panel2 instanceof PyAddNewEnvironmentPanel) {
            PyAddNewEnvironmentPanel newEnvironmentPanel = (PyAddNewEnvironmentPanel)panel2;
            return new PyLazySdk("Uninitialized environment", (NullableComputable<Sdk>)((NullableComputable)newEnvironmentPanel::getOrCreateSdk));
        }
        if (panel2 instanceof PyAddExistingSdkPanel) {
            return panel2.getSdk();
        }
        return null;
    }

    @Nullable
    public InterpreterStatisticsInfo getInterpreterInfoForStatistics() {
        if (this.myInterpreterPanel == null) {
            return null;
        }
        PyAddSdkPanel panel2 = this.myInterpreterPanel.getSelectedPanel();
        return panel2.getStatisticInfo();
    }

    @Nullable
    private Sdk getInterpreterPanelSdk() {
        PyAddSdkGroupPanel interpreterPanel = this.myInterpreterPanel;
        if (interpreterPanel == null) {
            return null;
        }
        return interpreterPanel.getSdk();
    }

    public boolean installFramework() {
        return this.myInstallFramework;
    }

    protected void registerValidators() {
        super.registerValidators();
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            this.addLocationChangeListener(event -> {
                String fileName = PathUtil.getFileName((String)this.getProjectLocation());
                ((PythonProjectGenerator)this.myProjectGenerator).locationChanged(fileName);
            });
        }
    }

    @Nullable
    public String getRemotePath() {
        PyAddSdkGroupPanel interpreterPanel = this.myInterpreterPanel;
        if (interpreterPanel == null) {
            return null;
        }
        PyAddExistingSdkPanel panel2 = (PyAddExistingSdkPanel)ObjectUtils.tryCast((Object)interpreterPanel.getSelectedPanel(), PyAddExistingSdkPanel.class);
        if (panel2 == null) {
            return null;
        }
        return panel2.getRemotePath();
    }

    protected void initGeneratorListeners() {
        super.initGeneratorListeners();
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            ((PythonProjectGenerator)this.myProjectGenerator).addSettingsStateListener(this::checkValid);
            this.myErrorLabel.addMouseListener(((PythonProjectGenerator)this.myProjectGenerator).getErrorLabelMouseListener());
        }
    }

    public void setErrorText(@Nullable String text) {
        super.setErrorText(text);
        if (this.myInterpretersDecorator != null && !StringUtil.isEmpty((String)text)) {
            this.myInterpretersDecorator.setOn(true);
        }
    }

    public void setWarningText(@Nullable String text) {
        super.setWarningText(text);
        if (this.myInterpretersDecorator != null && !StringUtil.isEmpty((String)text)) {
            this.myInterpretersDecorator.setOn(true);
        }
    }

    public boolean checkValid() {
        this.myInstallFramework = false;
        if (!super.checkValid()) {
            return false;
        }
        PyAddSdkGroupPanel interpreterPanel = this.myInterpreterPanel;
        Map errorsAndWarnings = StreamEx.of(interpreterPanel == null ? Collections.emptyList() : interpreterPanel.validateAll()).groupingBy(it -> it.warning, Collectors.mapping(it -> it.message, Collectors.toList()));
        List<Object> validationErrors = errorsAndWarnings.getOrDefault(false, Collections.emptyList());
        List validationWarnings = errorsAndWarnings.getOrDefault(true, Collections.emptyList());
        if (validationErrors.isEmpty()) {
            Sdk sdk2;
            Sdk sdk3 = sdk2 = interpreterPanel != null ? interpreterPanel.getSdk() : null;
            if (sdk2 != null && ProjectSpecificSettingsStep.isImmutableSdk(sdk2)) {
                validationErrors = List.of(PyBundle.message("python.unknown.project.synchronizer.this.interpreter.type.does.not.support.remote.project.creation", new Object[0]));
            }
        }
        if (!validationErrors.isEmpty()) {
            this.setErrorText(StringUtil.join(validationErrors, (String)"\n"));
            return false;
        }
        if (!validationWarnings.isEmpty()) {
            this.setWarningText(((HtmlChunk)StreamEx.of(validationWarnings).map(HtmlChunk::raw).collect(HtmlChunk.toFragment((HtmlChunk)HtmlChunk.br()))).toString());
        }
        PythonProjectGenerator generator = (PythonProjectGenerator)((Object)ObjectUtils.tryCast((Object)this.myProjectGenerator, PythonProjectGenerator.class));
        Sdk sdk4 = this.getInterpreterPanelSdk();
        if (generator == null || sdk4 == null) {
            this.myInstallFramework = true;
            return true;
        }
        try {
            generator.checkProjectCanBeCreatedOnSdk(sdk4, new File(this.getProjectLocation()));
        }
        catch (PythonProjectGenerator.PyNoProjectAllowedOnSdkException e) {
            this.setErrorText(e.getMessage());
            return false;
        }
        ArrayList warnings = new ArrayList(validationWarnings);
        PyFrameworkProjectGenerator frameworkGenerator = (PyFrameworkProjectGenerator)ObjectUtils.tryCast((Object)this.myProjectGenerator, PyFrameworkProjectGenerator.class);
        if (frameworkGenerator != null) {
            String python3Error = ProjectSpecificSettingsStep.validateFrameworkSupportsPython3(frameworkGenerator, sdk4);
            if (python3Error != null) {
                this.setErrorText(python3Error);
                return false;
            }
            if (!PythonSdkUtil.isRemote(sdk4)) {
                Pair<Boolean, List<String>> validationInfo = ProjectSpecificSettingsStep.validateFramework(frameworkGenerator, sdk4);
                this.myInstallFramework = (Boolean)validationInfo.first;
                warnings.addAll((Collection)validationInfo.second);
                ValidationResult warningResult = ((PythonProjectGenerator)this.myProjectGenerator).warningValidation(sdk4);
                if (!warningResult.isOk()) {
                    warnings.add(warningResult.getErrorMessage());
                }
            }
        }
        if (!warnings.isEmpty()) {
            this.setWarningText(((HtmlChunk)StreamEx.of(warnings).map(HtmlChunk::raw).collect(HtmlChunk.toFragment((HtmlChunk)HtmlChunk.br()))).toString());
        }
        return true;
    }

    private static boolean isImmutableSdk(@NotNull Sdk sdk2) {
        TargetEnvironmentConfiguration targetConfig;
        if (sdk2 == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(2);
        }
        if ((targetConfig = PySdkExtKt.getTargetEnvConfiguration(sdk2)) == null) {
            return false;
        }
        return !PythonInterpreterTargetEnvironmentFactory.Companion.isMutable(targetConfig);
    }

    @Nls
    private static String validateFrameworkSupportsPython3(@NotNull PyFrameworkProjectGenerator generator, @NotNull Sdk sdk2) {
        if (generator == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(3);
        }
        if (sdk2 == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(4);
        }
        String frameworkName = generator.getFrameworkTitle();
        boolean isPy3k = PythonSdkType.getLanguageLevelForSdk(sdk2).isPy3K();
        return isPy3k && !generator.supportsPython3() ? PyBundle.message("framework.not.supported.for.the.selected.interpreter", frameworkName) : null;
    }

    @NotNull
    private static Pair<Boolean, List<String>> validateFramework(@NotNull PyFrameworkProjectGenerator generator, @NotNull Sdk sdk2) {
        if (generator == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(5);
        }
        if (sdk2 == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(6);
        }
        ArrayList<String> warnings = new ArrayList<String>();
        boolean installFramework = false;
        if (!generator.isFrameworkInstalled(sdk2)) {
            String frameworkName = generator.getFrameworkTitle();
            String message = PyBundle.message("python.package.installation.notification.message", frameworkName);
            if (PyPackageUtil.packageManagementEnabled(sdk2, false, false)) {
                installFramework = true;
                List<PyPackage> packages2 = PyPackageUtil.refreshAndGetPackagesModally(sdk2);
                if (!PyPackageUtil.hasManagement(packages2)) {
                    message = PyBundle.message("python.package.and.packaging.tools.installation.notification.message", frameworkName);
                }
            }
            warnings.add(message);
        }
        Pair pair = Pair.create((Object)installFramework, warnings);
        if (pair == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(7);
        }
        return pair;
    }

    protected JPanel createBasePanel() {
        if (this.myProjectGenerator instanceof PythonProjectGenerator) {
            BorderLayout layout = new BorderLayout();
            JPanel locationPanel = new JPanel(layout);
            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 2));
            LabeledComponent location = this.createLocationComponent();
            locationPanel.add((Component)location, "Center");
            panel2.add(locationPanel);
            panel2.add(this.createInterpretersPanel(((PythonProjectGenerator)this.myProjectGenerator).getPreferredEnvironmentType()));
            JPanel basePanelExtension = ((PythonProjectGenerator)this.myProjectGenerator).extendBasePanel();
            if (basePanelExtension != null) {
                panel2.add(basePanelExtension);
            }
            return panel2;
        }
        return super.createBasePanel();
    }

    @NotNull
    private JPanel createInterpretersPanel(@Nullable PythonInterpreterSelectionMode preferredEnvironment) {
        JPanel container = new JPanel(new BorderLayout());
        JPanel decoratorPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
        List<Sdk> allExistingSdks = Arrays.asList(PyConfigurableInterpreterList.getInstance(null).getModel().getSdks());
        List<Sdk> existingSdks = ProjectSpecificSettingsStep.getValidPythonSdks(allExistingSdks);
        Sdk preferredSdk = this.getPreferredSdk(existingSdks);
        String newProjectPath = this.getProjectLocation();
        PyAddNewEnvironmentPanel newEnvironmentPanel = new PyAddNewEnvironmentPanel(allExistingSdks, newProjectPath, preferredEnvironment);
        PyAddExistingSdkPanel existingSdkPanel = new PyAddExistingSdkPanel(null, null, existingSdks, newProjectPath, preferredSdk);
        PyAddSdkPanel defaultPanel = PySdkSettings.getInstance().getUseNewEnvironmentForNewProject() ? newEnvironmentPanel : existingSdkPanel;
        this.myInterpretersDecorator = new HideableDecorator(decoratorPanel, ProjectSpecificSettingsStep.getProjectInterpreterTitle(defaultPanel).toString(), false);
        this.myInterpretersDecorator.setContentComponent((JComponent)container);
        List<PyAddSdkPanel> panels = Arrays.asList(newEnvironmentPanel, existingSdkPanel);
        this.myInterpreterPanel = new PyAddSdkGroupPanel(PyBundle.messagePointer("python.add.sdk.panel.name.new.project.interpreter", new Object[0]), this.getIcon(), panels, defaultPanel);
        this.myInterpreterPanel.addChangeListener(() -> {
            this.myInterpretersDecorator.setTitle(ProjectSpecificSettingsStep.getProjectInterpreterTitle(this.myInterpreterPanel.getSelectedPanel()).toString());
            boolean useNewEnvironment = this.myInterpreterPanel.getSelectedPanel() instanceof PyAddNewEnvironmentPanel;
            PySdkSettings.getInstance().setUseNewEnvironmentForNewProject(useNewEnvironment);
            this.checkValid();
        });
        this.addLocationChangeListener(event -> this.myInterpreterPanel.setNewProjectPath(this.getProjectLocation()));
        container.add((Component)this.myInterpreterPanel, "North");
        this.checkValid();
        JPanel jPanel = decoratorPanel;
        if (jPanel == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    @NotNull
    private static TextWithMnemonic getProjectInterpreterTitle(@NotNull PyAddSdkPanel panel2) {
        Sdk sdk2;
        if (panel2 == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(9);
        }
        String name2 = panel2 instanceof PyAddNewEnvironmentPanel ? PyBundle.message("python.sdk.new.environment.kind", ((PyAddNewEnvironmentPanel)panel2).getSelectedPanel().getEnvName()) : ((sdk2 = panel2.getSdk()) != null ? sdk2.getName() : panel2.getPanelName());
        TextWithMnemonic textWithMnemonic = TextWithMnemonic.parse((String)PyBundle.message("python.sdk.python.interpreter.title.0", "[name]")).replaceFirst("[name]", name2);
        if (textWithMnemonic == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(10);
        }
        return textWithMnemonic;
    }

    @Nullable
    private Sdk getPreferredSdk(@NotNull List<Sdk> sdks2) {
        PyFrameworkProjectGenerator projectGenerator;
        if (sdks2 == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(11);
        }
        boolean onlyPython2 = (projectGenerator = (PyFrameworkProjectGenerator)ObjectUtils.tryCast((Object)this.getProjectGenerator(), PyFrameworkProjectGenerator.class)) != null && !projectGenerator.supportsPython3();
        Sdk preferred = (Sdk)ContainerUtil.getFirstItem(sdks2);
        if (preferred == null) {
            return null;
        }
        if (onlyPython2 && !PythonSdkType.getLanguageLevelForSdk(preferred).isPython2()) {
            Sdk python2Sdk = PythonSdkType.findPython2Sdk(sdks2);
            return python2Sdk != null ? python2Sdk : preferred;
        }
        return preferred;
    }

    @NotNull
    public static List<Sdk> getValidPythonSdks(@NotNull List<Sdk> existingSdks) {
        if (existingSdks == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(12);
        }
        List list = ((StreamEx)((StreamEx)StreamEx.of(existingSdks).filter(sdk2 -> sdk2 != null && sdk2.getSdkType() instanceof PythonSdkType && PySdkExtKt.getSdkSeemsValid(sdk2))).sorted((Comparator)new PreferredSdkComparator())).toList();
        if (list == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    protected File findSequentNonExistingUntitled() {
        File file = Optional.ofNullable(PyUtil.as(this.myProjectGenerator, PythonProjectGenerator.class)).map(PythonProjectGenerator::getNewProjectPrefix).map(it -> FileUtil.findSequentNonexistentFile((File)ProjectSpecificSettingsStep.getBaseDir(), (String)it, (String)"")).orElseGet(() -> super.findSequentNonExistingUntitled());
        if (file == null) {
            ProjectSpecificSettingsStep.$$$reportNull$$$0(14);
        }
        return file;
    }

    @RequiresEdt
    public boolean createWelcomeScript() {
        ThreadingAssertions.assertEventDispatchThread();
        return false;
    }

    @NotNull
    private static File getBaseDir() {
        if (PlatformUtils.isDataSpell() && Path.of(ProjectUtil.getBaseDir(), new String[0]).startsWith(PathManager.getConfigDir())) {
            return new File(ProjectUtil.getUserHomeProjectDir());
        }
        return new File(ProjectUtil.getBaseDir());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 10, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/newProject/steps/ProjectSpecificSettingsStep";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdks";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSdks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/newProject/steps/ProjectSpecificSettingsStep";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "validateFramework";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createInterpretersPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectInterpreterTitle";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidPythonSdks";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findSequentNonExistingUntitled";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isImmutableSdk";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateFrameworkSupportsPython3";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateFramework";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProjectInterpreterTitle";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredSdk";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getValidPythonSdks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 10, 13, 14 -> new IllegalStateException(string);
        };
    }
}

