/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveArgumentEqualDefaultQuickFix
implements LocalQuickFix {
    private final List<SmartPsiElementPointer<PyExpression>> myProblemElements;

    public RemoveArgumentEqualDefaultQuickFix(@NotNull Collection<PyExpression> problemElements) {
        if (problemElements == null) {
            RemoveArgumentEqualDefaultQuickFix.$$$reportNull$$$0(0);
        }
        this.myProblemElements = new ArrayList<SmartPsiElementPointer<PyExpression>>();
        for (PyExpression element : problemElements) {
            this.myProblemElements.add((SmartPsiElementPointer<PyExpression>)SmartPointerManager.createPointer((PsiElement)element));
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.remove.argument.equal.default", new Object[0]);
        if (string == null) {
            RemoveArgumentEqualDefaultQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        if (project2 == null) {
            RemoveArgumentEqualDefaultQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor2 == null) {
            RemoveArgumentEqualDefaultQuickFix.$$$reportNull$$$0(3);
        }
        PsiElement element = descriptor2.getPsiElement();
        List problemElements = ContainerUtil.map(this.myProblemElements, SmartPsiElementPointer::getElement);
        if (problemElements.contains(null)) {
            return;
        }
        PyArgumentList argumentList = (PyArgumentList)PsiTreeUtil.getParentOfType((PsiElement)element, PyArgumentList.class);
        if (argumentList == null) {
            return;
        }
        StringBuilder newArgumentList = new StringBuilder("foo(");
        PyExpression[] arguments = argumentList.getArguments();
        ArrayList<String> newArgs = new ArrayList<String>();
        for (int i = 0; i != arguments.length; ++i) {
            if (problemElements.contains(arguments[i])) continue;
            newArgs.add(arguments[i].getText());
        }
        newArgumentList.append(StringUtil.join(newArgs, (String)", ")).append(")");
        PyExpression expression = ((PyExpressionStatement)PyElementGenerator.getInstance(project2).createFromText(LanguageLevel.forElement((PsiElement)argumentList), PyExpressionStatement.class, newArgumentList.toString())).getExpression();
        if (expression instanceof PyCallExpression) {
            argumentList.replace((PsiElement)((PyCallExpression)expression).getArgumentList());
        }
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            RemoveArgumentEqualDefaultQuickFix.$$$reportNull$$$0(4);
        }
        ArrayList<PyExpression> copies = new ArrayList<PyExpression>();
        for (SmartPsiElementPointer<PyExpression> element : this.myProblemElements) {
            PyExpression copy = PyRefactoringUtil.findSameElementForPreview(element, target);
            if (copy == null) {
                return null;
            }
            copies.add(copy);
        }
        return new RemoveArgumentEqualDefaultQuickFix(copies);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemElements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/RemoveArgumentEqualDefaultQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/RemoveArgumentEqualDefaultQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

