/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.intentions.PyTypeHintGenerationUtil;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyTypeCheckerInspection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyRefactoringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMakeFunctionReturnTypeQuickFix
implements LocalQuickFix {
    @NotNull
    private final SmartPsiElementPointer<PyFunction> myFunction;
    @Nullable
    private final SmartPsiElementPointer<PyExpression> myReturnExpr;
    @Nullable
    private final SmartPsiElementPointer<PyAnnotation> myAnnotation;
    @Nullable
    private final SmartPsiElementPointer<PsiComment> myTypeCommentAnnotation;
    private final String myReturnTypeName;
    private final boolean myHaveSuggestedType;

    public PyMakeFunctionReturnTypeQuickFix(@NotNull PyFunction function, @Nullable PyExpression returnExpr, @Nullable PyType suggestedReturnType, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(1);
        }
        this(function, returnExpr, function.getAnnotation(), function.getTypeComment(), suggestedReturnType != null, PyMakeFunctionReturnTypeQuickFix.getReturnTypeName(function, suggestedReturnType, context));
    }

    @NotNull
    private static String getReturnTypeName(@NotNull PyFunction function, @Nullable PyType returnType, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(3);
        }
        PyType type2 = returnType != null ? returnType : function.getReturnStatementType(context);
        String string = PythonDocumentationProvider.getTypeHint(type2, context);
        if (string == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    private PyMakeFunctionReturnTypeQuickFix(@NotNull PyFunction function, @Nullable PyExpression returnExpr, @Nullable PyAnnotation annotation, @Nullable PsiComment typeComment, boolean returnTypeSuggested, @NotNull String returnTypeName) {
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(5);
        }
        if (returnTypeName == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(6);
        }
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)function.getProject());
        this.myFunction = manager.createSmartPsiElementPointer((PsiElement)function);
        this.myReturnExpr = returnExpr != null ? manager.createSmartPsiElementPointer((PsiElement)returnExpr) : null;
        this.myAnnotation = annotation != null ? manager.createSmartPsiElementPointer((PsiElement)annotation) : null;
        this.myTypeCommentAnnotation = typeComment != null ? manager.createSmartPsiElementPointer((PsiElement)typeComment) : null;
        this.myHaveSuggestedType = returnTypeSuggested;
        this.myReturnTypeName = returnTypeName;
    }

    @NotNull
    public String getName() {
        PyFunction function = (PyFunction)this.myFunction.getElement();
        String functionName = function != null ? function.getName() : "function";
        String string = PyPsiBundle.message("QFIX.make.function.return.type", functionName, this.myReturnTypeName);
        if (string == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.make.function.return.type", new Object[0]);
        if (string == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        PsiComment typeComment;
        if (project2 == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(9);
        }
        if (descriptor2 == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(10);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project2);
        if (this.myAnnotation != null) {
            PyAnnotation annotation = (PyAnnotation)this.myAnnotation.getElement();
            if (annotation != null) {
                PyExpression annotationExpr = annotation.getValue();
                if (annotationExpr == null) {
                    return;
                }
                PsiElement newElement = annotationExpr.replace((PsiElement)elementGenerator.createExpressionFromText(LanguageLevel.PYTHON34, this.myReturnTypeName));
                this.addImportsForTypeAnnotations(newElement);
            }
        } else if (this.myTypeCommentAnnotation != null && (typeComment = (PsiComment)this.myTypeCommentAnnotation.getElement()) != null) {
            StringBuilder typeCommentAnnotation = new StringBuilder(typeComment.getText());
            typeCommentAnnotation.delete(typeCommentAnnotation.indexOf("->"), typeCommentAnnotation.length());
            typeCommentAnnotation.append("-> ").append(this.myReturnTypeName);
            PsiComment newTypeComment = (PsiComment)elementGenerator.createFromText(LanguageLevel.PYTHON27, PsiComment.class, typeCommentAnnotation.toString());
            PsiElement newElement = typeComment.replace((PsiElement)newTypeComment);
            this.addImportsForTypeAnnotations(newElement);
        }
    }

    private void addImportsForTypeAnnotations(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(11);
        }
        if ((file = element.getContainingFile()) == null) {
            return;
        }
        PyFunction function = (PyFunction)this.myFunction.getElement();
        if (function == null) {
            return;
        }
        Project project2 = element.getProject();
        TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(project2, file);
        PyType typeForImports = this.getTypeForImports(function, typeEvalContext);
        if (typeForImports != null) {
            PyTypeHintGenerationUtil.addImportsForTypeAnnotations(List.of(typeForImports), typeEvalContext, file);
        }
    }

    @Nullable
    private PyType getTypeForImports(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        if (function == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(12);
        }
        if (context == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(13);
        }
        PyType returnTypeActual = PyTypeCheckerInspection.Visitor.getActualReturnType(function, this.myReturnExpr != null ? (PyExpression)this.myReturnExpr.getElement() : null, context);
        if (this.myHaveSuggestedType && returnTypeActual != null) {
            return returnTypeActual;
        }
        return function.getReturnStatementType(context);
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        PyFunction function;
        if (target == null) {
            PyMakeFunctionReturnTypeQuickFix.$$$reportNull$$$0(14);
        }
        if ((function = PyRefactoringUtil.findSameElementForPreview(this.myFunction, target)) == null) {
            return null;
        }
        @Nullable PyExpression returnExpr = PyRefactoringUtil.findSameElementForPreview(this.myReturnExpr, target);
        if (this.myReturnExpr != null && returnExpr == null) {
            return null;
        }
        @Nullable PyAnnotation annotation = PyRefactoringUtil.findSameElementForPreview(this.myAnnotation, target);
        if (this.myAnnotation != null && annotation == null) {
            return null;
        }
        @Nullable PsiComment typeComment = PyRefactoringUtil.findSameElementForPreview(this.myTypeCommentAnnotation, target);
        if (this.myTypeCommentAnnotation != null && typeComment == null) {
            return null;
        }
        return new PyMakeFunctionReturnTypeQuickFix(function, returnExpr, annotation, typeComment, this.myHaveSuggestedType, this.myReturnTypeName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyMakeFunctionReturnTypeQuickFix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnTypeName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyMakeFunctionReturnTypeQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnTypeName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeName";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addImportsForTypeAnnotations";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForImports";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 7, 8 -> new IllegalStateException(string);
        };
    }
}

