/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyListCreationInspection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ListCreationQuickFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.list.creation", new Object[0]);
        if (string == null) {
            ListCreationQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (project2 == null) {
            ListCreationQuickFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            ListCreationQuickFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            ListCreationQuickFix.$$$reportNull$$$0(3);
        }
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project2);
        PyAssignmentStatement assignmentStatement = PyUtil.as(element, PyAssignmentStatement.class);
        if (assignmentStatement == null) {
            return;
        }
        PyExpression assignedValue = assignmentStatement.getAssignedValue();
        if (assignedValue == null) {
            return;
        }
        List<PyExpressionStatement> appendCalls = PyListCreationInspection.collectSubsequentListAppendCalls(assignmentStatement);
        List<PyExpression> items = ListCreationQuickFix.buildLiteralItems(assignedValue, appendCalls);
        appendCalls.forEach(PsiElement::delete);
        String text = "[" + StringUtil.join(items, PsiElement::getText, (String)", ") + "]";
        assignedValue.replace((PsiElement)elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)assignedValue), text));
    }

    @NotNull
    private static List<PyExpression> buildLiteralItems(@NotNull PyExpression assignedValue, List<PyExpressionStatement> statements) {
        if (assignedValue == null) {
            ListCreationQuickFix.$$$reportNull$$$0(4);
        }
        ArrayList<PyExpression> values = new ArrayList<PyExpression>();
        ContainerUtil.addAll(values, (Object[])((PyListLiteralExpression)assignedValue).getElements());
        for (PyExpressionStatement statement : statements) {
            ContainerUtil.addAll(values, (Object[])((PyCallExpression)statement.getExpression()).getArguments());
        }
        ArrayList<PyExpression> arrayList = values;
        if (arrayList == null) {
            ListCreationQuickFix.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/ListCreationQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/ListCreationQuickFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLiteralItems";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildLiteralItems";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

