/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferencesInspection;
import org.jetbrains.annotations.NotNull;

public class AddIgnoredIdentifierQuickFix
extends ModCommandQuickFix
implements LowPriorityAction {
    @NotNull
    private final QualifiedName myIdentifier;
    private final boolean myIgnoreAllAttributes;

    public AddIgnoredIdentifierQuickFix(@NotNull QualifiedName identifier, boolean ignoreAllAttributes) {
        if (identifier == null) {
            AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(0);
        }
        this.myIdentifier = identifier;
        this.myIgnoreAllAttributes = ignoreAllAttributes;
    }

    @NotNull
    public String getName() {
        if (this.myIgnoreAllAttributes) {
            String string = PyBundle.message("QFIX.mark.all.unresolved.attributes.of.0.as.ignored", this.myIdentifier);
            if (string == null) {
                AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = PyBundle.message("QFIX.ignore.unresolved.reference.0", this.myIdentifier);
        if (string == null) {
            AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.ignore.unresolved.reference", new Object[0]);
        if (string == null) {
            AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public ModCommand perform(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        if (project2 == null) {
            AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor2 == null) {
            AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(5);
        }
        PsiElement context = descriptor2.getPsiElement();
        ModCommand modCommand = ModCommand.updateInspectionOption((PsiElement)context, (InspectionProfileEntry)new PyUnresolvedReferencesInspection(), inspection -> {
            Object name2 = this.myIdentifier.toString();
            if (this.myIgnoreAllAttributes) {
                name2 = (String)name2 + ".*";
            }
            if (!inspection.ignoredIdentifiers.contains(name2)) {
                inspection.ignoredIdentifiers.add((String)name2);
            }
        });
        if (modCommand == null) {
            AddIgnoredIdentifierQuickFix.$$$reportNull$$$0(6);
        }
        return modCommand;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/AddIgnoredIdentifierQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/AddIgnoredIdentifierQuickFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 6 -> new IllegalStateException(string);
        };
    }
}

