/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonTemplateRunner;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.PyPsiRefactoringUtil;
import java.util.Iterator;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AddFieldQuickFix
implements LocalQuickFix {
    private final String myInitializer;
    private final String myClassName;
    private final String myIdentifier;
    private final boolean replaceInitializer;

    public AddFieldQuickFix(@NotNull String identifier, @NotNull String initializer, String className, boolean replace) {
        if (identifier == null) {
            AddFieldQuickFix.$$$reportNull$$$0(0);
        }
        if (initializer == null) {
            AddFieldQuickFix.$$$reportNull$$$0(1);
        }
        this.myIdentifier = identifier;
        this.myInitializer = initializer;
        this.myClassName = className;
        this.replaceInitializer = replace;
    }

    @NotNull
    public String getName() {
        String string = PyPsiBundle.message("QFIX.add.field.to.class", this.myIdentifier, this.myClassName);
        if (string == null) {
            AddFieldQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.NAME.add.field.to.class", new Object[0]);
        if (string == null) {
            AddFieldQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static PsiElement appendToMethod(PyFunction init2, Function<? super String, ? extends PyStatement> callback) {
        PyStatementList statementList = init2.getStatementList();
        String selfName = "self";
        PyParameter[] params = init2.getParameterList().getParameters();
        if (params.length > 0) {
            selfName = params[0].getName();
        }
        PyStatement newStmt = callback.apply(selfName);
        PsiElement result2 = PyPsiRefactoringUtil.addElementToStatementList((PsiElement)newStmt, statementList, true);
        PyPsiUtils.removeRedundantPass(statementList);
        PsiElement psiElement = result2;
        if (psiElement == null) {
            AddFieldQuickFix.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element;
        PyClassType type2;
        if (project2 == null) {
            AddFieldQuickFix.$$$reportNull$$$0(5);
        }
        if (descriptor2 == null) {
            AddFieldQuickFix.$$$reportNull$$$0(6);
        }
        if ((type2 = AddFieldQuickFix.getClassType(element = descriptor2.getPsiElement())) == null) {
            return;
        }
        PyClass cls = type2.getPyClass();
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)cls)) {
            return;
        }
        WriteAction.run(() -> {
            PsiElement initStatement;
            if (!type2.isDefinition()) {
                initStatement = AddFieldQuickFix.addFieldToInit(project2, cls, this.myIdentifier, new CreateFieldCallback(project2, this.myIdentifier, this.myInitializer));
            } else {
                PyStatement field = (PyStatement)PyElementGenerator.getInstance(project2).createFromText(LanguageLevel.getDefault(), PyStatement.class, this.myIdentifier + " = " + this.myInitializer);
                initStatement = PyPsiRefactoringUtil.addElementToStatementList((PsiElement)field, cls.getStatementList(), true);
            }
            if (initStatement != null) {
                this.showTemplateBuilder(initStatement, cls.getContainingFile());
                return;
            }
            PythonUiService.getInstance().showBalloonError(project2, PyPsiBundle.message("QFIX.failed.to.add.field", new Object[0]));
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static PyClassType getClassType(@NotNull PsiElement element) {
        if (element == null) {
            AddFieldQuickFix.$$$reportNull$$$0(7);
        }
        if (element instanceof PyQualifiedExpression) {
            PyExpression qualifier = ((PyQualifiedExpression)element).getQualifier();
            if (qualifier == null) {
                return null;
            }
            PyType type2 = TypeEvalContext.userInitiated(element.getProject(), element.getContainingFile()).getType(qualifier);
            return type2 instanceof PyClassType ? (PyClassType)type2 : null;
        }
        PyClass aClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
        return aClass != null ? new PyClassTypeImpl(aClass, false) : null;
    }

    private void showTemplateBuilder(PsiElement initStatement, @NotNull PsiFile file) {
        TemplateBuilder builder;
        if (file == null) {
            AddFieldQuickFix.$$$reportNull$$$0(8);
        }
        if ((initStatement = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)initStatement)) instanceof PyAssignmentStatement && (builder = TemplateBuilderFactory.getInstance().createTemplateBuilder(initStatement)) != null) {
            PyExpression assignedValue = ((PyAssignmentStatement)initStatement).getAssignedValue();
            PyExpression leftExpression = ((PyAssignmentStatement)initStatement).getLeftHandSideExpression();
            if (assignedValue != null && leftExpression != null) {
                if (this.replaceInitializer) {
                    builder.replaceElement((PsiElement)assignedValue, this.myInitializer);
                } else {
                    builder.replaceElement(leftExpression.getLastChild(), this.myIdentifier);
                }
                PythonTemplateRunner.runTemplate(file, builder);
            }
        }
    }

    @Nullable
    public static PsiElement addFieldToInit(Project project2, PyClass cls, String itemName, Function<? super String, ? extends PyStatement> callback) {
        if (cls != null && itemName != null) {
            PyClass ancestor;
            PyFunction init2 = cls.findMethodByName("__init__", false, null);
            if (init2 != null) {
                return AddFieldQuickFix.appendToMethod(init2, callback);
            }
            Iterator<PyClass> iterator = cls.getAncestorClasses(null).iterator();
            while (iterator.hasNext() && (init2 = (ancestor = iterator.next()).findMethodByName("__init__", false, null)) == null) {
            }
            PyFunction newInit = AddFieldQuickFix.createInitMethod(project2, cls, init2);
            AddFieldQuickFix.appendToMethod(newInit, callback);
            PsiElement addAnchor = null;
            PyFunction[] meths = cls.getMethods();
            if (meths.length > 0) {
                addAnchor = meths[0].getPrevSibling();
            }
            PyStatementList clsContent = cls.getStatementList();
            newInit = (PyFunction)clsContent.addAfter(newInit, addAnchor);
            PythonUiService.getInstance().showBalloonInfo(project2, PyPsiBundle.message("QFIX.add.field.to.class.popup.content.added.init", cls.getName(), itemName));
            PyStatementList statementList = newInit.getStatementList();
            PyStatement[] statements = statementList.getStatements();
            return statements.length != 0 ? statements[0] : null;
        }
        return null;
    }

    @NotNull
    private static PyFunction createInitMethod(Project project2, PyClass cls, @Nullable PyFunction ancestorInit) {
        @NonNls String paramList = ancestorInit != null ? ancestorInit.getParameterList().getText() : "(self)";
        @NonNls String functionText = "def __init__" + paramList + ":\n";
        if (ancestorInit == null) {
            functionText = functionText + "    pass";
        } else {
            PyClass ancestorClass = ancestorInit.getContainingClass();
            if (ancestorClass != null && !PyUtil.isObjectClass(ancestorClass)) {
                @NonNls StringBuilder sb = new StringBuilder();
                PyParameter[] params = ancestorInit.getParameterList().getParameters();
                boolean seen = false;
                if (cls.isNewStyleClass(null)) {
                    sb.append("super(");
                    if (!LanguageLevel.forElement((PsiElement)cls).isPy3K()) {
                        sb.append(cls.getName());
                        String self_name = params[0].getName();
                        sb.append(", ").append(self_name);
                    }
                    sb.append(").").append("__init__").append("(");
                } else {
                    sb.append(ancestorClass.getName());
                    sb.append(".__init__(self");
                    seen = true;
                }
                for (int i = 1; i < params.length; ++i) {
                    if (seen) {
                        sb.append(", ");
                    } else {
                        seen = true;
                    }
                    sb.append(params[i].getName());
                }
                sb.append(")");
                functionText = functionText + "    " + sb;
            } else {
                functionText = functionText + "    pass";
            }
        }
        PyFunction pyFunction = (PyFunction)PyElementGenerator.getInstance(project2).createFromText(LanguageLevel.getDefault(), PyFunction.class, functionText, new int[]{0});
        if (pyFunction == null) {
            AddFieldQuickFix.$$$reportNull$$$0(9);
        }
        return pyFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/AddFieldQuickFix";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/AddFieldQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "appendToMethod";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createInitMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getClassType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showTemplateBuilder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 9 -> new IllegalStateException(string);
        };
    }

    private static final class CreateFieldCallback
    implements Function<String, PyStatement> {
        private final Project myProject;
        private final String myItemName;
        private final String myInitializer;

        private CreateFieldCallback(Project project2, String itemName, String initializer) {
            this.myProject = project2;
            this.myItemName = itemName;
            this.myInitializer = initializer;
        }

        @Override
        public PyStatement apply(String selfName) {
            return (PyStatement)PyElementGenerator.getInstance(this.myProject).createFromText(LanguageLevel.getDefault(), PyStatement.class, selfName + "." + this.myItemName + " = " + this.myInitializer);
        }
    }
}

