/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.PlainDocString;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.toolbox.Substring;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyDocstringTypesInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyDocstringTypesInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyDocstringTypesInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyDocstringTypesInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction function) {
            String name2;
            if (function == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((name2 = function.getName()) != null && !name2.startsWith("_")) {
                this.checkDocString(function);
            }
        }

        private void checkDocString(@NotNull PyFunction function) {
            PySignature signature;
            PySignatureCacheManager manager;
            PyStringLiteralExpression docStringExpression;
            if (function == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((docStringExpression = function.getDocStringExpression()) != null && (manager = PySignatureCacheManager.getInstance((Project)function.getProject())) != null && (signature = manager.findSignature((PyAstFunction)function)) != null) {
                this.checkParameters(function, docStringExpression, signature);
            }
        }

        private void checkParameters(PyFunction function, PyStringLiteralExpression node, PySignature signature) {
            StructuredDocString docString = DocStringUtil.parseDocString(node);
            if (docString instanceof PlainDocString) {
                return;
            }
            for (String param : docString.getParameters()) {
                String dynamicTypeShortName;
                String dynamicType;
                @NlsSafe Substring type2 = docString.getParamTypeSubstring(param);
                if (type2 == null || (dynamicType = signature.getArgTypeQualifiedName(param)) == null || (dynamicTypeShortName = this.getShortestImportableName(function, dynamicType)) == null || this.match(function, dynamicType, type2.getValue())) continue;
                this.registerProblem((PsiElement)node, PyPsiBundle.message("INSP.docstring.types.dynamically.inferred.type.does.not.match.specified.type", dynamicTypeShortName, type2), ProblemHighlightType.WEAK_WARNING, null, type2.getTextRange(), new LocalQuickFix[]{new ChangeTypeQuickFix(param, type2, dynamicTypeShortName)});
            }
        }

        @Nullable
        private String getShortestImportableName(@Nullable PsiElement anchor, @NotNull String type2) {
            PyType pyType;
            if (type2 == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if ((pyType = PyTypeParser.getTypeByName(anchor, type2, this.myTypeEvalContext)) instanceof PyClassType) {
                return ((PyClassType)pyType).getPyClass().getQualifiedName();
            }
            if (pyType != null) {
                return Visitor.getPrintableName(pyType);
            }
            return type2;
        }

        @Nullable
        private static String getPrintableName(@Nullable PyType type2) {
            if (type2 instanceof PyUnionType) {
                return StreamEx.of(((PyUnionType)type2).getMembers()).map(Visitor::getPrintableName).joining((CharSequence)" or ");
            }
            if (type2 != null) {
                return type2.getName();
            }
            return "Any";
        }

        private boolean match(PsiElement anchor, String dynamicTypeName, String specifiedTypeName) {
            PyType dynamicType = PyTypeParser.getTypeByName(anchor, dynamicTypeName, this.myTypeEvalContext);
            PyType specifiedType = PyTypeParser.getTypeByName(anchor, specifiedTypeName, this.myTypeEvalContext);
            return PyTypeChecker.match(specifiedType, dynamicType, this.myTypeEvalContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyDocstringTypesInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkDocString";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getShortestImportableName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ChangeTypeQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myParamName;
        private final Substring myTypeSubstring;
        private final String myNewType;

        private ChangeTypeQuickFix(@NotNull String name2, @NotNull Substring substring, @NotNull String type2) {
            if (name2 == null) {
                ChangeTypeQuickFix.$$$reportNull$$$0(0);
            }
            if (substring == null) {
                ChangeTypeQuickFix.$$$reportNull$$$0(1);
            }
            if (type2 == null) {
                ChangeTypeQuickFix.$$$reportNull$$$0(2);
            }
            this.myParamName = name2;
            this.myTypeSubstring = substring;
            this.myNewType = type2;
        }

        @NotNull
        public String getName() {
            String string = PyPsiBundle.message("INSP.docstring.types.change.type", this.myParamName, this.myTypeSubstring.getValue(), this.myNewType);
            if (string == null) {
                ChangeTypeQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("INSP.docstring.types.fix.docstring", new Object[0]);
            if (string == null) {
                ChangeTypeQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project2 == null) {
                ChangeTypeQuickFix.$$$reportNull$$$0(5);
            }
            if (element == null) {
                ChangeTypeQuickFix.$$$reportNull$$$0(6);
            }
            if (updater == null) {
                ChangeTypeQuickFix.$$$reportNull$$$0(7);
            }
            String newValue = this.myTypeSubstring.getTextRange().replace(this.myTypeSubstring.getSuperString(), this.myNewType);
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project2);
            PyStringLiteralExpression stringLiteralExpression = PyUtil.as(element, PyStringLiteralExpression.class);
            if (stringLiteralExpression != null) {
                stringLiteralExpression.replace((PsiElement)elementGenerator.createDocstring(newValue).getExpression());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substring";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyDocstringTypesInspection$ChangeTypeQuickFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyDocstringTypesInspection$ChangeTypeQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

