/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JBColor;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyFrameListener;
import com.jetbrains.python.debugger.array.AbstractDataViewTable;
import com.jetbrains.python.debugger.array.AsyncArrayTableModel;
import com.jetbrains.python.debugger.array.JBTableWithRowHeaders;
import com.jetbrains.python.debugger.containerview.ColoredCellRenderer;
import com.jetbrains.python.debugger.containerview.DataViewStrategy;
import com.jetbrains.python.debugger.containerview.PyDataView;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanel;
import com.jetbrains.python.debugger.statistics.PyDataViewerCollector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 Z2\u00020\u00012\u00020\u0002:\u0003Z[\\B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020$J\u0018\u0010@\u001a\u00020>2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\tH\u0016J\u0018\u0010@\u001a\u00020>2\b\u0010B\u001a\u0004\u0018\u00010\u00142\u0006\u0010A\u001a\u00020\tJ\b\u0010C\u001a\u00020>H\u0016J\b\u0010D\u001a\u00020\u0018H\u0002J\b\u0010E\u001a\u00020>H\u0016J\u0018\u0010F\u001a\u00020>2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010G\u001a\u00020HH\u0014J)\u0010\f\u001a\u0004\u0018\u00010\u000b2\r\u0010I\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b*2\u0006\u0010J\u001a\u00020\t2\u0006\u0010A\u001a\u00020\tH\u0002J\b\u0010K\u001a\u000205H\u0014J\b\u0010L\u001a\u00020\tH\u0002J\u000e\u0010M\u001a\u00020>2\u0006\u0010N\u001a\u00020\tJ\u001d\u0010O\u001a\u00020>2\u000b\u0010P\u001a\u00070\u0014\u00a2\u0006\u0002\bQ2\u0006\u0010A\u001a\u00020\tH\u0002J\b\u0010R\u001a\u00020>H\u0002J\u0010\u0010S\u001a\u00020>2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010T\u001a\u00020>H\u0002J\"\u0010U\u001a\u00020>2\b\u0010V\u001a\u0004\u0018\u00010W2\u0006\u0010X\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\tH\u0014J(\u0010Y\u001a\u00020>2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020\u000b2\u0006\u0010G\u001a\u00020H2\u0006\u0010A\u001a\u00020\tH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR$\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001e\u0010!\u001a\u00020\t2\u0006\u0010 \u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001dR\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\u0004\u0018\u00010&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0010\u0010)\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010+\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b*2\r\u0010 \u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b*@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0016R\u0010\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020.X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u001c\u00104\u001a\u0004\u0018\u000105X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0014\u0010:\u001a\u00020\u0001X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<\u00a8\u0006]"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "frameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/python/debugger/PyFrameAccessor;)V", "colored", "", "debugValue", "Lcom/jetbrains/python/debugger/PyDebugValue;", "getDebugValue", "()Lcom/jetbrains/python/debugger/PyDebugValue;", "setDebugValue", "(Lcom/jetbrains/python/debugger/PyDebugValue;)V", "errorLabel", "Lcom/intellij/ui/dsl/builder/Cell;", "Ljavax/swing/JEditorPane;", "format", "", "getFormat", "()Ljava/lang/String;", "formatTextField", "Lcom/intellij/ui/EditorTextField;", "getFrameAccessor", "()Lcom/jetbrains/python/debugger/PyFrameAccessor;", "state", "isColored", "()Z", "setColored", "(Z)V", "<set-?>", "isModified", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel$Listener;", "model", "Lcom/jetbrains/python/debugger/array/AsyncArrayTableModel;", "getModel", "()Lcom/jetbrains/python/debugger/array/AsyncArrayTableModel;", "modifiedVarName", "Lcom/intellij/openapi/util/NlsSafe;", "originalVarName", "getOriginalVarName", "showFooter", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "getShowFooter", "()Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "sliceTextField", "getSliceTextField", "()Lcom/intellij/ui/EditorTextField;", "table", "Lcom/jetbrains/python/debugger/array/AbstractDataViewTable;", "getTable", "()Lcom/jetbrains/python/debugger/array/AbstractDataViewTable;", "setTable", "(Lcom/jetbrains/python/debugger/array/AbstractDataViewTable;)V", "tablePanel", "getTablePanel", "()Ljavax/swing/JPanel;", "addListener", "", "listener", "apply", "modifier", "name", "closeEditorTabs", "createEditorField", "dispose", "doStrategyInitExecution", "strategy", "Lcom/jetbrains/python/debugger/containerview/DataViewStrategy;", "expression", "pooledThread", "getOrCreateMainTable", "isVariablePresentInStack", "resize", "autoResize", "setError", "text", "Lcom/intellij/openapi/util/NlsContexts$Label;", "setupChangeListener", "updateDebugValue", "updateModel", "updateTabNameAndSliceField", "chunk", "Lcom/jetbrains/python/debugger/ArrayChunk;", "originalDebugValue", "updateUI", "Companion", "Listener", "PyDataViewCompletionProvider", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyDataViewerPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDataViewerPanel.kt\ncom/jetbrains/python/debugger/containerview/PyDataViewerPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,375:1\n1#2:376\n*E\n"})
public class PyDataViewerPanel
extends JPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    protected final Project project;
    @NotNull
    private final PyFrameAccessor frameAccessor;
    @NotNull
    private final EditorTextField sliceTextField;
    @NotNull
    private final JPanel tablePanel;
    @Nullable
    private AbstractDataViewTable table;
    @NotNull
    private EditorTextField formatTextField;
    private boolean colored;
    @NotNull
    private final CopyOnWriteArrayList<Listener> listeners;
    @Nullable
    private String originalVarName;
    @Nullable
    private String modifiedVarName;
    @Nullable
    private PyDebugValue debugValue;
    private boolean isModified;
    private Cell<? extends JEditorPane> errorLabel;
    @NotNull
    private final AtomicBooleanProperty showFooter;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String MODIFIED_VARIABLE_FORMAT = "%s*";

    public PyDataViewerPanel(@NotNull Project project2, @NotNull PyFrameAccessor frameAccessor) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        super(new BorderLayout());
        this.project = project2;
        this.frameAccessor = frameAccessor;
        this.sliceTextField = this.createEditorField();
        this.tablePanel = new JPanel(new BorderLayout());
        this.formatTextField = this.createEditorField();
        this.colored = PyDataView.Companion.isColoringEnabled(this.project);
        this.listeners = new CopyOnWriteArrayList();
        this.showFooter = new AtomicBooleanProperty(true);
        new PyDataViewCompletionProvider().apply(this.sliceTextField);
        DialogPanel panel2 = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ PyDataViewerPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ PyDataViewerPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)this.this$0.getTablePanel()).align(Align.FILL).resizableColumn();
                    }
                }), (int)1, null).resizableRow();
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ PyDataViewerPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)this.this$0.getSliceTextField()).align((Align)AlignX.FILL.INSTANCE).resizableColumn();
                        String string = PyBundle.message("form.data.viewer.format", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        $this$row.label(string);
                        $this$row.cell((JComponent)PyDataViewerPanel.access$getFormatTextField$p(this.this$0));
                    }
                }), (int)1, null).visibleIf((ObservableProperty)this.this$0.getShowFooter());
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ PyDataViewerPanel this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Row $this$row) {
                        void $this$invoke_u24lambda_u240;
                        Cell cell;
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Cell cell2 = cell = Row.text$default((Row)$this$row, (String)"", (int)0, null, (int)6, null);
                        PyDataViewerPanel pyDataViewerPanel = this.this$0;
                        boolean bl = false;
                        ((JEditorPane)$this$invoke_u24lambda_u240.getComponent()).setForeground((Color)JBColor.RED);
                        PyDataViewerPanel.access$setErrorLabel$p(pyDataViewerPanel, cell);
                    }
                }), (int)1, null);
            }
        }));
        this.add((Component)panel2, "Center");
        this.setupChangeListener();
    }

    @NotNull
    public final PyFrameAccessor getFrameAccessor() {
        return this.frameAccessor;
    }

    @NotNull
    public final EditorTextField getSliceTextField() {
        return this.sliceTextField;
    }

    @NotNull
    protected final JPanel getTablePanel() {
        return this.tablePanel;
    }

    @Nullable
    protected final AbstractDataViewTable getTable() {
        return this.table;
    }

    protected final void setTable(@Nullable AbstractDataViewTable abstractDataViewTable) {
        this.table = abstractDataViewTable;
    }

    @Nullable
    public final String getOriginalVarName() {
        return this.originalVarName;
    }

    @Nullable
    protected final PyDebugValue getDebugValue() {
        return this.debugValue;
    }

    protected final void setDebugValue(@Nullable PyDebugValue pyDebugValue) {
        this.debugValue = pyDebugValue;
    }

    @NotNull
    public final String getFormat() {
        CharSequence charSequence;
        String string = this.formatTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String format = string;
        CharSequence charSequence2 = format;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "%";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    public final boolean isColored() {
        return this.colored;
    }

    public final void setColored(boolean state) {
        this.colored = state;
        AbstractDataViewTable table = this.table;
        if (table != null && !table.isEmpty()) {
            TableCellRenderer tableCellRenderer = table.getDefaultRenderer(table.getColumnClass(0));
            Intrinsics.checkNotNull((Object)tableCellRenderer, (String)"null cannot be cast to non-null type com.jetbrains.python.debugger.containerview.ColoredCellRenderer");
            ((ColoredCellRenderer)tableCellRenderer).setColored(state);
            table.repaint();
        }
    }

    private final AsyncArrayTableModel getModel() {
        AbstractDataViewTable abstractDataViewTable = this.table;
        TableModel tableModel = abstractDataViewTable != null ? abstractDataViewTable.getModel() : null;
        return tableModel instanceof AsyncArrayTableModel ? (AsyncArrayTableModel)tableModel : null;
    }

    public final boolean isModified() {
        return this.isModified;
    }

    @NotNull
    protected final AtomicBooleanProperty getShowFooter() {
        return this.showFooter;
    }

    public void dispose() {
    }

    private final boolean isVariablePresentInStack() {
        XValueChildrenList xValueChildrenList = this.frameAccessor.loadFrame(null);
        if (xValueChildrenList == null) {
            return true;
        }
        XValueChildrenList values = xValueChildrenList;
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            if (!Intrinsics.areEqual((Object)values.getValue(i), (Object)((Object)this.debugValue))) continue;
            return true;
        }
        return false;
    }

    private final void setupChangeListener() {
        this.frameAccessor.addFrameListener(new PyFrameListener(this){
            final /* synthetic */ PyDataViewerPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void frameChanged() {
                if (this.this$0.getDebugValue() == null) {
                    return;
                }
                ApplicationManager.getApplication().executeOnPooledThread(() -> setupChangeListener.1.frameChanged$lambda$0(this.this$0));
            }

            private static final void frameChanged$lambda$0(PyDataViewerPanel this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                if (PyDataViewerPanel.access$isVariablePresentInStack(this$0)) {
                    PyDataViewerPanel.access$updateModel(this$0);
                }
            }
        });
    }

    private final void updateModel() {
        AsyncArrayTableModel asyncArrayTableModel = this.getModel();
        if (asyncArrayTableModel == null) {
            return;
        }
        AsyncArrayTableModel model2 = asyncArrayTableModel;
        model2.invalidateCache();
        if (this.isModified) {
            this.apply(this.modifiedVarName, true);
        } else {
            this.updateDebugValue(model2);
            ApplicationManager.getApplication().invokeLater(() -> PyDataViewerPanel.updateModel$lambda$1(this, model2));
        }
    }

    private final void updateDebugValue(AsyncArrayTableModel model2) {
        block5: {
            block4: {
                PyDebugValue oldValue = model2.getDebugValue();
                if (oldValue != null && !oldValue.isTemporary()) break block4;
                String string = this.sliceTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!(((CharSequence)string).length() == 0)) break block5;
            }
            return;
        }
        PyDebugValue newValue = this.getDebugValue(this.sliceTextField.getText(), false, false);
        if (newValue != null) {
            model2.setDebugValue(newValue);
        }
    }

    @NotNull
    protected AbstractDataViewTable getOrCreateMainTable() {
        JBTableWithRowHeaders mainTable = new JBTableWithRowHeaders(PyDataView.Companion.isAutoResizeEnabled(this.project));
        mainTable.getScrollPane().setBorder(BorderFactory.createEmptyBorder());
        this.tablePanel.add((Component)mainTable.getScrollPane(), "Center");
        this.table = mainTable;
        return mainTable;
    }

    private final EditorTextField createEditorField() {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)"");
        Project project2 = this.project;
        PythonFileType pythonFileType = PythonFileType.INSTANCE;
        return new EditorTextField(this, document, project2, pythonFileType){
            final /* synthetic */ PyDataViewerPanel this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, (FileType)$super_call_param$3, false, true);
            }

            @NotNull
            protected EditorEx createEditor() {
                EditorEx editorEx = super.createEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"createEditor(...)");
                EditorEx editor2 = editorEx;
                editor2.getSettings().setAdditionalColumnsCount(5);
                editor2.getContentComponent().addKeyListener(new KeyAdapter(this.this$0){
                    final /* synthetic */ PyDataViewerPanel this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void keyPressed(@NotNull KeyEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        if (e.getKeyCode() == 10) {
                            this.this$0.apply(this.this$0.getSliceTextField().getText(), false);
                        }
                    }
                });
                return editor2;
            }
        };
    }

    public final void apply(@Nullable String name2, boolean modifier) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> PyDataViewerPanel.apply$lambda$4(this, name2, modifier));
        if (!modifier) {
            PyDataViewerCollector.INSTANCE.getSLICING_APPLIED_EVENT().log();
        }
    }

    public void apply(@NotNull PyDebugValue debugValue, boolean modifier) {
        Intrinsics.checkNotNullParameter((Object)((Object)debugValue), (String)"debugValue");
        Cell<? extends JEditorPane> cell = this.errorLabel;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorLabel");
            cell = null;
        }
        cell.visible(false);
        String type2 = debugValue.getType();
        DataViewStrategy strategy = DataViewStrategy.getStrategy(type2);
        if (strategy == null) {
            Object[] objectArray = new Object[]{type2};
            String string = PyBundle.message("debugger.data.view.type.is.not.supported", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.setError(string, modifier);
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> PyDataViewerPanel.apply$lambda$8(this, debugValue, strategy, type2, modifier));
    }

    protected void doStrategyInitExecution(@NotNull PyFrameAccessor frameAccessor, @NotNull DataViewStrategy strategy) throws PyDebuggerException {
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
    }

    protected void updateTabNameAndSliceField(@Nullable ArrayChunk chunk, @NotNull PyDebugValue originalDebugValue, boolean modifier) {
        Object object;
        String realName;
        Intrinsics.checkNotNullParameter((Object)((Object)originalDebugValue), (String)"originalDebugValue");
        ArrayChunk arrayChunk = chunk;
        PyDebugValue debugValue = arrayChunk != null ? arrayChunk.getValue() : null;
        String shownName = realName = debugValue == null || Intrinsics.areEqual((Object)debugValue.getName(), (Object)originalDebugValue.getTempName()) ? originalDebugValue.getName() : chunk.getSlicePresentation();
        if (modifier && !Intrinsics.areEqual((Object)this.originalVarName, (Object)shownName)) {
            String string = MODIFIED_VARIABLE_FORMAT;
            object = new Object[]{this.originalVarName};
            String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            shownName = string2;
        } else {
            this.originalVarName = realName;
        }
        this.sliceTextField.setText(this.originalVarName);
        this.modifiedVarName = realName;
        if (this.sliceTextField.getEditor() != null) {
            CaretModel caretModel = this.sliceTextField.getCaretModel();
            String string = this.originalVarName;
            Intrinsics.checkNotNull((Object)string);
            caretModel.moveToOffset(string.length());
        }
        for (Listener listener2 : this.listeners) {
            object = shownName;
            Intrinsics.checkNotNull((Object)object);
            listener2.onNameChanged((String)object);
        }
        if (chunk != null) {
            this.formatTextField.setText(chunk.getFormat());
        }
    }

    protected void updateUI(@NotNull ArrayChunk chunk, @NotNull PyDebugValue originalDebugValue, @NotNull DataViewStrategy strategy, boolean modifier) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        Intrinsics.checkNotNullParameter((Object)((Object)originalDebugValue), (String)"originalDebugValue");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        PyDebugValue debugValue = chunk.getValue();
        AsyncArrayTableModel model2 = strategy.createTableModel(chunk.getRows(), chunk.getColumns(), this, debugValue);
        model2.addToCache(chunk);
        UIUtil.invokeLaterIfNeeded(() -> PyDataViewerPanel.updateUI$lambda$9(this, model2, modifier, chunk, originalDebugValue, strategy));
    }

    private final PyDebugValue getDebugValue(String expression, boolean pooledThread, boolean modifier) {
        PyDebugValue pyDebugValue;
        try {
            PyDebugValue value = this.frameAccessor.evaluate(expression, false, true);
            if (value == null || value.isErrorOnEval()) {
                Runnable runnable = () -> PyDataViewerPanel.getDebugValue$lambda$10(this, value, expression, modifier);
                if (pooledThread) {
                    ApplicationManager.getApplication().invokeLater(runnable);
                } else {
                    runnable.run();
                }
                return null;
            }
            pyDebugValue = value;
        }
        catch (PyDebuggerException e) {
            Runnable runnable = () -> PyDataViewerPanel.getDebugValue$lambda$11(this, e, modifier);
            if (pooledThread) {
                ApplicationManager.getApplication().invokeLater(runnable);
            } else {
                runnable.run();
            }
            pyDebugValue = null;
        }
        return pyDebugValue;
    }

    public final void resize(boolean autoResize) {
        AbstractDataViewTable abstractDataViewTable = this.table;
        if (abstractDataViewTable != null) {
            abstractDataViewTable.setAutoResize(autoResize);
        }
        this.apply(this.sliceTextField.getText(), false);
    }

    private final void setError(String text, boolean modifier) {
        String string;
        Cell<? extends JEditorPane> cell = this.errorLabel;
        if (cell == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorLabel");
            cell = null;
        }
        cell.visible(true);
        Cell<? extends JEditorPane> cell2 = this.errorLabel;
        if (cell2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"errorLabel");
            cell2 = null;
        }
        if (modifier) {
            Object[] objectArray = new Object[]{text};
            string = PyBundle.message("debugger.dataviewer.modifier.error", objectArray);
        } else {
            string = text;
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        TextFieldKt.text(cell2, (String)string2);
        if (!modifier) {
            AbstractDataViewTable abstractDataViewTable = this.table;
            if (abstractDataViewTable != null) {
                abstractDataViewTable.setEmpty();
            }
            for (Listener listener2 : this.listeners) {
                String string3 = PyBundle.message("debugger.data.view.empty.tab", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                listener2.onNameChanged(string3);
            }
        }
    }

    public final void addListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public void closeEditorTabs() {
    }

    private static final void updateModel$lambda$1(PyDataViewerPanel this$0, AsyncArrayTableModel $model) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        if (this$0.isShowing()) {
            $model.fireTableDataChanged();
        }
    }

    private static final void apply$lambda$4$lambda$3(PyDebugValue $debugValue, PyDataViewerPanel this$0, boolean $modifier) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            PyDebugValue pyDebugValue = $debugValue;
            if (pyDebugValue == null) break block0;
            PyDebugValue it = pyDebugValue;
            boolean bl = false;
            this$0.apply(it, $modifier);
        }
    }

    private static final void apply$lambda$4(PyDataViewerPanel this$0, String $name, boolean $modifier) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PyDebugValue debugValue = this$0.getDebugValue($name, true, $modifier);
        ApplicationManager.getApplication().invokeLater(() -> PyDataViewerPanel.apply$lambda$4$lambda$3(debugValue, this$0, $modifier));
    }

    private static final void apply$lambda$8$lambda$5(PyDataViewerPanel this$0, ArrayChunk $arrayChunk, PyDebugValue $debugValue, DataViewStrategy $strategy, boolean $modifier) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$debugValue), (String)"$debugValue");
        Intrinsics.checkNotNull((Object)$arrayChunk);
        this$0.updateUI($arrayChunk, $debugValue, $strategy, $modifier);
        this$0.isModified = $modifier;
        this$0.debugValue = $debugValue;
    }

    private static final void apply$lambda$8$lambda$6(PyDataViewerPanel this$0, IllegalArgumentException $e, boolean $modifier) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        String string = $e.getLocalizedMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
        this$0.setError(string, $modifier);
    }

    private static final void apply$lambda$8(PyDataViewerPanel this$0, PyDebugValue $debugValue, DataViewStrategy $strategy, String $type, boolean $modifier) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$debugValue), (String)"$debugValue");
        try {
            PyFrameAccessor pyFrameAccessor = $debugValue.getFrameAccessor();
            Intrinsics.checkNotNullExpressionValue((Object)pyFrameAccessor, (String)"getFrameAccessor(...)");
            this$0.doStrategyInitExecution(pyFrameAccessor, $strategy);
            ArrayChunk arrayChunk = $debugValue.getFrameAccessor().getArrayItems($debugValue, 0, 0, 0, 0, this$0.getFormat());
            ApplicationManager.getApplication().invokeLater(() -> PyDataViewerPanel.apply$lambda$8$lambda$5(this$0, arrayChunk, $debugValue, $strategy, $modifier));
        }
        catch (IllegalArgumentException e) {
            ApplicationManager.getApplication().invokeLater(() -> PyDataViewerPanel.apply$lambda$8$lambda$6(this$0, e, $modifier));
        }
        catch (PyDebuggerException e) {
            LOG.error((Throwable)e);
        }
        catch (Exception e) {
            boolean bl;
            String string = e.getMessage();
            if (string != null) {
                String it = string;
                boolean bl2 = false;
                bl = StringsKt.contains$default((CharSequence)it, (CharSequence)"Numpy is not available", (boolean)false, (int)2, null);
            } else {
                bl = false;
            }
            if (bl) {
                Object[] objectArray = new Object[]{$type};
                String string2 = PyBundle.message("debugger.data.view.numpy.is.not.available", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                this$0.setError(string2, $modifier);
            }
            LOG.error((Throwable)e);
        }
    }

    private static final void updateUI$lambda$9(PyDataViewerPanel this$0, AsyncArrayTableModel $model, boolean $modifier, ArrayChunk $chunk, PyDebugValue $originalDebugValue, DataViewStrategy $strategy) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$chunk, (String)"$chunk");
        Intrinsics.checkNotNullParameter((Object)((Object)$originalDebugValue), (String)"$originalDebugValue");
        Intrinsics.checkNotNullParameter((Object)$strategy, (String)"$strategy");
        AbstractDataViewTable abstractDataViewTable = this$0.table;
        if (abstractDataViewTable == null) {
            abstractDataViewTable = this$0.getOrCreateMainTable();
        }
        AbstractDataViewTable table = abstractDataViewTable;
        table.setModel($model, $modifier);
        this$0.updateTabNameAndSliceField($chunk, $originalDebugValue, $modifier);
        ColoredCellRenderer cellRenderer = $strategy.createCellRenderer(Double.MIN_VALUE, Double.MAX_VALUE, $chunk);
        cellRenderer.setColored(this$0.colored);
        $model.fireTableDataChanged();
        $model.fireTableCellUpdated(0, 0);
        if (table.getColumnCount() > 0) {
            table.setDefaultRenderer(table.getColumnClass(0), cellRenderer);
        }
        table.setShowColumns($strategy.showColumnHeader());
    }

    private static final void getDebugValue$lambda$10(PyDataViewerPanel this$0, PyDebugValue $value, String $expression, boolean $modifier) {
        String string;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($value != null && $value.getValue() != null) {
            String string2 = $value.getValue();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else {
            Object[] objectArray = new Object[]{$expression};
            string = PyBundle.message("debugger.data.view.failed.to.evaluate.expression", objectArray);
        }
        String string3 = string;
        Intrinsics.checkNotNull((Object)string3);
        this$0.setError(string3, $modifier);
    }

    private static final void getDebugValue$lambda$11(PyDataViewerPanel this$0, PyDebuggerException $e, boolean $modifier) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$e, (String)"$e");
        String string = $e.getTracebackError();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTracebackError(...)");
        this$0.setError(string, $modifier);
    }

    public static final /* synthetic */ boolean access$isVariablePresentInStack(PyDataViewerPanel $this) {
        return $this.isVariablePresentInStack();
    }

    public static final /* synthetic */ void access$updateModel(PyDataViewerPanel $this) {
        $this.updateModel();
    }

    public static final /* synthetic */ EditorTextField access$getFormatTextField$p(PyDataViewerPanel $this) {
        return $this.formatTextField;
    }

    public static final /* synthetic */ void access$setErrorLabel$p(PyDataViewerPanel $this, Cell cell) {
        $this.errorLabel = cell;
    }

    static {
        Logger logger = Logger.getInstance(PyDataViewerPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MODIFIED_VARIABLE_FORMAT", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel$Listener;", "", "onNameChanged", "", "name", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "intellij.python.community.impl"})
    public static interface Listener {
        public void onNameChanged(@NotNull String var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel$PyDataViewCompletionProvider;", "Lcom/intellij/util/TextFieldCompletionProvider;", "(Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel;)V", "availableValues", "", "Lcom/jetbrains/python/debugger/PyDebugValue;", "getAvailableValues", "()Ljava/util/List;", "addCompletionVariants", "", "text", "", "offset", "", "prefix", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nPyDataViewerPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDataViewerPanel.kt\ncom/jetbrains/python/debugger/containerview/PyDataViewerPanel$PyDataViewCompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,375:1\n1045#2:376\n*S KotlinDebug\n*F\n+ 1 PyDataViewerPanel.kt\ncom/jetbrains/python/debugger/containerview/PyDataViewerPanel$PyDataViewCompletionProvider\n*L\n340#1:376\n*E\n"})
    private final class PyDataViewCompletionProvider
    extends TextFieldCompletionProvider {
        protected void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result2) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            Iterable $this$sortedBy$iv = this.getAvailableValues();
            boolean $i$f$sortedBy = false;
            List values = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PyDebugValue obj = (PyDebugValue)((Object)a);
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)obj.getName());
                    obj = (PyDebugValue)((Object)b);
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)obj.getName())));
                }
            });
            int n = values.size();
            for (int i = 0; i < n; ++i) {
                LookupElementBuilder element;
                PyDebugValue value = (PyDebugValue)((Object)values.get(i));
                Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((String)value.getName()).withTypeText(value.getType(), true), (String)"withTypeText(...)");
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)element), (double)(-((double)i))));
            }
        }

        private final List<PyDebugValue> getAvailableValues() {
            List values = new ArrayList();
            try {
                XValueChildrenList xValueChildrenList = PyDataViewerPanel.this.getFrameAccessor().loadFrame(null);
                if (xValueChildrenList == null) {
                    return values;
                }
                XValueChildrenList list = xValueChildrenList;
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    XValue xValue = list.getValue(i);
                    Intrinsics.checkNotNull((Object)xValue, (String)"null cannot be cast to non-null type com.jetbrains.python.debugger.PyDebugValue");
                    PyDebugValue value = (PyDebugValue)xValue;
                    String type2 = value.getType();
                    if (DataViewStrategy.getStrategy(type2) == null) continue;
                    values.add(value);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            return values;
        }
    }
}

