/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.containerview.PyDataView;
import com.jetbrains.python.debugger.containerview.PyDataViewDialog;
import com.jetbrains.python.debugger.containerview.PyDataViewPanelFactory;
import com.jetbrains.python.debugger.containerview.PyDataViewerPanel;
import com.jetbrains.python.icons.PythonIcons;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 /2\u00020\u0001:\u0002/0B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\fJ\u0014\u0010\u0014\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0 J\b\u0010!\u001a\u00020\u0012H\u0002J\u000e\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\b\u0010)\u001a\u00020\fH\u0002J\u000e\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020,J\u0010\u0010-\u001a\u00020\f2\u0006\u0010+\u001a\u00020,H\u0002J\u000e\u0010.\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataView;", "Lcom/intellij/openapi/project/DumbAware;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "selectedInfos", "", "Lcom/intellij/execution/process/ProcessHandler;", "Lcom/intellij/ui/content/Content;", "addEmptyContent", "", "addTab", "frameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "changeAutoResize", "autoResize", "", "closeDisconnectedFromConsoleTabs", "closeTabs", "ifClose", "Ljava/util/function/Predicate;", "createEmptyContent", "Lcom/intellij/openapi/ui/DialogPanel;", "getFrameAccessor", "handler", "getPanel", "Lcom/jetbrains/python/debugger/containerview/PyDataViewerPanel;", "component", "Ljavax/swing/JComponent;", "getVisibleTabs", "", "hasOnlyEmptyTab", "init", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "isConnected", "accessor", "Lcom/jetbrains/python/console/PydevConsoleCommunication;", "restoreSelectedInfo", "saveSelectedInfo", "show", "value", "Lcom/jetbrains/python/debugger/PyDebugValue;", "showInToolWindow", "updateTabs", "Companion", "NewViewerAction", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyDataView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDataView.kt\ncom/jetbrains/python/debugger/containerview/PyDataView\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,266:1\n23#2:267\n13309#3,2:268\n13309#3,2:270\n13309#3,2:272\n1855#4,2:274\n*S KotlinDebug\n*F\n+ 1 PyDataView.kt\ncom/jetbrains/python/debugger/containerview/PyDataView\n*L\n89#1:267\n106#1:268,2\n122#1:270,2\n237#1:272,2\n113#1:274,2\n*E\n"})
public final class PyDataView
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Map<ProcessHandler, Content> selectedInfos;
    private ContentManager contentManager;
    @NotNull
    private static final String DATA_VIEWER_ID = "SciView";
    @NotNull
    public static final String COLORED_BY_DEFAULT = "python.debugger.dataview.coloredbydefault";
    @NotNull
    public static final String AUTO_RESIZE = "python.debugger.dataview.autoresize";
    @NotNull
    private static final String HELP_ID = "reference.toolWindows.PyDataView";

    public PyDataView(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.selectedInfos = new ConcurrentHashMap();
    }

    public final void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setStripeTitle(PyBundle.message("debugger.data.view.title", new Object[0]));
        toolWindow.setHelpId(HELP_ID);
        toolWindow.setAvailable(true);
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        this.contentManager = contentManager;
        this.addEmptyContent();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(toolWindow){
            final /* synthetic */ ToolWindow $toolWindow;
            {
                this.$toolWindow = $toolWindow;
            }

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                ToolWindow window = toolWindowManager.getToolWindow("SciView");
                if (window == null) {
                    return;
                }
                if (this.$toolWindow.isAvailable() && this.$toolWindow.getType() == ToolWindowType.FLOATING && !this.$toolWindow.isVisible()) {
                    this.$toolWindow.setShowStripeButton(false);
                    this.$toolWindow.getContentManager().removeAllContents(true);
                }
            }
        });
    }

    private final void addEmptyContent() {
        Content content2 = ContentFactory.getInstance().createContent((JComponent)this.createEmptyContent(), null, false);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
        Content content3 = content2;
        content3.setCloseable(false);
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager = null;
        }
        contentManager.addContent(content3);
    }

    public final void show(@NotNull PyDebugValue value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (ToolWindowManager.Companion.getInstance(this.project).getToolWindow(DATA_VIEWER_ID) != null) {
            this.showInToolWindow(value);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> PyDataView.show$lambda$0(this, value));
        }
    }

    private final void showInToolWindow(PyDebugValue value) {
        ToolWindow window = ToolWindowManager.Companion.getInstance(this.project).getToolWindow(DATA_VIEWER_ID);
        if (window == null) {
            PyDataView $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PyDataView.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Tool window 'SciView' is not found");
            return;
        }
        window.getContentManager().getReady((Object)this).doWhenDone(() -> PyDataView.showInToolWindow$lambda$2(this, value, window));
    }

    public final void closeTabs(@NotNull Predicate<PyFrameAccessor> ifClose) {
        Intrinsics.checkNotNullParameter(ifClose, (String)"ifClose");
        List tabsToRemove = new ArrayList();
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager = null;
        }
        Content[] contentArray = contentManager.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        Object[] $this$forEach$iv = contentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Content it = (Content)element$iv;
            boolean bl = false;
            JComponent jComponent = it.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            if (!ifClose.test(this.getPanel(jComponent).getFrameAccessor())) continue;
            Intrinsics.checkNotNull((Object)it);
            tabsToRemove.add(it);
        }
        ApplicationManager.getApplication().invokeLater(() -> PyDataView.closeTabs$lambda$5(tabsToRemove, this));
    }

    public final void updateTabs(@NotNull ProcessHandler handler2) {
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        this.saveSelectedInfo();
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager = null;
        }
        Content[] contentArray = contentManager.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        Object[] $this$forEach$iv = contentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean shouldBeShown;
            Content content2 = (Content)element$iv;
            boolean bl = false;
            JComponent jComponent = content2.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            PyDataViewerPanel panel2 = this.getPanel(jComponent);
            PyFrameAccessor accessor = panel2.getFrameAccessor();
            if (!(accessor instanceof PyDebugProcess) || (shouldBeShown = Comparing.equal((Object)handler2, (Object)((PyDebugProcess)accessor).getProcessHandler()))) continue;
            ContentManager contentManager2 = this.contentManager;
            if (contentManager2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
                contentManager2 = null;
            }
            contentManager2.removeContent(content2, true);
        }
        this.restoreSelectedInfo(handler2);
    }

    private final void restoreSelectedInfo(ProcessHandler handler2) {
        Content savedSelection = this.selectedInfos.get(handler2);
        if (savedSelection != null) {
            ContentManager contentManager = this.contentManager;
            if (contentManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
                contentManager = null;
            }
            contentManager.setSelectedContent(savedSelection);
            this.selectedInfos.remove(handler2);
        }
    }

    private final void saveSelectedInfo() {
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager = null;
        }
        Content selectedInfo = contentManager.getSelectedContent();
        if (!this.hasOnlyEmptyTab() && selectedInfo != null) {
            JComponent jComponent = selectedInfo.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            PyFrameAccessor accessor = this.getPanel(jComponent).getFrameAccessor();
            if (accessor instanceof PyDebugProcess) {
                Map<ProcessHandler, Content> map = this.selectedInfos;
                ProcessHandler processHandler = ((PyDebugProcess)accessor).getProcessHandler();
                Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
                map.put(processHandler, selectedInfo);
            }
        }
    }

    private final PyFrameAccessor getFrameAccessor(ProcessHandler handler2) {
        for (PyDebugProcess process2 : XDebuggerManager.getInstance((Project)this.project).getDebugProcesses(PyDebugProcess.class)) {
            if (!Comparing.equal((Object)handler2, (Object)process2.getProcessHandler())) continue;
            return process2;
        }
        return null;
    }

    public final void closeDisconnectedFromConsoleTabs() {
        this.closeTabs(arg_0 -> PyDataView.closeDisconnectedFromConsoleTabs$lambda$7(this, arg_0));
    }

    public final boolean isConnected(@NotNull PydevConsoleCommunication accessor) {
        Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
        return !accessor.isCommunicationClosed();
    }

    private final DialogPanel createEmptyContent() {
        return BuilderKt.panel((Function1)createEmptyContent.1.INSTANCE);
    }

    @NotNull
    public final Content addTab(@NotNull PyFrameAccessor frameAccessor) {
        Object[] objectArray;
        PyDataViewPanelFactory factory;
        Intrinsics.checkNotNullParameter((Object)frameAccessor, (String)"frameAccessor");
        if (this.hasOnlyEmptyTab()) {
            ContentManager contentManager = this.contentManager;
            if (contentManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
                contentManager = null;
            }
            contentManager.removeAllContents(true);
        }
        PyDataViewerPanel panel2 = null;
        Iterator iterator = PyDataViewPanelFactory.EP_NAME.getExtensionList().iterator();
        while (iterator.hasNext() && (panel2 = (factory = (PyDataViewPanelFactory)iterator.next()).createDataViewPanel(this.project, frameAccessor)) == null) {
        }
        if (panel2 == null) {
            panel2 = new PyDataViewerPanel(this.project, frameAccessor);
        }
        Content content2 = ContentFactory.getInstance().createContent((JComponent)panel2, null, false);
        Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
        Content content3 = content2;
        content3.setCloseable(true);
        if (frameAccessor instanceof PydevConsoleCommunication) {
            content3.setIcon(PythonIcons.Python.PythonConsole);
            content3.setDescription(PyBundle.message("debugger.data.view.connected.to.python.console", new Object[0]));
        } else if (frameAccessor instanceof PyDebugProcess) {
            content3.setIcon(AllIcons.Toolwindows.ToolWindowDebugger);
            objectArray = new Object[]{((PyDebugProcess)frameAccessor).getSession().getSessionName()};
            content3.setDescription(PyBundle.message("debugger.data.view.connected.to.debug.session", objectArray));
        }
        objectArray = new AnAction[]{new NewViewerAction(frameAccessor)};
        content3.setActions((ActionGroup)new DefaultActionGroup((AnAction[])objectArray), "DataView", (JComponent)panel2);
        panel2.addListener(arg_0 -> PyDataView.addTab$lambda$8(content3, arg_0));
        Disposer.register((Disposable)((Disposable)content3), (Disposable)panel2);
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager = null;
        }
        contentManager.addContent(content3);
        ContentManager contentManager2 = this.contentManager;
        if (contentManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager2 = null;
        }
        contentManager2.setSelectedContent(content3);
        return content3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasOnlyEmptyTab() {
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager = null;
        }
        if (contentManager.getContentCount() != 1) return false;
        ContentManager contentManager2 = this.contentManager;
        if (contentManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager2 = null;
        }
        Content[] contentArray = contentManager2.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        if (((Content)ArraysKt.first((Object[])contentArray)).getComponent() instanceof PyDataViewerPanel) return false;
        return true;
    }

    @NotNull
    public final List<Content> getVisibleTabs() {
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager = null;
        }
        Content[] contentArray = contentManager.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        return ArraysKt.toList((Object[])contentArray);
    }

    public final void changeAutoResize(boolean autoResize) {
        ContentManager contentManager = this.contentManager;
        if (contentManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
            contentManager = null;
        }
        Content[] contentArray = contentManager.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        Object[] $this$forEach$iv = contentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Content it = (Content)element$iv;
            boolean bl = false;
            JComponent jComponent = it.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            this.getPanel(jComponent).resize(autoResize);
        }
    }

    @NotNull
    public final PyDataViewerPanel getPanel(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        return (PyDataViewerPanel)component2;
    }

    private static final void show$lambda$0(PyDataView this$0, PyDebugValue $value) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$value), (String)"$value");
        new PyDataViewDialog(this$0.project, $value).show();
    }

    private static final void showInToolWindow$lambda$2$lambda$1(ToolWindow $window, PyDataViewerPanel $dataViewerPanel) {
        Intrinsics.checkNotNullParameter((Object)$dataViewerPanel, (String)"$dataViewerPanel");
        $window.getComponent().requestFocusInWindow();
        $dataViewerPanel.requestFocusInWindow();
    }

    private static final void showInToolWindow$lambda$2(PyDataView this$0, PyDebugValue $value, ToolWindow $window) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$value), (String)"$value");
        PyFrameAccessor pyFrameAccessor = $value.getFrameAccessor();
        Intrinsics.checkNotNullExpressionValue((Object)pyFrameAccessor, (String)"getFrameAccessor(...)");
        Content selectedInfo = this$0.addTab(pyFrameAccessor);
        JComponent jComponent = selectedInfo.getComponent();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.jetbrains.python.debugger.containerview.PyDataViewerPanel");
        PyDataViewerPanel dataViewerPanel = (PyDataViewerPanel)jComponent;
        dataViewerPanel.apply($value, false);
        $window.show(() -> PyDataView.showInToolWindow$lambda$2$lambda$1($window, dataViewerPanel));
    }

    private static final void closeTabs$lambda$5(List $tabsToRemove, PyDataView this$0) {
        Intrinsics.checkNotNullParameter((Object)$tabsToRemove, (String)"$tabsToRemove");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Iterable $this$forEach$iv = $tabsToRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Content it = (Content)element$iv;
            boolean bl = false;
            ContentManager contentManager = this$0.contentManager;
            if (contentManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentManager");
                contentManager = null;
            }
            contentManager.removeContent(it, true);
            JComponent jComponent = it.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            this$0.getPanel(jComponent).closeEditorTabs();
        }
    }

    private static final boolean closeDisconnectedFromConsoleTabs$lambda$7(PyDataView this$0, PyFrameAccessor frameAccessor) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return frameAccessor instanceof PydevConsoleCommunication && !this$0.isConnected((PydevConsoleCommunication)frameAccessor);
    }

    private static final void addTab$lambda$8(Content $content, String it) {
        Intrinsics.checkNotNullParameter((Object)$content, (String)"$content");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $content.setDisplayName(it);
    }

    @JvmStatic
    public static final boolean isAutoResizeEnabled(@NotNull Project project2) {
        return Companion.isAutoResizeEnabled(project2);
    }

    @JvmStatic
    public static final boolean isColoringEnabled(@NotNull Project project2) {
        return Companion.isColoringEnabled(project2);
    }

    @JvmStatic
    public static final void setColoringEnabled(@NotNull Project project2, boolean value) {
        Companion.setColoringEnabled(project2, value);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataView$Companion;", "", "()V", "AUTO_RESIZE", "", "COLORED_BY_DEFAULT", "DATA_VIEWER_ID", "HELP_ID", "getInstance", "Lcom/jetbrains/python/debugger/containerview/PyDataView;", "project", "Lcom/intellij/openapi/project/Project;", "isAutoResizeEnabled", "", "isColoringEnabled", "setColoringEnabled", "", "value", "intellij.python.community.impl"})
    @SourceDebugExtension(value={"SMAP\nPyDataView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDataView.kt\ncom/jetbrains/python/debugger/containerview/PyDataView$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,266:1\n31#2,2:267\n*S KotlinDebug\n*F\n+ 1 PyDataView.kt\ncom/jetbrains/python/debugger/containerview/PyDataView$Companion\n*L\n264#1:267,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isAutoResizeEnabled(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return PropertiesComponent.getInstance((Project)project2).getBoolean(PyDataView.AUTO_RESIZE, true);
        }

        @JvmStatic
        public final boolean isColoringEnabled(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            return PropertiesComponent.getInstance((Project)project2).getBoolean(PyDataView.COLORED_BY_DEFAULT, true);
        }

        @JvmStatic
        public final void setColoringEnabled(@NotNull Project project2, boolean value) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            PropertiesComponent.getInstance((Project)project2).setValue(PyDataView.COLORED_BY_DEFAULT, value, true);
        }

        @NotNull
        public final PyDataView getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<PyDataView> serviceClass$iv = PyDataView.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (PyDataView)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/debugger/containerview/PyDataView$NewViewerAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "myFrameAccessor", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "(Lcom/jetbrains/python/debugger/containerview/PyDataView;Lcom/jetbrains/python/debugger/PyFrameAccessor;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.python.community.impl"})
    public final class NewViewerAction
    extends DumbAwareAction {
        @NotNull
        private final PyFrameAccessor myFrameAccessor;

        public NewViewerAction(PyFrameAccessor myFrameAccessor) {
            Intrinsics.checkNotNullParameter((Object)myFrameAccessor, (String)"myFrameAccessor");
            super(PyBundle.message("debugger.data.view.view.new.container", new Object[0]), PyBundle.message("debugger.data.view.open.new.container.viewer", new Object[0]), AllIcons.General.Add);
            this.myFrameAccessor = myFrameAccessor;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PyDataView.this.addTab(this.myFrameAccessor);
        }
    }
}

