/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.typing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.psi.LanguageLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0013\u001a\u00020\u0010J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004J\u001e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016R\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR(\u0010\r\u001a\u001c\u0012\u0004\u0012\u00020\n\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/python/codeInsight/typing/PyTypeShed;", "", "()V", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "directory$delegate", "Lkotlin/Lazy;", "directoryPath", "", "getDirectoryPath", "()Ljava/lang/String;", "stdlibNamesAvailableOnlyInSubsetOfSupportedLanguageLevels", "", "Lkotlin/Pair;", "Lcom/jetbrains/python/psi/LanguageLevel;", "findRootsForLanguageLevel", "", "level", "findRootsForSdk", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "isInStandardLibrary", "", "file", "isInThirdPartyLibraries", "isInside", "maySearchForStubInRoot", "name", "Lcom/intellij/psi/util/QualifiedName;", "root", "intellij.python.psi.impl"})
@SourceDebugExtension(value={"SMAP\nPyTypeShed.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyTypeShed.kt\ncom/jetbrains/python/codeInsight/typing/PyTypeShed\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1360#2:174\n1446#2,5:175\n*S KotlinDebug\n*F\n+ 1 PyTypeShed.kt\ncom/jetbrains/python/codeInsight/typing/PyTypeShed\n*L\n138#1:174\n138#1:175,5\n*E\n"})
public final class PyTypeShed {
    @NotNull
    public static final PyTypeShed INSTANCE = new PyTypeShed();
    @NotNull
    private static final Map<String, Pair<LanguageLevel, LanguageLevel>> stdlibNamesAvailableOnlyInSubsetOfSupportedLanguageLevels;
    @NotNull
    private static final Lazy directory$delegate;

    private PyTypeShed() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean maySearchForStubInRoot(@NotNull QualifiedName name2, @NotNull VirtualFile root, @NotNull Sdk sdk2) {
        List<PyPackage> list;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        if (this.isInStandardLibrary(root)) {
            String string = name2.getFirstComponent();
            if (string == null) {
                return true;
            }
            String head = string;
            Pair<LanguageLevel, LanguageLevel> pair = stdlibNamesAvailableOnlyInSubsetOfSupportedLanguageLevels.get(head);
            if (pair == null) {
                return true;
            }
            Pair<LanguageLevel, LanguageLevel> languageLevels = pair;
            LanguageLevel languageLevel = PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk2);
            Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"getLanguageLevelForSdk(...)");
            LanguageLevel currentLanguageLevel = languageLevel;
            if (!currentLanguageLevel.isAtLeast((LanguageLevel)languageLevels.getFirst())) return false;
            LanguageLevel it = (LanguageLevel)languageLevels.getSecond();
            boolean bl = false;
            if (it == null) return true;
            if (!it.isAtLeast(currentLanguageLevel)) return false;
            return true;
        }
        if (!this.isInThirdPartyLibraries(root)) return false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        String string = name2.getFirstComponent();
        if (string == null) {
            return false;
        }
        String possiblePackage = string;
        String alternativePossiblePackages = PyPsiPackageUtil.INSTANCE.moduleToPackageName(possiblePackage, "");
        PyPackageManager pyPackageManager = PyPackageManagers.getInstance().forSdk(sdk2);
        Intrinsics.checkNotNullExpressionValue((Object)pyPackageManager, (String)"forSdk(...)");
        PyPackageManager packageManager = pyPackageManager;
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !PlatformUtils.isFleetBackend()) {
            list = packageManager.refreshAndGetPackages(false);
        } else {
            list = packageManager.getPackages();
            if (list == null) {
                return true;
            }
        }
        List<PyPackage> list2 = list;
        Intrinsics.checkNotNull(list2);
        List<PyPackage> installedPackages2 = list2;
        PyRequirement pyRequirement = packageManager.parseRequirement(possiblePackage);
        if ((pyRequirement != null ? pyRequirement.match((Collection<? extends PyPackage>)installedPackages2) : null) != null) return true;
        if (PyPsiPackageUtil.findPackage(installedPackages2, alternativePossiblePackages) == null) return false;
        return true;
    }

    @NotNull
    public final List<VirtualFile> findRootsForSdk(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        LanguageLevel languageLevel = PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk2);
        Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"getLanguageLevelForSdk(...)");
        LanguageLevel level = languageLevel;
        return this.findRootsForLanguageLevel(level);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VirtualFile> findRootsForLanguageLevel(@NotNull LanguageLevel level) {
        List list;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        VirtualFile virtualFile = this.getDirectory();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile dir = virtualFile;
        Object[] objectArray = new VirtualFile[]{dir.findChild("stdlib")};
        Sequence sequence = SequencesKt.sequenceOf((Object[])objectArray);
        VirtualFile[] virtualFileArray = dir.findFileByRelativePath("stubs");
        if (virtualFileArray == null || (virtualFileArray = virtualFileArray.getChildren()) == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        }
        objectArray = virtualFileArray;
        Intrinsics.checkNotNull((Object)objectArray);
        List common2 = SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.plus((Sequence)sequence, (Object[])objectArray)));
        if (level.isPython2()) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = common2;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                Object[] objectArray2 = new VirtualFile[]{it.findChild("@python2"), it};
                Iterable list$iv$iv = CollectionsKt.listOfNotNull((Object[])objectArray2);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = common2;
        }
        return list;
    }

    public final boolean isInside(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile dir = this.getDirectory();
        return dir != null && VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)file, (boolean)true);
    }

    @Nullable
    public final VirtualFile getDirectory() {
        Lazy lazy = directory$delegate;
        return (VirtualFile)lazy.getValue();
    }

    private final String getDirectoryPath() {
        Object[] objectArray = new String[]{PathManager.getConfigPath() + "/typeshed", PathManager.getConfigPath() + "/../typeshed", PythonHelpersLocator.Companion.findPathStringInHelpers("typeshed")};
        List paths = CollectionsKt.listOf((Object[])objectArray);
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)paths), (Function1)directoryPath.1.INSTANCE));
    }

    public final boolean isInThirdPartyLibraries(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"stubs", (boolean)false, (int)2, null);
    }

    public final boolean isInStandardLibrary(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"stdlib", (boolean)false, (int)2, null);
    }

    public static final /* synthetic */ String access$getDirectoryPath(PyTypeShed $this) {
        return $this.getDirectoryPath();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"_bootlocale", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON36, (Object)LanguageLevel.PYTHON39)), TuplesKt.to((Object)"_dummy_thread", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON36, (Object)LanguageLevel.PYTHON38)), TuplesKt.to((Object)"_dummy_threading", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON27, (Object)LanguageLevel.PYTHON38)), TuplesKt.to((Object)"_py_abc", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON37, null)), TuplesKt.to((Object)"asynchat", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON27, (Object)LanguageLevel.PYTHON311)), TuplesKt.to((Object)"asyncio.exceptions", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON38, null)), TuplesKt.to((Object)"asyncio.format_helpers", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON37, null)), TuplesKt.to((Object)"asyncio.mixins", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON310, null)), TuplesKt.to((Object)"asyncio.runners", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON37, null)), TuplesKt.to((Object)"asyncio.staggered", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON38, null)), TuplesKt.to((Object)"asyncio.taskgroups", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON311, null)), TuplesKt.to((Object)"asyncio.threads", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON39, null)), TuplesKt.to((Object)"asyncio.timeouts", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON311, null)), TuplesKt.to((Object)"asyncio.trsock", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON38, null)), TuplesKt.to((Object)"asyncore", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON27, (Object)LanguageLevel.PYTHON311)), TuplesKt.to((Object)"binhex", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON27, (Object)LanguageLevel.PYTHON310)), TuplesKt.to((Object)"contextvars", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON37, null)), TuplesKt.to((Object)"dataclasses", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON37, null)), TuplesKt.to((Object)"distutils", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON27, (Object)LanguageLevel.PYTHON311)), TuplesKt.to((Object)"distutils.command.bdist_msi", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON27, (Object)LanguageLevel.PYTHON310)), TuplesKt.to((Object)"distutils.command.bdist_wininst", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON27, (Object)LanguageLevel.PYTHON39)), TuplesKt.to((Object)"dummy_threading", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON27, (Object)LanguageLevel.PYTHON38)), TuplesKt.to((Object)"formatter", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON27, (Object)LanguageLevel.PYTHON39)), TuplesKt.to((Object)"graphlib", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON39, null)), TuplesKt.to((Object)"imp", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON27, (Object)LanguageLevel.PYTHON311)), TuplesKt.to((Object)"importlib.metadata", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON38, null)), TuplesKt.to((Object)"importlib.metadata._meta", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON310, null)), TuplesKt.to((Object)"importlib.resources", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON37, null)), TuplesKt.to((Object)"importlib.resources.abc", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON311, null)), TuplesKt.to((Object)"macpath", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON27, (Object)LanguageLevel.PYTHON37)), TuplesKt.to((Object)"multiprocessing.resource_tracker", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON38, null)), TuplesKt.to((Object)"multiprocessing.shared_memory", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON38, null)), TuplesKt.to((Object)"parser", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON27, (Object)LanguageLevel.PYTHON39)), TuplesKt.to((Object)"smtpd", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON27, (Object)LanguageLevel.PYTHON311)), TuplesKt.to((Object)"symbol", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON27, (Object)LanguageLevel.PYTHON39)), TuplesKt.to((Object)"sys._monitoring", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON312, null)), TuplesKt.to((Object)"tomllib", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON311, null)), TuplesKt.to((Object)"unittest._log", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON39, null)), TuplesKt.to((Object)"unittest.async_case", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON38, null)), TuplesKt.to((Object)"wsgiref.types", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON311, null)), TuplesKt.to((Object)"zoneinfo", (Object)TuplesKt.to((Object)LanguageLevel.PYTHON39, null))};
        stdlibNamesAvailableOnlyInSubsetOfSupportedLanguageLevels = MapsKt.mapOf((Pair[])pairArray);
        directory$delegate = LazyKt.lazy((Function0)directory.2.INSTANCE);
    }
}

