/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.ast.PyAstDocStringOwner;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringParser;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.documentation.doctest.PyDocstringFile;
import com.jetbrains.python.inspections.quickfix.DocstringQuickFix;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyGenerateDocstringIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.NAME.insert.docstring.stub", new Object[0]);
        if (string == null) {
            PyGenerateDocstringIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor2, PsiFile file) {
        if (project2 == null) {
            PyGenerateDocstringIntention.$$$reportNull$$$0(1);
        }
        if (!(file instanceof PyFile) || file instanceof PyDocstringFile) {
            return false;
        }
        PsiElement elementAt = PyUtil.findNonWhitespaceAtOffset(file, editor2.getCaretModel().getOffset());
        if (elementAt == null) {
            return false;
        }
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyFunction.class);
        PyStatementList statementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)elementAt, PyStatementList.class, (boolean)false, (Class[])new Class[]{PyFunction.class});
        if (function == null || statementList != null) {
            return false;
        }
        if (!elementAt.equals(function.getNameNode())) {
            return false;
        }
        return this.isAvailableForFunction(function);
    }

    private boolean isAvailableForFunction(PyFunction function) {
        if (function.getDocStringValue() != null) {
            if (PyDocstringGenerator.forDocStringOwner((PyAstDocStringOwner)function).withInferredParameters(false).hasParametersToAdd()) {
                this.setText(PyPsiBundle.message("INTN.add.parameters.to.docstring", new Object[0]));
                return true;
            }
            return false;
        }
        this.setText(PyPsiBundle.message("INTN.insert.docstring.stub", new Object[0]));
        return true;
    }

    @Override
    public void doInvoke(@NotNull Project project2, Editor editor2, PsiFile file) throws IncorrectOperationException {
        PsiElement elementAt;
        PyFunction function;
        if (project2 == null) {
            PyGenerateDocstringIntention.$$$reportNull$$$0(2);
        }
        if ((function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)(elementAt = PyUtil.findNonWhitespaceAtOffset(file, editor2.getCaretModel().getOffset())), PyFunction.class)) == null) {
            return;
        }
        PyGenerateDocstringIntention.generateDocstring(function, editor2);
    }

    public static void generateDocstring(@NotNull PyDocStringOwner docStringOwner, @Nullable Editor editor2) {
        if (docStringOwner == null) {
            PyGenerateDocstringIntention.$$$reportNull$$$0(3);
        }
        if (!PyGenerateDocstringIntention.ensureNotPlainDocstringFormat((PsiElement)docStringOwner)) {
            return;
        }
        DocstringQuickFix.doGenerateDocstring(docStringOwner, editor2);
    }

    public static boolean ensureNotPlainDocstringFormat(@NotNull PsiElement anchor) {
        Module module;
        if (anchor == null) {
            PyGenerateDocstringIntention.$$$reportNull$$$0(4);
        }
        if ((module = DocStringParser.getModuleForElement((PsiElement)anchor)) == null) {
            return false;
        }
        return PyGenerateDocstringIntention.ensureNotPlainDocstringFormatForFile(anchor.getContainingFile(), module);
    }

    private static boolean ensureNotPlainDocstringFormatForFile(@NotNull PsiFile file, @NotNull Module module) {
        PyDocumentationSettings settings;
        if (file == null) {
            PyGenerateDocstringIntention.$$$reportNull$$$0(5);
        }
        if (module == null) {
            PyGenerateDocstringIntention.$$$reportNull$$$0(6);
        }
        if ((settings = PyDocumentationSettings.getInstance((Module)module)).isPlain(file)) {
            List values = DocStringFormat.ALL_NAMES_BUT_PLAIN;
            int i = PythonUiService.getInstance().showChooseDialog(null, null, PyPsiBundle.message("python.docstring.format", new Object[0]), PyPsiBundle.message("python.docstring.select.type", new Object[0]), ArrayUtilRt.toStringArray((Collection)values), (String)values.get(0), null);
            if (i < 0) {
                return false;
            }
            SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.SETTINGS);
            settings.setFormat(DocStringFormat.fromNameOrPlain((String)((String)values.get(i))));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyGenerateDocstringIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docStringOwner";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyGenerateDocstringIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "generateDocstring";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "ensureNotPlainDocstringFormat";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "ensureNotPlainDocstringFormatForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

