/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFoldingSettings;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFileElementType;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralCoreUtil;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    public static final TokenSet FOLDABLE_COLLECTIONS_LITERALS = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.SET_LITERAL_EXPRESSION, PyElementTypes.DICT_LITERAL_EXPRESSION, PyElementTypes.GENERATOR_EXPRESSION, PyElementTypes.SET_COMP_EXPRESSION, PyElementTypes.DICT_COMP_EXPRESSION, PyElementTypes.LIST_LITERAL_EXPRESSION, PyElementTypes.LIST_COMP_EXPRESSION, PyElementTypes.TUPLE_EXPRESSION});
    public static final String PYTHON_TYPE_ANNOTATION_GROUP_NAME = "Python type annotation";

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            PythonFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root == null) {
            PythonFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            PythonFoldingBuilder.$$$reportNull$$$0(2);
        }
        PythonFoldingBuilder.appendDescriptors(root.getNode(), descriptors);
    }

    private static void appendDescriptors(ASTNode node, List<FoldingDescriptor> descriptors) {
        PyAnnotation pyAnnotation;
        PsiElement annotation;
        IElementType elementType = node.getElementType();
        if (node.getPsi() instanceof PyFile) {
            List<PyImportStatementBase> imports = ((PyFile)node.getPsi()).getImportBlock();
            if (imports.size() > 1) {
                PyImportStatementBase firstImport = imports.get(0);
                PyImportStatementBase lastImport = imports.get(imports.size() - 1);
                descriptors.add(new FoldingDescriptor((PsiElement)firstImport, new TextRange(firstImport.getTextRange().getStartOffset(), lastImport.getTextRange().getEndOffset())));
            }
        } else if (elementType == PyElementTypes.STATEMENT_LIST) {
            PythonFoldingBuilder.foldStatementList(node, descriptors);
        } else if (elementType == PyElementTypes.STRING_LITERAL_EXPRESSION) {
            PythonFoldingBuilder.foldLongStrings(node, descriptors);
        } else if (FOLDABLE_COLLECTIONS_LITERALS.contains(elementType)) {
            PythonFoldingBuilder.foldCollectionLiteral(node, descriptors);
        } else if (elementType == PyTokenTypes.END_OF_LINE_COMMENT) {
            PythonFoldingBuilder.foldSequentialComments(node, descriptors);
        } else if (elementType == PyElementTypes.ANNOTATION && (annotation = node.getPsi()) instanceof PyAnnotation && (pyAnnotation = (PyAnnotation)annotation).getValue() != null) {
            descriptors.add(new FoldingDescriptor(node, pyAnnotation.getValue().getTextRange(), FoldingGroup.newGroup((String)PYTHON_TYPE_ANNOTATION_GROUP_NAME)));
        }
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            PythonFoldingBuilder.appendDescriptors(child, descriptors);
        }
    }

    private static void foldSequentialComments(ASTNode node, List<FoldingDescriptor> descriptors) {
        if (PythonFoldingBuilder.isCustomRegionElement((PsiElement)node.getPsi())) {
            return;
        }
        ASTNode curNode = node.getTreePrev();
        while (curNode != null) {
            if (curNode.getElementType() == PyTokenTypes.END_OF_LINE_COMMENT) {
                if (PythonFoldingBuilder.isCustomRegionElement((PsiElement)curNode.getPsi())) break;
                return;
            }
            curNode = curNode.getPsi() instanceof PsiWhiteSpace ? curNode.getTreePrev() : null;
        }
        curNode = node.getTreeNext();
        ASTNode lastCommentNode = node;
        while (curNode != null) {
            if (curNode.getElementType() == PyTokenTypes.END_OF_LINE_COMMENT) {
                if (PythonFoldingBuilder.isCustomRegionElement((PsiElement)curNode.getPsi())) break;
                lastCommentNode = curNode;
                curNode = curNode.getTreeNext();
                continue;
            }
            curNode = curNode.getPsi() instanceof PsiWhiteSpace ? curNode.getTreeNext() : null;
        }
        if (lastCommentNode != node) {
            descriptors.add(new FoldingDescriptor(node, TextRange.create((int)node.getStartOffset(), (int)lastCommentNode.getTextRange().getEndOffset())));
        }
    }

    private static void foldCollectionLiteral(ASTNode node, List<FoldingDescriptor> descriptors) {
        if (StringUtil.countNewLines((CharSequence)node.getChars()) > 0) {
            TextRange range = node.getTextRange();
            int delta = node.getElementType() == PyElementTypes.TUPLE_EXPRESSION ? 0 : 1;
            descriptors.add(new FoldingDescriptor(node, TextRange.create((int)(range.getStartOffset() + delta), (int)(range.getEndOffset() - delta))));
        }
    }

    private static void foldStatementList(ASTNode node, List<FoldingDescriptor> descriptors) {
        TextRange nodeRange = node.getTextRange();
        if (nodeRange.isEmpty()) {
            return;
        }
        IElementType elType = node.getTreeParent().getElementType();
        if (elType == PyElementTypes.FUNCTION_DECLARATION || elType == PyElementTypes.CLASS_DECLARATION || PythonFoldingBuilder.ifFoldBlocks(node, elType)) {
            ASTNode colon = node.getTreeParent().findChildByType((IElementType)PyTokenTypes.COLON);
            int nodeEnd = nodeRange.getEndOffset();
            if (colon != null && nodeEnd - (colon.getStartOffset() + 1) > 1) {
                int foldEnd;
                CharSequence chars = node.getChars();
                int nodeStart = nodeRange.getStartOffset();
                int foldStart = colon.getStartOffset() + 1;
                for (foldEnd = nodeEnd; foldEnd > Math.max(nodeStart, foldStart + 1) && Character.isWhitespace(chars.charAt(foldEnd - nodeStart - 1)); --foldEnd) {
                }
                descriptors.add(new FoldingDescriptor(node, new TextRange(foldStart, foldEnd)));
            } else if (nodeRange.getLength() > 1) {
                descriptors.add(new FoldingDescriptor(node, nodeRange));
            }
        }
    }

    private static boolean ifFoldBlocks(ASTNode statementList, IElementType parentType) {
        if (!PyElementTypes.PARTS.contains(parentType) && parentType != PyElementTypes.WITH_STATEMENT) {
            return false;
        }
        PsiElement element = statementList.getPsi();
        if (element instanceof PyStatementList) {
            return StringUtil.countNewLines((CharSequence)element.getText()) > 0;
        }
        return false;
    }

    private static void foldLongStrings(ASTNode node, List<FoldingDescriptor> descriptors) {
        boolean shouldFoldString;
        boolean shouldFoldDocString = PythonFoldingBuilder.getDocStringOwnerType(node) != null && StringUtil.countNewLines((CharSequence)node.getChars()) > 1;
        boolean bl = shouldFoldString = PythonFoldingBuilder.getDocStringOwnerType(node) == null && StringUtil.countNewLines((CharSequence)node.getChars()) > 0;
        if (shouldFoldDocString || shouldFoldString) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        }
    }

    @Nullable
    private static IElementType getDocStringOwnerType(ASTNode node) {
        ASTNode treeParent = node.getTreeParent();
        IElementType parentType = treeParent.getElementType();
        if (parentType == PyElementTypes.EXPRESSION_STATEMENT && treeParent.getTreeParent() != null) {
            ASTNode parent2 = treeParent.getTreeParent();
            if (parent2.getElementType() == PyElementTypes.STATEMENT_LIST && parent2.getTreeParent() != null && treeParent == parent2.getFirstChildNode()) {
                ASTNode parent3 = parent2.getTreeParent();
                if (parent3.getElementType() == PyElementTypes.FUNCTION_DECLARATION || parent3.getElementType() == PyElementTypes.CLASS_DECLARATION) {
                    return parent3.getElementType();
                }
            } else if (parent2.getElementType() instanceof PyFileElementType) {
                return parent2.getElementType();
            }
        }
        return null;
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            PythonFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (range == null) {
            PythonFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (PythonFoldingBuilder.isImport(node)) {
            return "import ...";
        }
        if (node.getElementType() == PyElementTypes.STRING_LITERAL_EXPRESSION) {
            PyStringLiteralExpression stringLiteralExpression = (PyStringLiteralExpression)node.getPsi();
            String prefix = stringLiteralExpression.getStringElements().get(0).getPrefix();
            if (stringLiteralExpression.isDocString()) {
                String stringValue = stringLiteralExpression.getStringValue().trim();
                String[] lines = LineTokenizer.tokenize((CharSequence)stringValue, (boolean)true);
                if (lines.length > 2 && lines[1].trim().length() == 0) {
                    return prefix + "\"\"\"" + lines[0].trim() + "...\"\"\"";
                }
                return prefix + "\"\"\"...\"\"\"";
            }
            return prefix + PythonFoldingBuilder.getLanguagePlaceholderForString(stringLiteralExpression);
        }
        return "...";
    }

    private static String getLanguagePlaceholderForString(PyStringLiteralExpression stringLiteralExpression) {
        String stringText = stringLiteralExpression.getText();
        Pair quotes = PyStringLiteralCoreUtil.getQuotes((String)stringText);
        if (quotes != null) {
            return (String)quotes.second + "..." + (String)quotes.second;
        }
        return "...";
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            PythonFoldingBuilder.$$$reportNull$$$0(5);
        }
        if (PythonFoldingBuilder.isImport(node)) {
            return CodeFoldingSettings.getInstance().COLLAPSE_IMPORTS;
        }
        IElementType elementType = node.getElementType();
        if (elementType == PyElementTypes.STRING_LITERAL_EXPRESSION) {
            if (PythonFoldingBuilder.getDocStringOwnerType(node) == PyElementTypes.FUNCTION_DECLARATION && CodeFoldingSettings.getInstance().COLLAPSE_METHODS) {
                return false;
            }
            if (PythonFoldingBuilder.getDocStringOwnerType(node) != null) {
                return CodeFoldingSettings.getInstance().COLLAPSE_DOC_COMMENTS;
            }
            return PythonFoldingSettings.getInstance().isCollapseLongStrings();
        }
        if (elementType == PyTokenTypes.END_OF_LINE_COMMENT) {
            return PythonFoldingSettings.getInstance().isCollapseSequentialComments();
        }
        if (elementType == PyElementTypes.ANNOTATION) {
            return PythonFoldingSettings.getInstance().isCollapseTypeAnnotations();
        }
        if (elementType == PyElementTypes.STATEMENT_LIST && node.getTreeParent().getElementType() == PyElementTypes.FUNCTION_DECLARATION) {
            return CodeFoldingSettings.getInstance().COLLAPSE_METHODS;
        }
        if (FOLDABLE_COLLECTIONS_LITERALS.contains(elementType)) {
            return PythonFoldingSettings.getInstance().isCollapseLongCollections();
        }
        return false;
    }

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            PythonFoldingBuilder.$$$reportNull$$$0(6);
        }
        return node.getElementType() == PyTokenTypes.END_OF_LINE_COMMENT;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        if (node == null) {
            PythonFoldingBuilder.$$$reportNull$$$0(7);
        }
        return node.getPsi() instanceof PyFile || node.getElementType() == PyElementTypes.STATEMENT_LIST;
    }

    private static boolean isImport(@NotNull ASTNode node) {
        if (node == null) {
            PythonFoldingBuilder.$$$reportNull$$$0(8);
        }
        return PyElementTypes.IMPORT_STATEMENTS.contains(node.getElementType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/PythonFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomFoldingCandidate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomFoldingRoot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

