/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.terminal;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.terminal.PyTerminalBundle;
import com.intellij.python.terminal.PyVirtualEnvTerminalSettings;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.run.PyVirtualEnvReaderKt;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.conda.CondaEnvSdkFlavor;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import javax.swing.JCheckBox;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JK\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0005H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/python/terminal/PyVirtualEnvTerminalCustomizer;", "Lorg/jetbrains/plugins/terminal/LocalTerminalCustomizer;", "()V", "customizeCommandAndEnvironment", "", "", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectory", "command", "envs", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;[Ljava/lang/String;Ljava/util/Map;)[Ljava/lang/String;", "generatePowerShellActivateScript", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdkHomePath", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCondaActivationCommand", "condaPath", "Ljava/nio/file/Path;", "getConfigurable", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "isPowerShell", "", "shellName", "isShellIntegrationAvailable", "shellPath", "intellij.python.terminal"})
@SourceDebugExtension(value={"SMAP\nPyVirtualEnvTerminalCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyVirtualEnvTerminalCustomizer.kt\ncom/intellij/python/terminal/PyVirtualEnvTerminalCustomizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,189:1\n1#2:190\n13#3:191\n*S KotlinDebug\n*F\n+ 1 PyVirtualEnvTerminalCustomizer.kt\ncom/intellij/python/terminal/PyVirtualEnvTerminalCustomizer\n*L\n44#1:191\n*E\n"})
public final class PyVirtualEnvTerminalCustomizer
extends LocalTerminalCustomizer {
    /*
     * Enabled aggressive block sorting
     */
    private final String generatePowerShellActivateScript(Sdk sdk2, VirtualFile sdkHomePath) {
        SdkAdditionalData sdkAdditionalData = sdk2.getSdkAdditionalData();
        PythonSdkAdditionalData pythonSdkAdditionalData = sdkAdditionalData instanceof PythonSdkAdditionalData ? (PythonSdkAdditionalData)sdkAdditionalData : null;
        if ((pythonSdkAdditionalData != null ? pythonSdkAdditionalData.getFlavor() : null) instanceof CondaEnvSdkFlavor) {
            String string;
            Path condaPath;
            String string2 = PyCondaPackageService.Companion.getCondaExecutable(sdk2.getHomePath());
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                Path path2 = Paths.get(it, new String[0]);
                v3 = path2;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            } else {
                v3 = condaPath = null;
            }
            if (condaPath != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.exists(condaPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Files.isExecutable(condaPath)) {
                    string = this.getCondaActivationCommand(condaPath, sdkHomePath);
                    return string;
                }
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(PyVirtualEnvTerminalCustomizer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Can't find " + condaPath + ", will not activate conda");
            Object[] objectArray = new Object[]{"conda"};
            string = PyTerminalBundle.message("powershell.conda.not.activated", objectArray);
            return string;
        }
        VirtualFile virtualFile = sdkHomePath.getParent().findChild("activate.ps1");
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualEnvProfile = virtualFile;
        if (!virtualEnvProfile.exists()) return null;
        String string = virtualEnvProfile.getPath();
        return string;
    }

    private final String getCondaActivationCommand(Path condaPath, VirtualFile sdkHomePath) {
        Object[] objectArray = new Object[]{condaPath};
        String string = PyTerminalBundle.message("powershell.conda.not.activated", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String errorMessage = StringsKt.replace$default((String)string, (char)'\'', (char)'\"', (boolean)false, (int)4, null);
        return StringsKt.trimIndent((String)("\n        & '" + StringUtil.escapeChar((String)((Object)condaPath).toString(), (char)'\'') + "' shell.powershell hook | Out-String | Invoke-Expression ; \n        try { \n          conda activate '" + StringUtil.escapeChar((String)sdkHomePath.getParent().getPath(), (char)'\'') + "' \n        } catch { \n          Write-Host('" + StringUtil.escapeChar((String)errorMessage, (char)'\'') + "') \n        }\n        "));
    }

    @NotNull
    public String[] customizeCommandAndEnvironment(@NotNull Project project2, @Nullable String workingDirectory, @NotNull String[] command, @NotNull Map<String, String> envs) {
        VirtualFile sdkHomePath;
        Sdk sdk2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Ref.ObjectRef sdkByDirectory = new Ref.ObjectRef();
        if (workingDirectory != null) {
            ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>((Ref.ObjectRef<Sdk>)sdkByDirectory, project2, workingDirectory){
                final /* synthetic */ Ref.ObjectRef<Sdk> $sdkByDirectory;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $workingDirectory;
                {
                    this.$sdkByDirectory = $sdkByDirectory;
                    this.$project = $project;
                    this.$workingDirectory = $workingDirectory;
                    super(0);
                }

                public final void invoke() {
                    this.$sdkByDirectory.element = PySdkUtil.findSdkForDirectory(this.$project, Paths.get(this.$workingDirectory, new String[0]), false);
                }
            }));
        }
        if ((sdk2 = (Sdk)sdkByDirectory.element) != null && (PythonSdkUtil.isVirtualEnv(sdk2) || PythonSdkUtil.isConda(sdk2)) && PyVirtualEnvTerminalSettings.Companion.getInstance(project2).getVirtualEnvActivate() && (sdkHomePath = sdk2.getHomeDirectory()) != null && !(command.length == 0)) {
            String shellPath = command[0];
            if (this.isShellIntegrationAvailable(shellPath)) {
                Path path2 = Paths.get(shellPath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                String shellName = PathsKt.getName((Path)path2);
                if (this.isPowerShell(shellName)) {
                    String string = this.generatePowerShellActivateScript(sdk2, sdkHomePath);
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        envs.put("JEDITERM_SOURCE", it);
                    }
                } else {
                    Pair<String, String> pair = PyVirtualEnvReaderKt.findActivateScript(sdkHomePath.getPath(), shellPath);
                    if (pair != null) {
                        Pair<String, String> activate = pair;
                        boolean bl = false;
                        envs.put("JEDITERM_SOURCE", (String)activate.getFirst());
                        String string = (String)activate.getSecond();
                        if (string == null) {
                            string = "";
                        }
                        envs.put("JEDITERM_SOURCE_ARGS", string);
                    }
                }
            } else {
                Map<String, String> map = PySdkUtil.activateVirtualEnv(sdk2);
                Intrinsics.checkNotNullExpressionValue(map, (String)"activateVirtualEnv(...)");
                Map<String, String> envVars = map;
                if (envVars.isEmpty()) {
                    Logger.getInstance(PyVirtualEnvTerminalCustomizer.class).warn("No vars found to activate in " + sdk2.getHomePath());
                }
                envs.putAll(envVars);
            }
        }
        return command;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isShellIntegrationAvailable(String shellPath) {
        if (!TerminalOptionsProvider.Companion.getInstance().getShellIntegration()) return false;
        String shellName = new File(shellPath).getName();
        if (Intrinsics.areEqual((Object)shellName, (Object)"bash")) return true;
        if (SystemInfo.isMac) {
            if (Intrinsics.areEqual((Object)shellName, (Object)"sh")) return true;
        }
        if (Intrinsics.areEqual((Object)shellName, (Object)"zsh")) return true;
        if (Intrinsics.areEqual((Object)shellName, (Object)"fish")) return true;
        Intrinsics.checkNotNull((Object)shellName);
        if (!this.isPowerShell(shellName)) return false;
        return true;
    }

    private final boolean isPowerShell(String shellName) {
        Object[] objectArray = new String[]{"powershell.exe", "pwsh.exe"};
        return ArraysKt.contains((Object[])objectArray, (Object)shellName);
    }

    @NotNull
    public UnnamedConfigurable getConfigurable(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return new UnnamedConfigurable(project2){
            @NotNull
            private final PyVirtualEnvTerminalSettings settings;
            @NotNull
            private JCheckBox myCheckbox;
            {
                this.settings = PyVirtualEnvTerminalSettings.Companion.getInstance($project);
                this.myCheckbox = new JCheckBox(PyTerminalBundle.message("activate.virtualenv.checkbox.text", new Object[0]));
            }

            @NotNull
            public final PyVirtualEnvTerminalSettings getSettings() {
                return this.settings;
            }

            @NotNull
            public final JCheckBox getMyCheckbox() {
                return this.myCheckbox;
            }

            public final void setMyCheckbox(@NotNull JCheckBox jCheckBox) {
                Intrinsics.checkNotNullParameter((Object)jCheckBox, (String)"<set-?>");
                this.myCheckbox = jCheckBox;
            }

            @NotNull
            public JCheckBox createComponent() {
                return this.myCheckbox;
            }

            public boolean isModified() {
                return this.myCheckbox.isSelected() != this.settings.getVirtualEnvActivate();
            }

            public void apply() {
                this.settings.setVirtualEnvActivate(this.myCheckbox.isSelected());
            }

            public void reset() {
                this.myCheckbox.setSelected(this.settings.getVirtualEnvActivate());
            }
        };
    }
}

