/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.reStructuredText.editor;

import com.google.common.io.Resources;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.python.reStructuredText.editor.RestPreviewPanel;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.intellij.ui.jcef.JCEFHtmlPanel;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public final class RestJcefHtmlPanel
extends JCEFHtmlPanel
implements RestPreviewPanel {
    private static final AtomicInteger ourCounter = new AtomicInteger(-1);
    @NotNull
    @NonNls
    private static final String ourClassUrl = RestJcefHtmlPanel.class.getResource(RestJcefHtmlPanel.class.getSimpleName() + ".class").toExternalForm();
    private static final EnumMap<Style, String> ourLoadedStylesCache = new EnumMap(Style.class);
    private final JBCefJSQuery myJSQueryOpenInBrowser;
    @Nullable
    private static final String ourJSCodeToInject;
    private final CefLoadHandler myCefLoadHandler;
    @NotNull
    private final Project myProject;
    @Nullable
    @NonNls
    private String myLastHtml;

    public RestJcefHtmlPanel(@NotNull Project project2) {
        if (project2 == null) {
            RestJcefHtmlPanel.$$$reportNull$$$0(0);
        }
        super(RestJcefHtmlPanel.generateUniqueUrl());
        this.myJSQueryOpenInBrowser = JBCefJSQuery.create((JBCefBrowserBase)this);
        this.myProject = project2;
        this.myCefLoadHandler = new CefLoadHandlerAdapter(){

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                if (ourJSCodeToInject != null) {
                    browser.executeJavaScript(ourJSCodeToInject, RestJcefHtmlPanel.this.getCefBrowser().getURL(), 0);
                    browser.executeJavaScript("window.__IntelliJTools.openInBrowserCallback = link => {" + RestJcefHtmlPanel.this.myJSQueryOpenInBrowser.inject("link") + "}", RestJcefHtmlPanel.this.getCefBrowser().getURL(), 0);
                }
            }
        };
        this.getJBCefClient().addLoadHandler(this.myCefLoadHandler, this.getCefBrowser());
        this.myJSQueryOpenInBrowser.addHandler(link -> {
            if (!link.isEmpty()) {
                BrowserUtil.browse((String)link);
            }
            return null;
        });
        Disposer.register((Disposable)this, (Disposable)this.myJSQueryOpenInBrowser);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(LafManagerListener.TOPIC, source -> this.render());
    }

    @NotNull
    protected String prepareHtml(@NotNull String html) {
        if (html == null) {
            RestJcefHtmlPanel.$$$reportNull$$$0(1);
        }
        String string = html.replace("<head>", "<head>" + RestJcefHtmlPanel.getCssStyleCodeToInject());
        if (string == null) {
            RestJcefHtmlPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void setHtml(@NotNull String html) {
        String basePath;
        if (html == null) {
            RestJcefHtmlPanel.$$$reportNull$$$0(3);
        }
        if ((basePath = this.myProject.getBasePath()) != null) {
            html = RestJcefHtmlPanel.makeImageUrlsAbsolute(html, this.myProject.getBasePath());
        }
        this.myLastHtml = html;
        super.setHtml(html);
    }

    @Override
    public void render() {
        if (this.myLastHtml != null) {
            this.setHtml(this.myLastHtml);
        }
    }

    public void dispose() {
        super.dispose();
        this.getJBCefClient().removeLoadHandler(this.myCefLoadHandler, this.getCefBrowser());
    }

    @NotNull
    private static String generateUniqueUrl() {
        String string = ourClassUrl + "@" + ourCounter.incrementAndGet();
        if (string == null) {
            RestJcefHtmlPanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String getCssStyleCodeToInject() {
        boolean isDarcula = UIUtil.isUnderDarcula();
        Style style = isDarcula ? Style.DARCULA : Style.DEFAULT;
        Object cssCodeToInject = ourLoadedStylesCache.getOrDefault((Object)style, null);
        if (cssCodeToInject != null) {
            String string = cssCodeToInject;
            if (string == null) {
                RestJcefHtmlPanel.$$$reportNull$$$0(5);
            }
            return string;
        }
        try {
            cssCodeToInject = Resources.toString((URL)RestJcefHtmlPanel.class.getResource(style.getCss()), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load " + style.getCss() + ".", e);
        }
        cssCodeToInject = "<style>" + (String)cssCodeToInject + "</style>";
        ourLoadedStylesCache.put(style, (String)cssCodeToInject);
        Object object = cssCodeToInject;
        if (object == null) {
            RestJcefHtmlPanel.$$$reportNull$$$0(6);
        }
        return object;
    }

    @NotNull
    private static String makeImageUrlsAbsolute(@NotNull String html, @NotNull String basePath) {
        if (html == null) {
            RestJcefHtmlPanel.$$$reportNull$$$0(7);
        }
        if (basePath == null) {
            RestJcefHtmlPanel.$$$reportNull$$$0(8);
        }
        Document document = Jsoup.parse((String)html);
        Elements elements = document.getElementsByTag("img");
        for (Element element : elements) {
            Path originalPath;
            URI uri = null;
            try {
                uri = new URL(element.attr("src")).toURI();
                if (!uri.getScheme().equals("file")) {
                    continue;
                }
            }
            catch (MalformedURLException | URISyntaxException exception) {
                // empty catch block
            }
            if ((originalPath = Paths.get(uri != null ? uri.getPath() : element.attr("src"), new String[0])).isAbsolute()) continue;
            element.attr("src", Paths.get(basePath, originalPath.toString()).toString());
        }
        String string = document.outerHtml();
        if (string == null) {
            RestJcefHtmlPanel.$$$reportNull$$$0(9);
        }
        return string;
    }

    static {
        try {
            ourJSCodeToInject = Resources.toString((URL)RestJcefHtmlPanel.class.getResource("/js/script.js"), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load script.js.", e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/reStructuredText/editor/RestJcefHtmlPanel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/reStructuredText/editor/RestJcefHtmlPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareHtml";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUniqueUrl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCssStyleCodeToInject";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "makeImageUrlsAbsolute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "prepareHtml";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setHtml";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "makeImageUrlsAbsolute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 9 -> new IllegalStateException(string);
        };
    }

    private static enum Style {
        DARCULA("darcula.css"),
        DEFAULT("default.css");

        @NotNull
        String myResource;

        private Style(String resource) {
            if (resource == null) {
                Style.$$$reportNull$$$0(0);
            }
            this.myResource = resource;
        }

        @NotNull
        String getCss() {
            String string = "/styles/" + this.myResource;
            if (string == null) {
                Style.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/python/reStructuredText/editor/RestJcefHtmlPanel$Style";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/python/reStructuredText/editor/RestJcefHtmlPanel$Style";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCss";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

