/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.huggingFace.api;

import com.intellij.python.community.impl.huggingFace.HuggingFaceEntityKind;
import com.intellij.python.community.impl.huggingFace.api.HuggingFaceModelSortKey;
import com.intellij.python.community.impl.huggingFace.api.HuggingFaceURLProvider;
import com.intellij.python.community.impl.huggingFace.service.PyHuggingFaceBundle;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\u00020\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\nH\u0002J\u0016\u0010\u000b\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004J\"\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0004J\u0016\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004J.\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00042\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u001f\u001a\u00020 2\b\b\u0002\u0010\u0013\u001a\u00020\u0014J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0004H\u0002J\u0016\u0010#\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/python/community/impl/huggingFace/api/HuggingFaceURLProvider;", "", "()V", "baseURL", "", "datasetsExpandParameters", "", "modelsExpandParameters", "createCommonParametersString", "commonParameters", "", "createExpandParametersString", "expandParameters", "fetchApiDataForModel", "Ljava/net/URL;", "modelId", "fetchApiDataUrl", "entityKind", "Lcom/intellij/python/community/impl/huggingFace/HuggingFaceEntityKind;", "limit", "", "sort", "getDatasetCardLink", "datasetId", "getEntityCardLink", "entityId", "getEntityMarkdownURL", "getModelCardLink", "getModelSearchQuery", "query", "tags", "sortKey", "Lcom/intellij/python/community/impl/huggingFace/api/HuggingFaceModelSortKey;", "getSpaceLink", "spaceId", "makeAbsoluteFileLink", "relativeFilePath", "intellij.python.community.impl.huggingFace"})
@ApiStatus.Internal
public final class HuggingFaceURLProvider {
    @NotNull
    public static final HuggingFaceURLProvider INSTANCE = new HuggingFaceURLProvider();
    @NotNull
    private static final String baseURL = PyHuggingFaceBundle.INSTANCE.message("python.hugging.face.base.url", new Object[0]);
    @NotNull
    private static final List<String> modelsExpandParameters;
    @NotNull
    private static final List<String> datasetsExpandParameters;

    private HuggingFaceURLProvider() {
    }

    @NotNull
    public final URL getEntityMarkdownURL(@NotNull String entityId, @NotNull HuggingFaceEntityKind entityKind) {
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)((Object)entityKind), (String)"entityKind");
        return switch (WhenMappings.$EnumSwitchMapping$0[entityKind.ordinal()]) {
            case 1 -> new URL(baseURL + "/" + entityId + "/raw/main/README.md");
            case 2 -> new URL(baseURL + "/datasets/" + entityId + "/raw/main/README.md");
            case 3 -> new URL(baseURL + "/spaces/" + entityId + "/raw/main/README.md");
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final URL getEntityCardLink(@NotNull String entityId, @NotNull HuggingFaceEntityKind entityKind) {
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)((Object)entityKind), (String)"entityKind");
        return switch (WhenMappings.$EnumSwitchMapping$0[entityKind.ordinal()]) {
            case 1 -> this.getModelCardLink(entityId);
            case 2 -> this.getDatasetCardLink(entityId);
            case 3 -> this.getSpaceLink(entityId);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final URL getModelCardLink(@NotNull String modelId) {
        Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
        return new URL(baseURL + "/" + modelId);
    }

    @NotNull
    public final URL getDatasetCardLink(@NotNull String datasetId) {
        Intrinsics.checkNotNullParameter((Object)datasetId, (String)"datasetId");
        return new URL(baseURL + "/datasets/" + datasetId);
    }

    private final URL getSpaceLink(String spaceId) {
        return new URL(baseURL + "/spaces/" + spaceId);
    }

    private final String createCommonParametersString(Map<String, String> commonParameters) {
        return CollectionsKt.joinToString$default((Iterable)commonParameters.entrySet(), (CharSequence)"&", null, null, (int)0, null, (Function1)createCommonParametersString.1.INSTANCE, (int)30, null);
    }

    private final String createExpandParametersString(List<String> expandParameters) {
        return CollectionsKt.joinToString$default((Iterable)expandParameters, (CharSequence)"&", null, null, (int)0, null, (Function1)createExpandParametersString.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public final URL getModelSearchQuery(@NotNull String query, @Nullable String tags, @NotNull HuggingFaceModelSortKey sortKey, int limit) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)((Object)sortKey), (String)"sortKey");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"search", (Object)query), TuplesKt.to((Object)"sort", (Object)sortKey.getValue()), TuplesKt.to((Object)"limit", (Object)String.valueOf(limit)), TuplesKt.to((Object)"direction", (Object)"-1")};
        Map commonParameters = MapsKt.mapOf((Pair[])pairArray);
        List<String> expandParameters = modelsExpandParameters;
        String encodedCommonParameters = this.createCommonParametersString(commonParameters);
        String encodedExpandParameters = this.createExpandParametersString(expandParameters);
        CharSequence charSequence = tags;
        String filterParameter = charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "" : "&filter=" + URLEncoder.encode(tags, StandardCharsets.UTF_8);
        String allParameters = encodedCommonParameters + "&" + encodedExpandParameters + filterParameter;
        return new URL(baseURL + "/api/models?" + allParameters);
    }

    public static /* synthetic */ URL getModelSearchQuery$default(HuggingFaceURLProvider huggingFaceURLProvider, String string, String string2, HuggingFaceModelSortKey huggingFaceModelSortKey, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            huggingFaceModelSortKey = HuggingFaceModelSortKey.LIKES;
        }
        if ((n2 & 8) != 0) {
            n = 25;
        }
        return huggingFaceURLProvider.getModelSearchQuery(string, string2, huggingFaceModelSortKey, n);
    }

    @NotNull
    public final URL fetchApiDataForModel(@NotNull String modelId) {
        Intrinsics.checkNotNullParameter((Object)modelId, (String)"modelId");
        return new URL(baseURL + "/api/models/" + modelId);
    }

    @NotNull
    public final URL fetchApiDataUrl(@NotNull HuggingFaceEntityKind entityKind, int limit, @NotNull String sort) {
        Intrinsics.checkNotNullParameter((Object)((Object)entityKind), (String)"entityKind");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"limit", (Object)String.valueOf(limit)), TuplesKt.to((Object)"sort", (Object)sort), TuplesKt.to((Object)"direction", (Object)"-1")};
        Map commonParameters = MapsKt.mapOf((Pair[])pairArray);
        List expandParameters = switch (WhenMappings.$EnumSwitchMapping$0[entityKind.ordinal()]) {
            case 1 -> modelsExpandParameters;
            case 2 -> datasetsExpandParameters;
            case 3 -> CollectionsKt.emptyList();
            default -> throw new NoWhenBranchMatchedException();
        };
        String encodedCommonParameters = this.createCommonParametersString(commonParameters);
        String encodedExpandParameters = this.createExpandParametersString(expandParameters);
        String allParameters = encodedCommonParameters + "&" + encodedExpandParameters;
        return new URL(baseURL + "/api/" + entityKind.getUrlFragment() + "?" + allParameters);
    }

    public static /* synthetic */ URL fetchApiDataUrl$default(HuggingFaceURLProvider huggingFaceURLProvider, HuggingFaceEntityKind huggingFaceEntityKind, int n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 500;
        }
        if ((n2 & 4) != 0) {
            string = "likes";
        }
        return huggingFaceURLProvider.fetchApiDataUrl(huggingFaceEntityKind, n, string);
    }

    @NotNull
    public final URL makeAbsoluteFileLink(@NotNull String entityId, @NotNull String relativeFilePath) {
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)relativeFilePath, (String)"relativeFilePath");
        return new URL(baseURL + "/" + entityId + "/blob/main/" + relativeFilePath);
    }

    static {
        Object[] objectArray = new String[]{"gated", "downloads", "likes", "lastModified", "pipeline_tag", "library_name"};
        modelsExpandParameters = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"gated", "downloads", "likes", "lastModified"};
        datasetsExpandParameters = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HuggingFaceEntityKind.values().length];
            try {
                nArray[HuggingFaceEntityKind.MODEL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HuggingFaceEntityKind.DATASET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HuggingFaceEntityKind.SPACE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

