/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.huggingFace.annotation;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.python.community.impl.huggingFace.HuggingFaceEntityKind;
import com.intellij.python.community.impl.huggingFace.api.HuggingFaceURLProvider;
import com.intellij.python.community.impl.huggingFace.cache.HuggingFaceModelsCache;
import com.intellij.python.community.impl.huggingFace.service.HuggingFaceCardsUsageCollector;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0007R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/python/community/impl/huggingFace/annotation/HuggingFaceIdentifierPsiElement;", "Lcom/intellij/psi/impl/FakePsiElement;", "parent", "Lcom/intellij/psi/PsiElement;", "entityName", "", "entityKind", "Lcom/intellij/python/community/impl/huggingFace/HuggingFaceEntityKind;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lcom/intellij/python/community/impl/huggingFace/HuggingFaceEntityKind;)V", "getEntityKind", "()Lcom/intellij/python/community/impl/huggingFace/HuggingFaceEntityKind;", "getEntityName", "()Ljava/lang/String;", "getParent", "navigate", "", "requestFocus", "", "stringValue", "Companion", "intellij.python.community.impl.huggingFace"})
@ApiStatus.Internal
public final class HuggingFaceIdentifierPsiElement
extends FakePsiElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiElement parent;
    @NotNull
    private final String entityName;
    @NotNull
    private final HuggingFaceEntityKind entityKind;
    @NotNull
    private static final Key<Boolean> HUGGING_FACE_ENTITY_NAME_KEY;

    public HuggingFaceIdentifierPsiElement(@NotNull PsiElement parent, @NotNull String entityName, @NotNull HuggingFaceEntityKind entityKind) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        Intrinsics.checkNotNullParameter((Object)((Object)entityKind), (String)"entityKind");
        this.parent = parent;
        this.entityName = entityName;
        this.entityKind = entityKind;
        this.parent.putUserData(HUGGING_FACE_ENTITY_NAME_KEY, (Object)true);
    }

    @NotNull
    public final String getEntityName() {
        return this.entityName;
    }

    @NotNull
    public final HuggingFaceEntityKind getEntityKind() {
        return this.entityKind;
    }

    @NotNull
    public PsiElement getParent() {
        return this.parent;
    }

    @NlsSafe
    @NotNull
    public final String stringValue() {
        return this.entityName;
    }

    public void navigate(boolean requestFocus) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.entityKind.ordinal()]) {
            case 1: {
                String string = HuggingFaceModelsCache.INSTANCE.getPipelineTagForEntity(this.entityName);
                if (string == null) {
                    string = "undefined";
                }
                String pipelineTag = string;
                HuggingFaceCardsUsageCollector.INSTANCE.getNAVIGATION_LINK_IN_EDITOR_CLICKED().log((Object)pipelineTag);
                BrowserUtil.browse((URL)HuggingFaceURLProvider.INSTANCE.getModelCardLink(this.entityName));
                break;
            }
            case 2: {
                HuggingFaceCardsUsageCollector.INSTANCE.getNAVIGATION_LINK_IN_EDITOR_CLICKED().log((Object)"dataset");
                BrowserUtil.browse((URL)HuggingFaceURLProvider.INSTANCE.getDatasetCardLink(this.entityName));
            }
        }
    }

    static {
        Key key = Key.create((String)"HUGGING_FACE_ENTITY_NAME_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        HUGGING_FACE_ENTITY_NAME_KEY = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/python/community/impl/huggingFace/annotation/HuggingFaceIdentifierPsiElement$Companion;", "", "()V", "HUGGING_FACE_ENTITY_NAME_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getHUGGING_FACE_ENTITY_NAME_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.python.community.impl.huggingFace"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getHUGGING_FACE_ENTITY_NAME_KEY() {
            return HUGGING_FACE_ENTITY_NAME_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HuggingFaceEntityKind.values().length];
            try {
                nArray[HuggingFaceEntityKind.MODEL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HuggingFaceEntityKind.DATASET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HuggingFaceEntityKind.SPACE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

