/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.dap.xdebugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.dap.CommandScope;
import com.intellij.platform.dap.DapCommandProcessor;
import com.intellij.platform.dap.DapEvaluationResult;
import com.intellij.platform.dap.DapScope;
import com.intellij.platform.dap.DapStackFrame;
import com.intellij.platform.dap.DapThread;
import com.intellij.platform.dap.DapThreadState;
import com.intellij.platform.dap.StackFrameType;
import com.intellij.platform.dap.TextPosition;
import com.intellij.platform.dap.xdebugger.DapXDebuggerPresentationFactory;
import com.intellij.platform.dap.xdebugger.DefaultDapXDebuggerEvaluator;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u000eH\u0016J\n\u0010+\u001a\u0004\u0018\u00010\u0014H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0013\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0012\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006,"}, d2={"Lcom/intellij/platform/dap/xdebugger/DefaultDapXStackFrame;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "factory", "Lcom/intellij/platform/dap/xdebugger/DapXDebuggerPresentationFactory;", "commandProcessor", "Lcom/intellij/platform/dap/DapCommandProcessor;", "thread", "Lcom/intellij/platform/dap/DapThread;", "frame", "Lcom/intellij/platform/dap/DapStackFrame;", "(Lcom/intellij/platform/dap/xdebugger/DapXDebuggerPresentationFactory;Lcom/intellij/platform/dap/DapCommandProcessor;Lcom/intellij/platform/dap/DapThread;Lcom/intellij/platform/dap/DapStackFrame;)V", "LABEL_ATTRIBUTES", "Lcom/intellij/ui/SimpleTextAttributes;", "_evaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "get_evaluator", "()Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "_evaluator$delegate", "Lkotlin/Lazy;", "_sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "Lorg/jetbrains/annotations/Nullable;", "get_sourcePosition", "()Lcom/intellij/xdebugger/XSourcePosition;", "_sourcePosition$delegate", "getCommandProcessor", "()Lcom/intellij/platform/dap/DapCommandProcessor;", "getFactory", "()Lcom/intellij/platform/dap/xdebugger/DapXDebuggerPresentationFactory;", "getFrame", "()Lcom/intellij/platform/dap/DapStackFrame;", "getThread", "()Lcom/intellij/platform/dap/DapThread;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "customizePresentation", "component", "Lcom/intellij/ui/ColoredTextContainer;", "getEqualityObject", "", "getEvaluator", "getSourcePosition", "intellij.platform.dap"})
@ApiStatus.Experimental
public final class DefaultDapXStackFrame
extends XStackFrame {
    @NotNull
    private final DapXDebuggerPresentationFactory factory;
    @NotNull
    private final DapCommandProcessor commandProcessor;
    @NotNull
    private final DapThread thread;
    @NotNull
    private final DapStackFrame frame;
    @NotNull
    private final Lazy _sourcePosition$delegate;
    @NotNull
    private final Lazy _evaluator$delegate;
    @NotNull
    private final SimpleTextAttributes LABEL_ATTRIBUTES;

    public DefaultDapXStackFrame(@NotNull DapXDebuggerPresentationFactory factory, @NotNull DapCommandProcessor commandProcessor, @NotNull DapThread thread2, @NotNull DapStackFrame frame) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)commandProcessor, (String)"commandProcessor");
        Intrinsics.checkNotNullParameter((Object)thread2, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        this.factory = factory;
        this.commandProcessor = commandProcessor;
        this.thread = thread2;
        this.frame = frame;
        this._sourcePosition$delegate = LazyKt.lazy((Function0)((Function0)new Function0<XSourcePosition>(this){
            final /* synthetic */ DefaultDapXStackFrame this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final XSourcePosition invoke() {
                XSourcePosition xSourcePosition;
                VirtualFile virtualFile = this.this$0.getFrame().getSource();
                if (virtualFile != null) {
                    VirtualFile virtualFile2 = virtualFile;
                    DefaultDapXStackFrame defaultDapXStackFrame = this.this$0;
                    VirtualFile it = virtualFile2;
                    boolean bl = false;
                    xSourcePosition = XDebuggerUtil.getInstance().createPosition(defaultDapXStackFrame.getFrame().getSource(), defaultDapXStackFrame.getFrame().getStartPosition().getLine() - 1);
                } else {
                    xSourcePosition = null;
                }
                return xSourcePosition;
            }
        }));
        this._evaluator$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DefaultDapXDebuggerEvaluator>(this){
            final /* synthetic */ DefaultDapXStackFrame this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final DefaultDapXDebuggerEvaluator invoke() {
                return new DefaultDapXDebuggerEvaluator(this.this$0.getCommandProcessor(), this.this$0.getFactory(), this.this$0.getFrame());
            }
        }));
        this.LABEL_ATTRIBUTES = new SimpleTextAttributes(17, NamedColorUtil.getInactiveTextColor());
    }

    @NotNull
    public final DapXDebuggerPresentationFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public final DapCommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    @NotNull
    public final DapThread getThread() {
        return this.thread;
    }

    @NotNull
    public final DapStackFrame getFrame() {
        return this.frame;
    }

    private final XSourcePosition get_sourcePosition() {
        Lazy lazy = this._sourcePosition$delegate;
        return (XSourcePosition)lazy.getValue();
    }

    private final XDebuggerEvaluator get_evaluator() {
        Lazy lazy = this._evaluator$delegate;
        return (XDebuggerEvaluator)lazy.getValue();
    }

    @NotNull
    public XDebuggerEvaluator getEvaluator() {
        return this.get_evaluator();
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DapThreadState threadState = this.thread.getState();
        if (!(threadState instanceof DapThreadState.Paused)) {
            node.setErrorMessage(XDebuggerBundle.message((String)"debugger.frames.dialog.message.not.available.for.unsuspended", (Object[])new Object[0]));
            return;
        }
        this.commandProcessor.submitCommand((Function2<? super CommandScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CommandScope, Continuation<? super Unit>, Object>(this, threadState, node, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DefaultDapXStackFrame this$0;
            final /* synthetic */ DapThreadState $threadState;
            final /* synthetic */ XCompositeNode $node;
            {
                this.this$0 = $receiver;
                this.$threadState = $threadState;
                this.$node = $node;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$submitCommand = (CommandScope)this.L$0;
                        $this$invokeSuspend_u24lambda_u240 = this.this$0.getFrame();
                        $i$a$-run-DefaultDapXStackFrame$computeChildren$1$scopes$1 = false;
                        this.L$0 = $this$submitCommand;
                        this.label = 1;
                        v0 = $this$invokeSuspend_u24lambda_u240.scopes($this$submitCommand, (Continuation<? super List<? extends DapScope>>)this);
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl20
                    }
                    case 1: {
                        $i$a$-run-DefaultDapXStackFrame$computeChildren$1$scopes$1 = false;
                        $this$submitCommand = (CommandScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl20:
                        // 2 sources

                        scopes = (List)v0;
                        childrenList = new XValueChildrenList();
                        v1 = ((DapThreadState.Paused)this.$threadState).getExceptionInfo();
                        v2 = v1 != null && (v1 = v1.getRawDetails()) != null ? v1.getEvaluateName() : (exceptionGetterExpression = null);
                        if (exceptionGetterExpression == null) ** GOTO lbl44
                        $this$invokeSuspend_u24lambda_u241 = this.this$0.getFrame();
                        $i$a$-run-DefaultDapXStackFrame$computeChildren$1$evaluationResult$1 = false;
                        this.L$0 = scopes;
                        this.L$1 = childrenList;
                        this.label = 2;
                        v3 = $this$invokeSuspend_u24lambda_u241.evaluate($this$submitCommand, exceptionGetterExpression, (Continuation<? super DapEvaluationResult>)this);
                        if (v3 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl41
                    }
                    case 2: {
                        $i$a$-run-DefaultDapXStackFrame$computeChildren$1$evaluationResult$1 = false;
                        childrenList = (XValueChildrenList)this.L$1;
                        scopes = (List)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl41:
                        // 2 sources

                        evaluationResult = (DapEvaluationResult)v3;
                        if (evaluationResult instanceof DapEvaluationResult.Success) {
                            this.$node.addChildren(XValueChildrenList.singleton((XNamedValue)this.this$0.getFactory().createValue(this.this$0.getCommandProcessor(), ((DapEvaluationResult.Success)evaluationResult).getVariable(), AllIcons.Nodes.ExceptionClass)), false);
                        }
lbl44:
                        // 4 sources

                        var6_7 = scopes.iterator();
                        var7_14 = 0;
                        while (var6_7.hasNext()) {
                            index = var7_14++;
                            scope = (DapScope)var6_7.next();
                            childrenList.addTopGroup(this.this$0.getFactory().createScope(this.this$0.getCommandProcessor(), scope, index));
                        }
                        this.$node.addChildren(childrenList, true);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CommandScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        TextPosition position = this.frame.getStartPosition();
        SimpleTextAttributes textAttributes = switch (WhenMappings.$EnumSwitchMapping$0[this.frame.getType().ordinal()]) {
            case 1 -> this.LABEL_ATTRIBUTES;
            case 2 -> SimpleTextAttributes.REGULAR_ATTRIBUTES;
            default -> throw new NoWhenBranchMatchedException();
        };
        component.append(this.frame.getName(), textAttributes);
        VirtualFile source = this.frame.getSource();
        if (source != null) {
            component.append(", " + source.getName(), textAttributes);
        }
        component.append(":" + position.getLine() + ":" + position.getColumn(), textAttributes);
        component.setIcon(AllIcons.Debugger.Frame);
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.get_sourcePosition();
    }

    @NotNull
    public Object getEqualityObject() {
        VirtualFile virtualFile = this.frame.getSource();
        return (virtualFile != null ? virtualFile.getPath() : null) + ":" + this.frame.getStartPosition().getLine() + ":" + this.frame.getStartPosition().getLine();
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StackFrameType.values().length];
            try {
                nArray[StackFrameType.Label.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StackFrameType.Normal.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

