/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler.custom;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.ShowCompilerInfoForFile;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSplitArgs;
import com.jetbrains.cidr.lang.workspace.compiler.custom.CidrCustomCompilerDefinition;
import com.jetbrains.cidr.lang.workspace.compiler.custom.CidrCustomCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.custom.CidrCustomCompilerService;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/custom/ShowCustomCompilerInfoForFile;", "Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile;", "()V", "appendAdditionalCompilerInfo", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "context", "Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$Context;", "intellij.cidr.compiler.custom"})
public final class ShowCustomCompilerInfoForFile
extends ShowCompilerInfoForFile {
    protected void appendAdditionalCompilerInfo(@NotNull StringBuilder builder, @NotNull ShowCompilerInfoForFile.Context context) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        OCCompilerSettings oCCompilerSettings = context.getConfiguration().getCompilerSettings(context.getKind(), context.getFile());
        Intrinsics.checkNotNullExpressionValue((Object)oCCompilerSettings, (String)"getCompilerSettings(...)");
        OCCompilerSettings compilerSettings = oCCompilerSettings;
        if (Intrinsics.areEqual((Object)compilerSettings.getCompilerKind(), (Object)CidrCustomCompilerKind.INSTANCE)) {
            File file = compilerSettings.getCompilerExecutable();
            if (file == null) {
                return;
            }
            File compilerExecutable = file;
            CidrCustomCompilerService service = (CidrCustomCompilerService)context.getProject().getService(CidrCustomCompilerService.class);
            CidrCompilerSwitches cidrCompilerSwitches = compilerSettings.getCompilerSwitches();
            if (cidrCompilerSwitches == null) {
                return;
            }
            CidrCompilerSwitches compilerSwitches = cidrCompilerSwitches;
            List list = compilerSwitches.getList(CidrCompilerSwitches.Format.RAW);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
            List list2 = list;
            CompilerSplitArgs splitArgs = CompilerSplitArgs.parse((List)list2, (boolean)SystemInfo.isWindows);
            try {
                CidrCustomCompilerDefinition definition = service.findDefinition(compilerExecutable.toPath(), context.getKind(), splitArgs);
                if (definition == null) {
                    builder.append("Custom Compiler definition is not found in the yaml file. Please verify your matching records\n");
                } else {
                    builder.append("Custom Compiler: " + definition.getDescription() + "\n");
                }
            }
            catch (Throwable e) {
                builder.append("Custom Compiler yaml file read error: " + e.getClass().getSimpleName() + " " + e.getLocalizedMessage() + "\n");
            }
        }
    }
}

