/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler.custom;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.PersistentStateComponentWithModificationTracker;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.workspace.compiler.custom.CidrCustomCompilerBundle;
import com.jetbrains.cidr.lang.workspace.compiler.custom.CidrCustomCompilerConfigurable;
import com.jetbrains.cidr.lang.workspace.compiler.custom.CidrCustomCompilerDefinition;
import com.jetbrains.cidr.lang.workspace.compiler.custom.CidrCustomCompilerServiceBase;
import com.jetbrains.cidr.lang.workspace.compiler.custom.CidrCustomCompilerState;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceManager;
import com.jetbrains.cidr.project.workspace.ReloadableWorkspace;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="com.jetbrains.cidr.lang.workspace.compiler.custom.CustomCompilerService", storages={@Storage(value="custom-compiler.xml")})
public final class CidrCustomCompilerService
extends CidrCustomCompilerServiceBase
implements PersistentStateComponentWithModificationTracker<CidrCustomCompilerState> {
    private final CidrCustomCompilerState myState;
    private final Project myProject;
    @NotNull
    private volatile WeakReference<CachedDefinitions> myCachedDefinitionsRef;
    private final Object cacheLock;

    public CidrCustomCompilerService(@NotNull Project project) {
        if (project == null) {
            CidrCustomCompilerService.$$$reportNull$$$0(0);
        }
        this.myState = new CidrCustomCompilerState();
        this.myCachedDefinitionsRef = new WeakReference<Object>(null);
        this.cacheLock = new Object();
        this.myProject = project;
    }

    public void setParameters(boolean enabled, @NotNull String customDefinitionsPath) {
        if (customDefinitionsPath == null) {
            CidrCustomCompilerService.$$$reportNull$$$0(1);
        }
        this.myState.setEnabled(enabled);
        customDefinitionsPath = FileUtilRt.toSystemIndependentName((String)customDefinitionsPath);
        if (!customDefinitionsPath.equals(this.myState.getDefinitionsFile())) {
            this.myCachedDefinitionsRef = new WeakReference<Object>(null);
            this.myState.setDefinitionsFile(customDefinitionsPath);
            Notification notification = new Notification("System Messages", CidrCustomCompilerService.notificationTitle(), CidrCustomCompilerBundle.message("notification.content.yaml.file.changed.please.reload.project", new Object[0]), NotificationType.INFORMATION);
            notification.addAction((AnAction)DumbAwareAction.create((String)CidrCustomCompilerBundle.message("action.reload.text", new Object[0]), e -> {
                CidrWorkspaceManager workspaceManager;
                if (this.myProject.isInitialized() && (workspaceManager = CidrWorkspaceManager.getInstanceOrNull((Project)this.myProject)) != null) {
                    workspaceManager.getInitializedWorkspaces().forEach(workspace -> {
                        if (workspace instanceof ReloadableWorkspace) {
                            ((ReloadableWorkspace)workspace).scheduleReload();
                        }
                    });
                }
            }));
            Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    protected List<CidrCustomCompilerDefinition> loadDefinitions() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private List<CidrCustomCompilerDefinition> getCachedDefinitions() {
        VirtualFile file = this.getDefinitionsFile();
        CachedDefinitions cachedDefinitions = (CachedDefinitions)this.myCachedDefinitionsRef.get();
        if (CachedDefinitions.isValid(cachedDefinitions, file)) {
            LOGGER.debug("Cache hit for Custom Defined Compiler file {0}", new Object[]{file.getPath()});
            return cachedDefinitions.definitions;
        }
        return null;
    }

    @NotNull
    private VirtualFile getDefinitionsFile() {
        VirtualFile file = VfsUtil.findFile((Path)Paths.get(this.getCustomDefinitionPath(), new String[0]), (boolean)false);
        if (file == null) {
            throw new ExternalSystemException(CidrCustomCompilerBundle.message("custom.compiler.file.not.found", this.getCustomDefinitionPath()));
        }
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            CidrCustomCompilerService.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @NotNull
    @NlsSafe
    public String getCustomDefinitionPath() {
        String string;
        try {
            String path = PathUtil.toSystemDependentName((String)Strings.notNullize((String)this.myState.getDefinitionsFile()));
            VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)this.myProject);
            string = projectDir != null ? Paths.get(projectDir.getPath(), new String[0]).resolve(path).normalize().toString() : path;
        }
        catch (Throwable e) {
            Logger.getInstance(CidrCustomCompilerService.class).warn(e);
            return "";
        }
        if (string == null) {
            CidrCustomCompilerService.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isEnabled() {
        return this.myState.isEnabled();
    }

    public boolean applicable(String path) {
        Notification notification;
        try {
            return this.isEnabled() && ContainerUtil.exists(this.loadDefinitions(), definition -> definition.matchesExe(path));
        }
        catch (LocationAwareExternalSystemException exception) {
            notification = this.createNotification(exception);
            VirtualFile file = VfsUtil.findFile((Path)Path.of(exception.getFilePath(), new String[0]), (boolean)false);
            if (file != null) {
                notification.addAction((AnAction)DumbAwareAction.create((String)CidrCustomCompilerBundle.message("action.open.definitions.file.text", new Object[0]), e -> new OpenFileDescriptor(this.myProject, file, exception.getLine().intValue(), exception.getColumn().intValue()).navigate(true)));
            }
        }
        catch (Throwable throwable) {
            notification = this.createNotification(throwable);
        }
        Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
        return false;
    }

    @NotNull
    private Notification createNotification(Throwable throwable) {
        String message = throwable.getLocalizedMessage();
        if (message == null) {
            message = throwable.getMessage();
        }
        if (message == null) {
            message = throwable.getClass().getName();
        }
        Notification notification = new Notification("System Messages", CidrCustomCompilerService.notificationTitle(), message, NotificationType.ERROR);
        notification.addAction((AnAction)DumbAwareAction.create((String)CidrCustomCompilerBundle.message("action.check.settings.text", new Object[0]), e -> ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, CidrCustomCompilerConfigurable.class)));
        Notification notification2 = notification;
        if (notification2 == null) {
            CidrCustomCompilerService.$$$reportNull$$$0(7);
        }
        return notification2;
    }

    @NotNull
    @Nls
    private static String notificationTitle() {
        String string = CidrCustomCompilerBundle.message("notification.title.custom.compiler.error", new Object[0]);
        if (string == null) {
            CidrCustomCompilerService.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public CidrCustomCompilerState getState() {
        CidrCustomCompilerState cidrCustomCompilerState = this.myState;
        if (cidrCustomCompilerState == null) {
            CidrCustomCompilerService.$$$reportNull$$$0(9);
        }
        return cidrCustomCompilerState;
    }

    public void loadState(@NotNull CidrCustomCompilerState state) {
        if (state == null) {
            CidrCustomCompilerService.$$$reportNull$$$0(10);
        }
        this.myState.setDefinitionsFile(state.getDefinitionsFile());
        this.myState.setEnabled(state.isEnabled());
    }

    public long getStateModificationCount() {
        return this.myState.getModificationCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customDefinitionsPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/custom/CidrCustomCompilerService";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/custom/CidrCustomCompilerService";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefinitions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefinitionsFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomDefinitionPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "notificationTitle";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setParameters";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class CachedDefinitions {
        final List<CidrCustomCompilerDefinition> definitions;
        final String fileLocation;
        final long timestamp;

        private CachedDefinitions(VirtualFile file, List<CidrCustomCompilerDefinition> definitions) {
            this.definitions = definitions;
            this.fileLocation = file.getPath();
            this.timestamp = file.getModificationStamp();
        }

        private static boolean isValid(@Nullable CachedDefinitions definitions, VirtualFile file) {
            return definitions != null && Objects.equals(definitions.fileLocation, file.getPath()) && definitions.timestamp == file.getModificationStamp();
        }
    }
}

