/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler.custom;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldWithBrowseButtonKt;
import com.intellij.ui.layout.ValidationInfoBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.custom.CidrCustomCompilerBundle;
import com.jetbrains.cidr.lang.workspace.compiler.custom.CidrCustomCompilerConfigurable;
import com.jetbrains.cidr.lang.workspace.compiler.custom.CidrCustomCompilerService;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\b\u0010\u001a\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/lang/workspace/compiler/custom/CidrCustomCompilerConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "descriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "myCompilerService", "Lcom/jetbrains/cidr/lang/workspace/compiler/custom/CidrCustomCompilerService;", "myEnabled", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "", "myPath", "", "propertyGraph", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "dispose", "disposeUIResources", "getDisplayName", "getHelpTopic", "getId", "isModified", "reset", "intellij.cidr.compiler.custom"})
public final class CidrCustomCompilerConfigurable
implements SearchableConfigurable,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final FileChooserDescriptor descriptor;
    @NotNull
    private final CidrCustomCompilerService myCompilerService;
    @NotNull
    private final PropertyGraph propertyGraph;
    @NotNull
    private GraphProperty<Boolean> myEnabled;
    @NotNull
    private GraphProperty<String> myPath;

    public CidrCustomCompilerConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((String)"yaml");
        Intrinsics.checkNotNull((Object)fileChooserDescriptor);
        this.descriptor = fileChooserDescriptor;
        Object object = this.project.getService(CidrCustomCompilerService.class);
        Intrinsics.checkNotNull((Object)object);
        this.myCompilerService = (CidrCustomCompilerService)object;
        this.propertyGraph = new PropertyGraph(null, false, 3, null);
        this.myEnabled = this.propertyGraph.property((Object)false);
        this.myPath = this.propertyGraph.property((Object)"");
    }

    @NotNull
    public String getHelpTopic() {
        return "settings.compiler.custom";
    }

    @NotNull
    public JComponent createComponent() {
        return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ CidrCustomCompilerConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Ref.ObjectRef enabledCheckBox = new Ref.ObjectRef();
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>((Ref.ObjectRef<Cell<JBCheckBox>>)enabledCheckBox, this.this$0){
                    final /* synthetic */ Ref.ObjectRef<Cell<JBCheckBox>> $enabledCheckBox;
                    final /* synthetic */ CidrCustomCompilerConfigurable this$0;
                    {
                        this.$enabledCheckBox = $enabledCheckBox;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        String string = CidrCustomCompilerBundle.message("custom.compiler.use.definition.checkbox", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.$enabledCheckBox.element = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (ObservableMutableProperty)((ObservableMutableProperty)CidrCustomCompilerConfigurable.access$getMyEnabled$p(this.this$0)));
                    }
                }), (int)1, null);
                $this$panel.indent((Function1)new Function1<Panel, Unit>(this.this$0, (Ref.ObjectRef<Cell<JBCheckBox>>)enabledCheckBox){
                    final /* synthetic */ CidrCustomCompilerConfigurable this$0;
                    final /* synthetic */ Ref.ObjectRef<Cell<JBCheckBox>> $enabledCheckBox;
                    {
                        this.this$0 = $receiver;
                        this.$enabledCheckBox = $enabledCheckBox;
                        super(1);
                    }

                    public final void invoke(@NotNull Panel $this$indent) {
                        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
                        Panel.row$default((Panel)$this$indent, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0, this.$enabledCheckBox){
                            final /* synthetic */ CidrCustomCompilerConfigurable this$0;
                            final /* synthetic */ Ref.ObjectRef<Cell<JBCheckBox>> $enabledCheckBox;
                            {
                                this.this$0 = $receiver;
                                this.$enabledCheckBox = $enabledCheckBox;
                                super(1);
                            }

                            public final void invoke(@NotNull Row $this$row) {
                                Cell cell;
                                Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                                Project project = CidrCustomCompilerConfigurable.access$getProject$p(this.this$0);
                                Object object = CidrCustomCompilerConfigurable.access$getDescriptor$p(this.this$0);
                                String string = CidrCustomCompilerBundle.message("custom.compiler.dialog.title.definition.path.yaml", new Object[0]);
                                Cell cell2 = TextFieldWithBrowseButtonKt.bindText((Cell)Row.textFieldWithBrowseButton$default((Row)$this$row, (String)string, (Project)project, (FileChooserDescriptor)object, null, (int)8, null).align((Align)AlignX.FILL.INSTANCE), (ObservableMutableProperty)((ObservableMutableProperty)CidrCustomCompilerConfigurable.access$getMyPath$p(this.this$0)));
                                if (this.$enabledCheckBox.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"enabledCheckBox");
                                    cell = null;
                                } else {
                                    cell = (Cell)this.$enabledCheckBox.element;
                                }
                                project = cell2.enabledIf(ButtonKt.getSelected((Cell)cell));
                                object = this.this$0;
                                Project $this$invoke_u24lambda_u241 = project;
                                boolean bl = false;
                                JTextField jTextField = ((TextFieldWithBrowseButton)$this$invoke_u24lambda_u241.getComponent()).getTextField();
                                Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextField(...)");
                                JTextField textField = jTextField;
                                new ComponentValidator((Disposable)object).andRegisterOnDocumentListener((JTextComponent)textField).withValidator(() -> createComponent.1.invoke$lambda$1$lambda$0(textField)).installOn((JComponent)textField);
                            }

                            private static final ValidationInfo invoke$lambda$1$lambda$0(JTextField $textField) {
                                ValidationInfo validationInfo;
                                Intrinsics.checkNotNullParameter((Object)$textField, (String)"$textField");
                                File file = new File($textField.getText());
                                if (file.isFile()) {
                                    validationInfo = null;
                                } else {
                                    ValidationInfoBuilder validationInfoBuilder = new ValidationInfoBuilder((JComponent)$textField);
                                    String string = CidrCustomCompilerBundle.message("dialog.message.file.not.found", new Object[0]);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                    validationInfo = validationInfoBuilder.error(string);
                                }
                                return validationInfo;
                            }
                        }), (int)1, null);
                    }
                });
            }
        }));
    }

    public void dispose() {
    }

    @NotNull
    public String getDisplayName() {
        String string = CidrCustomCompilerBundle.message("custom.compiler.configurable", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getId() {
        return "cidr.custom.compiler";
    }

    public boolean isModified() {
        return ((Boolean)this.myEnabled.get()).booleanValue() != this.myCompilerService.isEnabled() || !Intrinsics.areEqual((Object)this.myPath.get(), (Object)this.myCompilerService.getCustomDefinitionPath());
    }

    public void apply() {
        this.myCompilerService.setParameters((Boolean)this.myEnabled.get(), (String)this.myPath.get());
    }

    public void reset() {
        this.myEnabled.set((Object)this.myCompilerService.isEnabled());
        String string = this.myCompilerService.getCustomDefinitionPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCustomDefinitionPath(...)");
        this.myPath.set((Object)string);
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        Disposer.dispose((Disposable)this);
    }

    public static final /* synthetic */ GraphProperty access$getMyEnabled$p(CidrCustomCompilerConfigurable $this) {
        return $this.myEnabled;
    }

    public static final /* synthetic */ Project access$getProject$p(CidrCustomCompilerConfigurable $this) {
        return $this.project;
    }

    public static final /* synthetic */ FileChooserDescriptor access$getDescriptor$p(CidrCustomCompilerConfigurable $this) {
        return $this.descriptor;
    }

    public static final /* synthetic */ GraphProperty access$getMyPath$p(CidrCustomCompilerConfigurable $this) {
        return $this.myPath;
    }
}

