/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webpack;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class WebpackUtil {
    @TestOnly
    public static final Key<WebpackVersion> FORCE_WEBPACK_VERSION_IN_TEST_KEY = Key.create((String)"JavaScript.Webpack.Version.For.Tests");
    private static final String WEBPACK = "webpack";

    @NotNull
    public static WebpackVersion getWebpackVersion(@NotNull Project project) {
        WebpackVersion webpackVersion;
        WebpackVersion version;
        if (project == null) {
            WebpackUtil.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (version = (WebpackVersion)((Object)project.getUserData(FORCE_WEBPACK_VERSION_IN_TEST_KEY))) != null) {
            WebpackVersion webpackVersion2 = version;
            if (webpackVersion2 == null) {
                WebpackUtil.$$$reportNull$$$0(1);
            }
            return webpackVersion2;
        }
        VirtualFile projectBaseDir = ProjectUtil.guessProjectDir((Project)project);
        if (project.isDefault() || projectBaseDir == null || project.isDisposed()) {
            WebpackVersion webpackVersion3 = WebpackVersion.NO;
            if (webpackVersion3 == null) {
                WebpackUtil.$$$reportNull$$$0(2);
            }
            return webpackVersion3;
        }
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)projectBaseDir);
        if (packageJson != null && !WebpackVersion.UNKNOWN.equals((Object)(webpackVersion = WebpackUtil.checkInPackageJsonVersion(packageJson)))) {
            WebpackVersion webpackVersion4 = webpackVersion;
            if (webpackVersion4 == null) {
                WebpackUtil.$$$reportNull$$$0(3);
            }
            return webpackVersion4;
        }
        WebpackVersion webpackVersion5 = WebpackUtil.getWebpackVersionFromNodeModules(projectBaseDir);
        if (webpackVersion5 == null) {
            WebpackUtil.$$$reportNull$$$0(4);
        }
        return webpackVersion5;
    }

    private static WebpackVersion getWebpackVersionFromNodeModules(@NotNull VirtualFile folder) {
        PackageJsonData data;
        VirtualFile webpackPackageJson;
        if (folder == null) {
            WebpackUtil.$$$reportNull$$$0(5);
        }
        if ((webpackPackageJson = VfsUtil.findRelativeFile((VirtualFile)folder, (String[])new String[]{"node_modules", WEBPACK, "package.json"})) != null && (data = PackageJsonData.getOrCreate((VirtualFile)webpackPackageJson)).getVersion() != null) {
            if (data.getVersion().getMajor() >= 4) {
                return WebpackVersion.LIKE4;
            }
            if (data.getVersion().getMajor() >= 2) {
                return WebpackVersion.LIKE2;
            }
        }
        return WebpackVersion.NO;
    }

    @NotNull
    private static WebpackVersion checkInPackageJsonVersion(@NotNull VirtualFile packageJson) {
        PackageJsonData data;
        PackageJsonData.PackageJsonDependencyEntry dependencyEntry;
        if (packageJson == null) {
            WebpackUtil.$$$reportNull$$$0(6);
        }
        if ((dependencyEntry = (PackageJsonData.PackageJsonDependencyEntry)(data = PackageJsonData.getOrCreate((VirtualFile)packageJson)).getAllDependencyEntries().get(WEBPACK)) != null) {
            String versionRange = dependencyEntry.getVersionRange();
            ThreeState four = PackageJsonUtil.isVersionGreaterOrEqualMajor((String)versionRange, (int)4);
            if (ThreeState.YES.equals((Object)four)) {
                WebpackVersion webpackVersion = WebpackVersion.LIKE4;
                if (webpackVersion == null) {
                    WebpackUtil.$$$reportNull$$$0(7);
                }
                return webpackVersion;
            }
            if (ThreeState.UNSURE.equals((Object)four)) {
                WebpackVersion webpackVersion = WebpackVersion.UNKNOWN;
                if (webpackVersion == null) {
                    WebpackUtil.$$$reportNull$$$0(8);
                }
                return webpackVersion;
            }
            ThreeState two = PackageJsonUtil.isVersionGreaterOrEqualMajor((String)versionRange, (int)2);
            if (ThreeState.YES.equals((Object)two)) {
                WebpackVersion webpackVersion = WebpackVersion.LIKE2;
                if (webpackVersion == null) {
                    WebpackUtil.$$$reportNull$$$0(9);
                }
                return webpackVersion;
            }
            if (ThreeState.UNSURE.equals((Object)two)) {
                WebpackVersion webpackVersion = WebpackVersion.UNKNOWN;
                if (webpackVersion == null) {
                    WebpackUtil.$$$reportNull$$$0(10);
                }
                return webpackVersion;
            }
        }
        WebpackVersion webpackVersion = WebpackVersion.NO;
        if (webpackVersion == null) {
            WebpackUtil.$$$reportNull$$$0(11);
        }
        return webpackVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webpack/WebpackUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webpack/WebpackUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWebpackVersion";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "checkInPackageJsonVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getWebpackVersion";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWebpackVersionFromNodeModules";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkInPackageJsonVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    public static enum WebpackVersion {
        LIKE2,
        LIKE4,
        UNKNOWN,
        NO;

    }
}

