/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.build.dependencies;

import java.io.Closeable;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesDownloader;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesExtractOptions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u00112\u0006\u0010\u0012\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nH\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/intellij/build/dependencies/Msys2SshAgentDownloader;", "", "()V", "fileList", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "msysTargetDirName", "relativeSshAgentPath", "downloadAndExtractGitForWindows", "Ljava/nio/file/Path;", "communityRoot", "Lorg/jetbrains/intellij/build/dependencies/BuildDependenciesCommunityRoot;", "downloadAndUnpackAgentFiles", "", "targetDirectory", "getSshAgentFileList", "", "gitDir", "resolveSshAgentFilesDir", "intellij.idea.ultimate.build.dependencies"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMsys2SshAgentDownloader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Msys2SshAgentDownloader.kt\norg/jetbrains/intellij/build/dependencies/Msys2SshAgentDownloader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1#2:53\n766#3:54\n857#3,2:55\n*S KotlinDebug\n*F\n+ 1 Msys2SshAgentDownloader.kt\norg/jetbrains/intellij/build/dependencies/Msys2SshAgentDownloader\n*L\n37#1:54\n37#1:55,2\n*E\n"})
public final class Msys2SshAgentDownloader {
    @NotNull
    public static final Msys2SshAgentDownloader INSTANCE = new Msys2SshAgentDownloader();
    @NotNull
    private static final HashSet<String> fileList;
    @NotNull
    public static final String msysTargetDirName = "msys-ssh-agent";
    @NotNull
    public static final String relativeSshAgentPath = "bin/msys-ssh-agent";

    private Msys2SshAgentDownloader() {
    }

    @NotNull
    public final Path downloadAndExtractGitForWindows(@NotNull BuildDependenciesCommunityRoot communityRoot) {
        Intrinsics.checkNotNullParameter((Object)communityRoot, (String)"communityRoot");
        URI gitForWindowsUrl = new URI("https://packages.jetbrains.team/files/p/ij/intellij-dependencies/git-for-windows/Git-2.35.0-64-bit.tar.bz2");
        Path gitForWindowsArchive = BuildDependenciesDownloader.downloadFileToCacheLocation((BuildDependenciesCommunityRoot)communityRoot, (URI)gitForWindowsUrl);
        return BuildDependenciesDownloader.INSTANCE.extractFileToCacheLocation(communityRoot, gitForWindowsArchive, new BuildDependenciesExtractOptions[0]);
    }

    private final Path resolveSshAgentFilesDir(Path gitDir) {
        Path path2 = gitDir.resolve("usr/bin");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<Path> getSshAgentFileList(@NotNull Path gitDir) {
        List list;
        Intrinsics.checkNotNullParameter((Object)gitDir, (String)"gitDir");
        Path usrBin = this.resolveSshAgentFilesDir(gitDir);
        Closeable closeable = Files.newDirectoryStream(usrBin);
        Throwable throwable = null;
        try {
            void $this$filterTo$iv$iv;
            DirectoryStream stream = (DirectoryStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)stream);
            Iterable $this$filter$iv = stream;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Path it = (Path)element$iv$iv;
                boolean bl2 = false;
                if (!fileList.contains(((Object)it.getFileName()).toString())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void downloadAndUnpackAgentFiles(@NotNull Path targetDirectory, @NotNull BuildDependenciesCommunityRoot communityRoot) {
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)communityRoot, (String)"communityRoot");
        Files.createDirectories(targetDirectory, new FileAttribute[0]);
        Closeable closeable = Files.newDirectoryStream(this.resolveSshAgentFilesDir(this.downloadAndExtractGitForWindows(communityRoot)));
        Throwable throwable = null;
        try {
            DirectoryStream stream = (DirectoryStream)closeable;
            boolean bl = false;
            for (Path file : stream) {
                String fileName = ((Object)file.getFileName()).toString();
                if (!fileList.contains(fileName)) continue;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(file, targetDirectory.resolve(fileName), copyOptionArray);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        Object[] objectArray = new String[]{"id.exe", "ssh-agent.exe", "ssh-add.exe", "msys-2.0.dll", "msys-intl-8.dll", "msys-iconv-2.dll", "msys-gcc_s-seh-1.dll", "msys-crypto-1.1.dll", "msys-z.dll"};
        fileList = SetsKt.hashSetOf((Object[])objectArray);
    }
}

