/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteDev.hostStatus.UnattendedHostStatus;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.gateway.ssh.CachingProductsJsonWrapperKt;
import com.jetbrains.gateway.ssh.HostDeployContext;
import com.jetbrains.gateway.ssh.LocalRecentConnectionsManager;
import com.jetbrains.gateway.ssh.util.RemoteRecentProjectsHelper$DeployInfo$;
import com.jetbrains.gateway.ssh.util.RemoteRecentProjectsHelperExtension;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001f*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002\u001f B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0017\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00020\u0018H$\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u001cJ\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001eH$R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006!"}, d2={"Lcom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper;", "TConfig", "", "Lcom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelperExtension;", "()V", "customDeployPrefix", "", "getCustomDeployPrefix", "()Ljava/lang/String;", "fullDeployPrefix", "getFullDeployPrefix", "addToRecent", "", "context", "Lcom/jetbrains/gateway/ssh/HostDeployContext;", "status", "Lcom/intellij/remoteDev/hostStatus/UnattendedHostStatus;", "message", "canHandleMessage", "", "createSuccessfulDeployMessage", "configId", "findConfigById", "deployInfo", "Lcom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo;", "(Lcom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo;)Ljava/lang/Object;", "getConfigId", "config", "(Ljava/lang/Object;)Ljava/lang/String;", "getRecentConnectionsManager", "Lcom/jetbrains/gateway/ssh/LocalRecentConnectionsManager;", "Companion", "DeployInfo", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nAddToRecent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddToRecent.kt\ncom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,111:1\n13#2:112\n*S KotlinDebug\n*F\n+ 1 AddToRecent.kt\ncom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper\n*L\n30#1:112\n*E\n"})
public abstract class RemoteRecentProjectsHelper<TConfig>
implements RemoteRecentProjectsHelperExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final String SuccessfulDeployPrefix = "Deployment Successful #$hi#";
    @NotNull
    private static final String messageSuffix = "#$poka#";

    @NotNull
    protected abstract LocalRecentConnectionsManager<TConfig> getRecentConnectionsManager();

    @NotNull
    protected abstract String getConfigId(@NotNull TConfig var1);

    @Nullable
    protected abstract TConfig findConfigById(@NotNull DeployInfo var1);

    public final void addToRecent(@NotNull HostDeployContext<TConfig> context, @NotNull UnattendedHostStatus status2) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)status2, (String)"status");
        ThreadingAssertions.assertEventDispatchThread();
        TConfig TConfig = context.getConfig();
        if (TConfig == null) {
            return;
        }
        TConfig config = TConfig;
        try {
            logger.info("Add to Recent. sshConfig: " + config);
            this.getRecentConnectionsManager().registerHost(config);
        }
        catch (Throwable e) {
            logger.error("Failed to register host", e);
        }
        logger.warn(this.createSuccessfulDeployMessage(this.getConfigId(config)));
    }

    private final String createSuccessfulDeployMessage(String configId) {
        return this.getFullDeployPrefix() + new DeployInfo(configId).toJson() + messageSuffix;
    }

    @NotNull
    public abstract String getCustomDeployPrefix();

    private final String getFullDeployPrefix() {
        return SuccessfulDeployPrefix + this.getCustomDeployPrefix() + "#";
    }

    @Override
    public boolean canHandleMessage(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return StringsKt.contains$default((CharSequence)message, (CharSequence)this.getFullDeployPrefix(), (boolean)false, (int)2, null);
    }

    @Override
    public void addToRecent(@NotNull String message) {
        DeployInfo deployInfo;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ThreadingAssertions.assertEventDispatchThread();
        logger.info("Got match for successful deploy: '" + message + "'");
        String jsonStr = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)message, (String)this.getFullDeployPrefix(), null, (int)2, null), (String)messageSuffix, null, (int)2, null);
        try {
            deployInfo = DeployInfo.Companion.fromJson(jsonStr);
        }
        catch (SerializationException e) {
            logger.warn("Failed to parse DeployInfo from '" + jsonStr + "'", (Throwable)e);
            return;
        }
        DeployInfo deployInfo2 = deployInfo;
        TConfig TConfig = this.findConfigById(deployInfo2);
        if (TConfig == null) {
            return;
        }
        TConfig config = TConfig;
        logger.info("Add to Recent. sshConfig: " + config);
        this.getRecentConnectionsManager().registerHost(config);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RemoteRecentProjectsHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RemoteRecentProjectsHelper.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$Companion;", "", "()V", "SuccessfulDeployPrefix", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "messageSuffix", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB#\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u0012\u001a\u00020\u0005J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u00c1\u0001\u00a2\u0006\u0002\b\u001bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo;", "", "seen1", "", "configId", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;)V", "getConfigId", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "toJson", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_gateway_core", "$serializer", "Companion", "intellij.gateway.core"})
    @SourceDebugExtension(value={"SMAP\nAddToRecent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddToRecent.kt\ncom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,111:1\n113#2:112\n*S KotlinDebug\n*F\n+ 1 AddToRecent.kt\ncom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo\n*L\n64#1:112\n*E\n"})
    public static final class DeployInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String configId;

        public DeployInfo(@NotNull String configId) {
            Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
            this.configId = configId;
        }

        @NotNull
        public final String getConfigId() {
            return this.configId;
        }

        @NotNull
        public final String toJson() {
            StringFormat $this$encodeToString$iv = (StringFormat)CachingProductsJsonWrapperKt.getJsonFormat();
            boolean $i$f$encodeToString = false;
            $this$encodeToString$iv.getSerializersModule();
            return $this$encodeToString$iv.encodeToString((SerializationStrategy)Companion.serializer(), (Object)this);
        }

        @NotNull
        public final String component1() {
            return this.configId;
        }

        @NotNull
        public final DeployInfo copy(@NotNull String configId) {
            Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
            return new DeployInfo(configId);
        }

        public static /* synthetic */ DeployInfo copy$default(DeployInfo deployInfo, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = deployInfo.configId;
            }
            return deployInfo.copy(string);
        }

        @NotNull
        public String toString() {
            return "DeployInfo(configId=" + this.configId + ")";
        }

        public int hashCode() {
            return this.configId.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeployInfo)) {
                return false;
            }
            DeployInfo deployInfo = (DeployInfo)other;
            return Intrinsics.areEqual((Object)this.configId, (Object)deployInfo.configId);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_gateway_core(DeployInfo self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.configId);
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ DeployInfo(int seen1, String configId, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen1)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)1, (SerialDescriptor)DeployInfo$$serializer.INSTANCE.getDescriptor());
            }
            this.configId = configId;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u00c6\u0001\u00a8\u0006\t"}, d2={"Lcom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo$Companion;", "", "()V", "fromJson", "Lcom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo;", "json", "", "serializer", "Lkotlinx/serialization/KSerializer;", "intellij.gateway.core"})
        @SourceDebugExtension(value={"SMAP\nAddToRecent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddToRecent.kt\ncom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo$Companion\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,111:1\n96#2:112\n*S KotlinDebug\n*F\n+ 1 AddToRecent.kt\ncom/jetbrains/gateway/ssh/util/RemoteRecentProjectsHelper$DeployInfo$Companion\n*L\n61#1:112\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DeployInfo fromJson(@NotNull String json) {
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                Json this_$iv = CachingProductsJsonWrapperKt.getJsonFormat();
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                return (DeployInfo)this_$iv.decodeFromString((DeserializationStrategy)Companion.serializer(), json);
            }

            @NotNull
            public final KSerializer<DeployInfo> serializer() {
                return (KSerializer)DeployInfo$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

