/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.nio.file;

import com.pastdev.jsch.nio.file.UnixSshBasicFileAttributeView;
import com.pastdev.jsch.nio.file.UnixSshPath;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Set;

public class UnixSshPosixFileAttributeView
extends UnixSshBasicFileAttributeView
implements PosixFileAttributeView {
    UnixSshPosixFileAttributeView(UnixSshPath path, LinkOption[] options) {
        super(path, options);
    }

    @Override
    public UserPrincipal getOwner() throws IOException {
        return this.readAttributes().owner();
    }

    @Override
    public String name() {
        return "posix";
    }

    @Override
    public PosixFileAttributes readAttributes() throws IOException {
        return this.getPath().getFileSystem().provider().readAttributes((Path)this.getPath(), PosixFileAttributes.class, this.getOptions());
    }

    @Override
    void setAttribute(String attributeName, Object value) throws IOException {
        if (attributeName.equals("group")) {
            this.setGroup((GroupPrincipal)value);
        } else if (attributeName.equals("owner")) {
            this.setOwner((UserPrincipal)value);
        } else if (attributeName.equals("permissions")) {
            this.setPermissions((Set)value);
        } else {
            super.setAttribute(attributeName, value);
        }
    }

    @Override
    public void setGroup(GroupPrincipal group) throws IOException {
        this.getPath().getFileSystem().provider().setGroup(this.getPath(), group);
    }

    @Override
    public void setOwner(UserPrincipal owner) throws IOException {
        this.getPath().getFileSystem().provider().setOwner(this.getPath(), owner);
    }

    @Override
    public void setPermissions(Set<PosixFilePermission> permissions) throws IOException {
        this.getPath().getFileSystem().provider().setPermissions(this.getPath(), permissions);
    }
}

