/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.nio.file;

import com.pastdev.jsch.command.CommandRunner;
import com.pastdev.jsch.nio.file.AbstractSshFileSystemProvider;
import com.pastdev.jsch.nio.file.StandardGroupPrincipal;
import com.pastdev.jsch.nio.file.StandardUserPrincipal;
import com.pastdev.jsch.nio.file.UnixSshBasicFileAttributeView;
import com.pastdev.jsch.nio.file.UnixSshFileSystem;
import com.pastdev.jsch.nio.file.UnixSshPath;
import com.pastdev.jsch.nio.file.UnixSshPosixFileAttributeView;
import com.pastdev.jsch.nio.file.UnixSshSeekableByteChannel;
import com.pastdev.jsch.nio.file.Variant;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.nio.file.attribute.UserPrincipal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixSshFileSystemProvider
extends AbstractSshFileSystemProvider {
    private static final Logger logger = LoggerFactory.getLogger(UnixSshFileSystemProvider.class);
    private static final String ASCII_UNIT_SEPARATOR = Character.toString('\u001f');
    private static final SupportedAttribute[] BASIC_SUPPORTED_ATTRIBUTES = new SupportedAttribute[]{SupportedAttribute.creationTime, SupportedAttribute.fileKey, SupportedAttribute.isDirectory, SupportedAttribute.isRegularFile, SupportedAttribute.isSymbolicLink, SupportedAttribute.isOther, SupportedAttribute.lastAccessTime, SupportedAttribute.lastModifiedTime, SupportedAttribute.size};
    public static final char PATH_SEPARATOR = '/';
    public static final String PATH_SEPARATOR_STRING = "/";
    private static final SupportedAttribute[] POSIX_ADDITIONAL_SUPPORTED_ATTRIBUTES = new SupportedAttribute[]{SupportedAttribute.permissions, SupportedAttribute.owner, SupportedAttribute.group};
    public static final String SCHEME_SSH_UNIX = "ssh.unix";
    private static final SimpleDateFormat TOUCH_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmm.ss");
    private Map<URI, UnixSshFileSystem> fileSystemMap = new HashMap<URI, UnixSshFileSystem>();

    UnixSshPath checkPath(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof UnixSshPath)) {
            throw new IllegalArgumentException("path not an instanceof UnixSshPath");
        }
        return (UnixSshPath)path;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        UnixSshPath unixPath = this.checkPath(path).toAbsolutePath();
        String pathString = unixPath.toAbsolutePath().quotedString();
        String testCommand = unixPath.getFileSystem().getCommand("test");
        if (this.execute(unixPath, testCommand + " -e " + pathString).getExitCode() != 0) {
            throw new NoSuchFileException(pathString);
        }
        Set<AccessMode> modesSet = UnixSshFileSystemProvider.toSet(modes);
        if (modesSet.contains((Object)AccessMode.READ) && this.execute(unixPath, testCommand + " -r " + pathString).getExitCode() != 0) {
            throw new AccessDeniedException(pathString);
        }
        if (modesSet.contains((Object)AccessMode.WRITE) && this.execute(unixPath, testCommand + " -w " + pathString).getExitCode() != 0) {
            throw new AccessDeniedException(pathString);
        }
        if (modesSet.contains((Object)AccessMode.EXECUTE) && this.execute(unixPath, testCommand + " -x " + pathString).getExitCode() != 0) {
            throw new AccessDeniedException(pathString);
        }
    }

    @Override
    public void copy(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        this.copyOrMove("cp", from, to, copyOptions);
    }

    public void copyOrMove(String cpOrMv, Path from, Path to, CopyOption ... copyOptions) throws IOException {
        UnixSshPath unixFrom = this.checkPath(from);
        UnixSshPath unixTo = this.checkPath(to);
        Set<CopyOption> options = UnixSshFileSystemProvider.toSet(copyOptions);
        if (options.contains(StandardCopyOption.ATOMIC_MOVE)) {
            throw new AtomicMoveNotSupportedException(from.toString(), to.toString(), "to complicated to think about right now, try again at a later release.");
        }
        BasicFileAttributesImpl fromAttributes = new BasicFileAttributesImpl((Path)unixFrom, new LinkOption[0]);
        if (this.exists(unixTo)) {
            PosixFileAttributesImpl toAttributes = new PosixFileAttributesImpl((Path)unixTo, new LinkOption[0]);
            if (fromAttributes.isSameFile(toAttributes)) {
                return;
            }
            if (options.contains(StandardCopyOption.REPLACE_EXISTING)) {
                this.delete(unixTo, toAttributes);
            } else {
                throw new FileAlreadyExistsException(to.toString());
            }
        }
        String command = unixFrom.getFileSystem().getCommand(cpOrMv) + " " + unixFrom.toAbsolutePath().quotedString() + " " + unixTo.toAbsolutePath().quotedString();
        this.executeForStdout(unixTo, command);
    }

    @Override
    public void createDirectory(Path path, FileAttribute<?> ... fileAttributes) throws IOException {
        UnixSshPath unixPath = this.checkPath(path);
        Set permissions = null;
        for (FileAttribute<?> fileAttribute : fileAttributes) {
            if (!fileAttribute.name().equals("posix:permissions")) continue;
            permissions = (Set)fileAttribute.value();
        }
        StringBuilder commandBuilder = new StringBuilder(unixPath.getFileSystem().getCommand("mkdir")).append(" ");
        if (permissions != null) {
            commandBuilder.append("-m ").append(this.toMode(permissions));
        }
        commandBuilder.append(unixPath.toAbsolutePath().quotedString());
        String command = commandBuilder.toString();
        CommandRunner.ExecuteResult result2 = this.execute(unixPath, command);
        if (result2.getExitCode() != 0) {
            if (this.exists(path)) {
                throw new FileAlreadyExistsException(path.toString());
            }
            throw new UnixSshCommandFailedException(command, result2);
        }
    }

    PosixFileAttributes createFile(UnixSshPath path, FileAttribute<?> ... fileAttributes) throws IOException {
        Set permissions = null;
        UserPrincipal owner = null;
        GroupPrincipal group = null;
        for (FileAttribute<?> fileAttribute : fileAttributes) {
            String name = fileAttribute.name();
            if (name.equals("posix:permissions")) {
                permissions = (Set)fileAttribute.value();
                continue;
            }
            if (name.equals("posix:owner")) {
                owner = (UserPrincipal)fileAttribute.value();
                continue;
            }
            if (!name.equals("posix:group")) continue;
            group = (GroupPrincipal)fileAttribute.value();
        }
        String command = path.getFileSystem().getCommand("touch") + " " + path.toAbsolutePath().quotedString();
        this.executeForStdout(path, command);
        if (permissions != null) {
            this.setPermissions(path, permissions);
        }
        if (owner != null) {
            this.setOwner(path, owner);
        }
        if (group != null) {
            this.setGroup(path, group);
        }
        return this.readAttributes((Path)path, PosixFileAttributes.class, new LinkOption[0]);
    }

    @Override
    public void delete(Path path) throws IOException {
        this.delete(this.checkPath(path), new BasicFileAttributesImpl(path, new LinkOption[0]));
    }

    private void delete(UnixSshPath path, BasicFileAttributes attributes) throws IOException {
        if (attributes.isDirectory()) {
            if (this.execute(path, path.getFileSystem().getCommand("rmdir") + " " + path.toAbsolutePath().quotedString()).getExitCode() != 0) {
                throw new DirectoryNotEmptyException(path.toString());
            }
        } else {
            this.executeForStdout(path, path.getFileSystem().getCommand("unlink") + " " + path.toAbsolutePath().quotedString());
        }
    }

    private CommandRunner.ExecuteResult execute(UnixSshPath path, String command) throws IOException {
        logger.debug("execute command {} path( {} )", (Object)command, (Object)path);
        return path.getFileSystem().getCommandRunner().execute(command);
    }

    private String executeForStdout(UnixSshPath path, String command) throws IOException {
        CommandRunner.ExecuteResult result2 = this.execute(path, command);
        if (result2.getExitCode() != 0) {
            throw new UnixSshCommandFailedException(command, result2);
        }
        return result2.getStdout();
    }

    private boolean exists(Path path) throws IOException {
        try {
            this.checkAccess(path, new AccessMode[0]);
            return true;
        }
        catch (NoSuchFileException e) {
            return false;
        }
    }

    UnixSshBasicFileAttributeView getFileAttributeView(Path path, String viewName, LinkOption ... linkOptions) {
        if (viewName.equals("basic")) {
            return new UnixSshBasicFileAttributeView(this.checkPath(path), linkOptions);
        }
        if (viewName.equals("posix")) {
            return new UnixSshPosixFileAttributeView(this.checkPath(path), linkOptions);
        }
        return null;
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... linkOptions) {
        if (type == BasicFileAttributeView.class) {
            return (V)this.getFileAttributeView(path, "basic", linkOptions);
        }
        if (type == PosixFileAttributeView.class) {
            return (V)this.getFileAttributeView(path, "posix", linkOptions);
        }
        if (type == null) {
            throw new NullPointerException();
        }
        return (V)((FileAttributeView)null);
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        throw new UnsupportedOperationException("no idea what a file store would mean in this context, so for now, you have to deal with this exception");
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        UnixSshFileSystem fileSystem = this.fileSystemMap.get(uri.resolve(PATH_SEPARATOR_STRING));
        if (fileSystem == null) {
            throw new FileSystemNotFoundException("no filesystem defined for " + uri.toString());
        }
        return fileSystem;
    }

    @Override
    public String getScheme() {
        return SCHEME_SSH_UNIX;
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return this.checkPath(path).getFileNameString().startsWith(".");
    }

    @Override
    public boolean isSameFile(Path path1, Path path2) throws IOException {
        if (path1.equals(path2)) {
            return true;
        }
        if (!this.isSameProvider(path1, path2)) {
            return false;
        }
        return new BasicFileAttributesImpl(path1, new LinkOption[0]).isSameFile(new BasicFileAttributesImpl(path2, new LinkOption[0]));
    }

    private boolean isSameProvider(Path path1, Path path2) {
        return path1.getFileSystem().provider().equals(path2.getFileSystem().provider());
    }

    @Override
    public void move(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        this.copyOrMove("mv", from, to, copyOptions);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> openOptions, FileAttribute<?> ... fileAttributes) throws IOException {
        return new UnixSshSeekableByteChannel(this.checkPath(path), openOptions, fileAttributes);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        UnixSshPath unixPath = this.checkPath(path);
        String result2 = this.executeForStdout(unixPath, unixPath.getFileSystem().getCommand("ls") + " -A -1 " + unixPath.toAbsolutePath().quotedString());
        String[] items = result2.split("\n");
        if (items.length == 1 && items[0].isEmpty()) {
            items = null;
        }
        return new AbstractSshFileSystemProvider.StandardDirectoryStream(path, items, filter);
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> environment) throws IOException {
        URI baseUri = uri.resolve(PATH_SEPARATOR_STRING);
        UnixSshFileSystem existing = this.fileSystemMap.get(baseUri);
        if (existing != null) {
            throw new RuntimeException("filesystem already exists for " + uri.toString() + " at " + existing.toString());
        }
        UnixSshFileSystem fileSystem = new UnixSshFileSystem(this, uri, environment);
        this.fileSystemMap.put(baseUri, fileSystem);
        return fileSystem;
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... openOptions) throws IOException {
        UnixSshPath unixPath = this.checkPath(path).toAbsolutePath();
        final CommandRunner.ChannelExecWrapper channel = unixPath.getFileSystem().getCommandRunner().open(unixPath.getFileSystem().getCommand("cat") + " " + unixPath.toAbsolutePath().quotedString());
        return new InputStream(){
            private InputStream inputStream;
            {
                this.inputStream = channel.getInputStream();
            }

            @Override
            public void close() throws IOException {
                int exitCode = channel.close();
                logger.debug("cat exited with {}", (Object)exitCode);
            }

            @Override
            public int read() throws IOException {
                return this.inputStream.read();
            }
        };
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... openOptions) throws IOException {
        HashSet<OpenOption> options;
        UnixSshPath unixPath;
        block11: {
            unixPath = this.checkPath(path).toAbsolutePath();
            options = null;
            if (openOptions == null || openOptions.length == 0) {
                options = new HashSet<StandardOpenOption>(Arrays.asList(StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE));
                logger.debug("no open options specified, so using CREATE, TRUNCATE_EXISTING, and WRITE");
            } else {
                options = new HashSet<OpenOption>(Arrays.asList(openOptions));
            }
            if (options.contains(StandardOpenOption.READ)) {
                throw new IllegalArgumentException("read not allowed on OutputStream, seriously...");
            }
            if (!options.contains(StandardOpenOption.WRITE)) {
                throw new IllegalArgumentException("what good is an OutputStream that you cant write to?");
            }
            if (options.contains(StandardOpenOption.DELETE_ON_CLOSE)) {
                throw new UnsupportedOperationException("not gonna implement");
            }
            try {
                this.checkAccess(unixPath, new AccessMode[0]);
                if (options.contains(StandardOpenOption.CREATE_NEW)) {
                    throw new FileAlreadyExistsException(unixPath.toString());
                }
            }
            catch (NoSuchFileException e) {
                if (options.contains(StandardOpenOption.CREATE_NEW)) {
                    this.createFile(unixPath, new FileAttribute[0]);
                }
                if (options.contains(StandardOpenOption.CREATE)) break block11;
                throw e;
            }
        }
        StringBuilder commandBuilder = new StringBuilder(unixPath.getFileSystem().getCommand("cat")).append(" ");
        if (options.contains(StandardOpenOption.APPEND) && !options.contains(StandardOpenOption.TRUNCATE_EXISTING)) {
            commandBuilder.append(">> ");
        } else {
            commandBuilder.append("> ");
        }
        commandBuilder.append(unixPath.toAbsolutePath().quotedString());
        final CommandRunner.ChannelExecWrapper channel = unixPath.getFileSystem().getCommandRunner().open(commandBuilder.toString());
        return new OutputStream(){
            private OutputStream outputStream;
            {
                this.outputStream = channel.getOutputStream();
            }

            @Override
            public void close() throws IOException {
                int exitCode = channel.close();
                logger.debug("cat exited with {}", (Object)exitCode);
            }

            @Override
            public void write(int b) throws IOException {
                this.outputStream.write(b);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int read(UnixSshPath path, long startIndex, ByteBuffer bytes) throws IOException {
        int read = 0;
        CommandRunner.ChannelExecWrapper sshChannel = path.getFileSystem().getCommandRunner().open(path.getFileSystem().getCommand("dd") + " bs=1 skip=" + startIndex + " if=" + path.toAbsolutePath().quotedString() + " 2> /dev/null");
        try (InputStream in = sshChannel.getInputStream();){
            int localRead;
            ReadableByteChannel inChannel = Channels.newChannel(in);
            while (bytes.hasRemaining() && (localRead = inChannel.read(bytes)) > 0) {
                read += localRead;
            }
        }
        finally {
            int exitCode = sshChannel.close();
            if (exitCode != 0) {
                throw new IOException("dd failed " + exitCode);
            }
        }
        return read;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... linkOptions) throws IOException {
        if (type == BasicFileAttributes.class) {
            return (A)new BasicFileAttributesImpl(path, linkOptions);
        }
        if (type == PosixFileAttributes.class) {
            return (A)new PosixFileAttributesImpl(path, linkOptions);
        }
        if (type == null) {
            throw new NullPointerException();
        }
        return (A)((BasicFileAttributes)null);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... linkOptions) throws IOException {
        ArrayList<SupportedAttribute> attributeList = new ArrayList<SupportedAttribute>();
        for (String attributeName : attributes.split(",")) {
            if ((attributeName = attributeName.trim()).equals("*")) {
                return this.readAttributes(path, SupportedAttribute.values(), new LinkOption[0]);
            }
            SupportedAttribute attribute = SupportedAttribute.fromString(attributeName);
            if (attribute == null) continue;
            attributeList.add(attribute);
        }
        return this.readAttributes(path, attributeList.toArray(new SupportedAttribute[attributeList.size()]), linkOptions);
    }

    @NotNull
    private Map<String, Object> readAttributes(Path path, SupportedAttribute[] attributes, LinkOption ... linkOptions) throws IOException {
        String result2;
        UnixSshPath unixPath = this.checkPath(path).toAbsolutePath();
        String command = this.statCommand(unixPath, attributes) + " " + unixPath.toAbsolutePath().quotedString();
        try {
            result2 = this.executeForStdout(unixPath, command);
        }
        catch (UnixSshCommandFailedException e) {
            if (this.exists(unixPath)) {
                throw e;
            }
            throw new NoSuchFileException(path.toString());
        }
        return this.statParse(result2, attributes);
    }

    void removeFileSystem(UnixSshFileSystem fileSystem) {
        this.fileSystemMap.remove(fileSystem.getUri().resolve(PATH_SEPARATOR_STRING));
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... linkOptions) throws IOException {
        String viewName = null;
        String attributeName = null;
        int colonIndex = attribute.indexOf(58);
        if (colonIndex < 0) {
            viewName = "basic";
            attributeName = attribute;
        } else {
            viewName = attribute.substring(0, colonIndex);
            attributeName = attribute.substring(colonIndex + 1);
        }
        UnixSshBasicFileAttributeView view = this.getFileAttributeView(path, viewName, linkOptions);
        if (view == null) {
            throw new UnsupportedOperationException("unsupported view " + viewName);
        }
        view.setAttribute(attributeName, value);
    }

    void setGroup(UnixSshPath path, GroupPrincipal group) throws IOException {
        String command = path.getFileSystem().getCommand("chgrp") + " " + group.getName() + " " + path.toAbsolutePath().quotedString();
        this.executeForStdout(path, command);
    }

    void setOwner(UnixSshPath path, UserPrincipal owner) throws IOException {
        String command = path.getFileSystem().getCommand("chown") + " " + owner.getName() + " " + path.toAbsolutePath().quotedString();
        this.executeForStdout(path, command);
    }

    void setPermissions(UnixSshPath path, Set<PosixFilePermission> permissions) throws IOException {
        String command = path.getFileSystem().getCommand("chmod") + " " + this.toMode(permissions) + " " + path.toAbsolutePath().quotedString();
        this.executeForStdout(path, command);
    }

    void setTimes(UnixSshPath path, FileTime lastModifiedTime, FileTime lastAccessTime) throws IOException {
        String command;
        if (lastModifiedTime != null && lastModifiedTime.equals(lastAccessTime)) {
            String command2 = path.getFileSystem().getCommand("touch") + " -t " + this.toTouchTime(lastModifiedTime) + " " + path.toAbsolutePath().quotedString();
            this.executeForStdout(path, command2);
            return;
        }
        if (lastModifiedTime != null) {
            command = path.getFileSystem().getCommand("touch") + " -m -t " + this.toTouchTime(lastModifiedTime) + " " + path.toAbsolutePath().quotedString();
            this.executeForStdout(path, command);
        }
        if (lastAccessTime != null) {
            command = path.getFileSystem().getCommand("touch") + " -a -t " + this.toTouchTime(lastModifiedTime) + " " + path.toAbsolutePath().quotedString();
            this.executeForStdout(path, command);
        }
    }

    private String statCommand(UnixSshPath path, SupportedAttribute[] attributes) {
        return this.statCommand(path, attributes, false);
    }

    private String statCommand(UnixSshPath path, SupportedAttribute[] attributes, boolean newline) {
        StringBuilder commandBuilder;
        Variant variant = path.getFileSystem().getVariant("stat");
        switch (variant) {
            case BSD: {
                commandBuilder = new StringBuilder(path.getFileSystem().getCommand("stat")).append(" -f \"");
                break;
            }
            default: {
                commandBuilder = new StringBuilder(path.getFileSystem().getCommand("stat")).append(" -c \"");
            }
        }
        for (int i = 0; i < attributes.length; ++i) {
            if (i > 0) {
                commandBuilder.append(ASCII_UNIT_SEPARATOR);
            }
            commandBuilder.append(attributes[i].option(variant));
        }
        if (newline) {
            commandBuilder.append("\\n");
        }
        return commandBuilder.append("\"").toString();
    }

    @NotNull
    private Map<String, Object> statParse(@Nullable String result2, SupportedAttribute ... attributes) throws IOException {
        if (result2 == null || result2.isEmpty()) {
            throw new IOException("Parsing stat output: result is empty");
        }
        String[] values = result2.split(ASCII_UNIT_SEPARATOR);
        if (values.length <= 1) {
            throw new IOException("Parsing stat output: cannot split result");
        }
        if (values.length != attributes.length) {
            logger.error("stat result: " + result2 + " | attrs = " + Arrays.toString((Object[])attributes));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        int count = Math.min(values.length, attributes.length);
        for (int i = 0; i < count; ++i) {
            SupportedAttribute attribute = attributes[i];
            map.put(attribute.name(), attribute.toObject(values[i]));
        }
        return map;
    }

    Map<UnixSshPath, PosixFileAttributes> statDirectory(UnixSshPath directoryPath) throws IOException {
        HashMap<UnixSshPath, PosixFileAttributes> map = new HashMap<UnixSshPath, PosixFileAttributes>();
        SupportedAttribute[] allAttributes = SupportedAttribute.values();
        String command = directoryPath.getFileSystem().getCommand("find") + " " + directoryPath.toAbsolutePath().quotedString() + " -maxdepth 1 -type f -exec " + this.statCommand(directoryPath, allAttributes, true) + " {} +";
        String stdout = this.executeForStdout(directoryPath, command);
        if (stdout.length() > 0) {
            String[] results;
            for (String file : results = stdout.split("\n")) {
                logger.trace("parsing stat response for {}", (Object)file);
                Map<String, Object> fileAttributes = this.statParse(file, allAttributes);
                UnixSshPath filePath = directoryPath.toAbsolutePath().relativize(directoryPath.resolve((String)fileAttributes.get(SupportedAttribute.name.toString())));
                map.put(filePath, new PosixFileAttributesImpl(fileAttributes));
            }
        }
        logger.trace("returning map");
        return map;
    }

    private String toMode(Set<PosixFilePermission> permissions) {
        int[] values = new int[]{4, 2, 1};
        int[] sections = new int[3];
        String permissionsString = PosixFilePermissions.toString(permissions);
        for (int i = 0; i < 9; ++i) {
            if (permissionsString.charAt(i) == '-') continue;
            int n = i / 3;
            sections[n] = sections[n] + values[i % 3];
        }
        return "" + sections[0] + sections[1] + sections[2];
    }

    private String toTouchTime(FileTime fileTime) {
        return TOUCH_DATE_FORMAT.format(new Date(fileTime.toMillis()));
    }

    private static <T> Set<T> toSet(T[] array) {
        return new HashSet<T>(Arrays.asList(array));
    }

    void truncateFile(UnixSshPath path, long size) throws IOException {
        String command = path.getFileSystem().getCommand("truncate") + " -s " + size + " " + path.toAbsolutePath().quotedString();
        this.executeForStdout(path, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int write(UnixSshPath path, long startIndex, ByteBuffer bytes) throws IOException {
        int bytesPosition = bytes.position();
        ByteBuffer temp = ByteBuffer.allocateDirect(bytes.limit() - bytesPosition);
        temp.put(bytes);
        bytes.position(bytesPosition);
        String command = path.getFileSystem().getCommand("dd") + " conv=notrunc bs=1 seek=" + startIndex + " of=" + path.toAbsolutePath().quotedString();
        CommandRunner.ChannelExecWrapper sshChannel = null;
        int written = 0;
        try {
            sshChannel = path.getFileSystem().getCommandRunner().open(command);
            try (OutputStream out = sshChannel.getOutputStream();){
                WritableByteChannel outChannel = Channels.newChannel(out);
                temp.flip();
                written = outChannel.write(temp);
            }
            if (written > 0) {
                bytes.position(bytesPosition + written);
            }
        }
        finally {
            int exitCode = sshChannel.close();
            if (exitCode != 0) {
                throw new IOException("dd failed " + exitCode);
            }
        }
        return written;
    }

    public static class UnixSshCommandFailedException
    extends IOException {
        private static final long serialVersionUID = 2068524022254060541L;
        private String command;
        private CommandRunner.ExecuteResult result;

        public UnixSshCommandFailedException(String command, CommandRunner.ExecuteResult result2) {
            this.command = command;
            this.result = result2;
        }

        @Override
        public String getMessage() {
            return "`" + this.command + "` failed with exit code " + this.result.getExitCode() + ": stdout='" + this.result.getStdout() + "', stderr='" + this.result.getStderr() + "'";
        }
    }

    private static enum SupportedAttribute {
        creationTime("%W", "%B", FileTime.class),
        group("%G", "%Sg", GroupPrincipal.class),
        fileKey("%i", "%i", BigDecimal.class),
        lastAccessTime("%X", "%a", FileTime.class),
        lastModifiedTime("%Y", "%m", FileTime.class),
        lastChangedTime("%Z", "%c", FileTime.class),
        name("%n", "%N", String.class),
        owner("%U", "%Su", UserPrincipal.class),
        permissions("%A", "%Sp", Set.class),
        size("%s", "%z", Long.TYPE),
        isRegularFile("%F", "%HT", Boolean.TYPE),
        isDirectory("%F", "%HT", Boolean.TYPE),
        isSymbolicLink("%F", "%HT", Boolean.TYPE),
        isOther("%F", "%HT", Boolean.TYPE);

        private static Map<String, SupportedAttribute> lookup;
        private static final char[] allPermissions;
        private String gnuOption;
        private final String bsdOption;
        private Class<?> valueClass;

        private SupportedAttribute(String gnuOption, String bsdOption, Class<?> valueClass) {
            this.gnuOption = gnuOption;
            this.bsdOption = bsdOption;
            this.valueClass = valueClass;
        }

        public static SupportedAttribute fromString(String attribute) {
            return lookup.get(attribute);
        }

        public String option(Variant variant) {
            switch (variant) {
                case BSD: {
                    return this.bsdOption;
                }
                case GNU: {
                    return this.gnuOption;
                }
            }
            throw new AssertionError((Object)("Unhandled variant: " + (Object)((Object)variant)));
        }

        public Object toObject(String value) {
            if (this == isRegularFile) {
                return "regular file".equals(value.toLowerCase());
            }
            if (this == isDirectory) {
                return "directory".equals(value.toLowerCase());
            }
            if (this == isSymbolicLink) {
                return "symbolic link".equals(value.toLowerCase());
            }
            if (this == isOther) {
                return "other".equals(value.toLowerCase());
            }
            if (this == owner) {
                return new StandardUserPrincipal(value);
            }
            if (this == group) {
                return new StandardGroupPrincipal(value);
            }
            if (this == permissions) {
                char[] permissions = value.substring(1).toCharArray();
                for (int i = 0; i < 9; ++i) {
                    if (permissions[i] == '-') continue;
                    permissions[i] = allPermissions[i];
                }
                return PosixFilePermissions.fromString(new String(permissions));
            }
            if (this.valueClass == Long.TYPE) {
                return Long.parseLong(value);
            }
            if (this.valueClass == BigDecimal.class) {
                return new BigDecimal(value);
            }
            if (this.valueClass == FileTime.class) {
                long seconds = 0L;
                try {
                    seconds = Long.parseLong(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return FileTime.fromMillis(seconds * 1000L);
            }
            return value;
        }

        static {
            allPermissions = new char[]{'r', 'w', 'x', 'r', 'w', 'x', 'r', 'w', 'x'};
            lookup = new HashMap<String, SupportedAttribute>();
            for (SupportedAttribute attribute : SupportedAttribute.values()) {
                lookup.put(attribute.name(), attribute);
            }
        }
    }

    private class PosixFileAttributesImpl
    extends BasicFileAttributesImpl
    implements PosixFileAttributes {
        private PosixFileAttributesImpl(Map<String, Object> attributeMap) {
            super(attributeMap);
        }

        private PosixFileAttributesImpl(Path path, LinkOption ... linkOptions) throws IOException {
            super(path, POSIX_ADDITIONAL_SUPPORTED_ATTRIBUTES, linkOptions);
        }

        @Override
        public GroupPrincipal group() {
            return (GroupPrincipal)this.map.get(SupportedAttribute.group.toString());
        }

        @Override
        public UserPrincipal owner() {
            return (UserPrincipal)this.map.get(SupportedAttribute.owner.toString());
        }

        @Override
        public Set<PosixFilePermission> permissions() {
            return (Set)this.map.get(SupportedAttribute.permissions.toString());
        }
    }

    private class BasicFileAttributesImpl
    implements BasicFileAttributes {
        @NotNull
        protected final Map<String, Object> map;

        private BasicFileAttributesImpl(Map<String, Object> attributesMap) {
            this.map = attributesMap;
        }

        private BasicFileAttributesImpl(Path path, LinkOption ... linkOptions) throws IOException {
            this(path, (SupportedAttribute[])null, linkOptions);
        }

        private BasicFileAttributesImpl(Path path, SupportedAttribute[] additionalAttributes, LinkOption ... linkOptions) throws IOException {
            SupportedAttribute[] supportedAttributes = null;
            if (additionalAttributes == null) {
                supportedAttributes = BASIC_SUPPORTED_ATTRIBUTES;
            } else {
                supportedAttributes = new SupportedAttribute[BASIC_SUPPORTED_ATTRIBUTES.length + additionalAttributes.length];
                System.arraycopy(BASIC_SUPPORTED_ATTRIBUTES, 0, supportedAttributes, 0, BASIC_SUPPORTED_ATTRIBUTES.length);
                System.arraycopy(additionalAttributes, 0, supportedAttributes, BASIC_SUPPORTED_ATTRIBUTES.length, additionalAttributes.length);
            }
            this.map = UnixSshFileSystemProvider.this.readAttributes(path, supportedAttributes, new LinkOption[0]);
        }

        @Override
        public FileTime creationTime() {
            return (FileTime)this.map.get(SupportedAttribute.creationTime.toString());
        }

        @Override
        public Object fileKey() {
            return this.map.get(SupportedAttribute.fileKey.toString());
        }

        @Override
        public boolean isDirectory() {
            return (Boolean)this.map.get(SupportedAttribute.isDirectory.toString());
        }

        @Override
        public boolean isOther() {
            return (Boolean)this.map.get(SupportedAttribute.isOther.toString());
        }

        @Override
        public boolean isRegularFile() {
            return (Boolean)this.map.get(SupportedAttribute.isRegularFile.toString());
        }

        private boolean isSameFile(BasicFileAttributes other) {
            return this.fileKey().equals(other.fileKey());
        }

        @Override
        public boolean isSymbolicLink() {
            return (Boolean)this.map.get(SupportedAttribute.isSymbolicLink.toString());
        }

        @Override
        public FileTime lastAccessTime() {
            return (FileTime)this.map.get(SupportedAttribute.lastAccessTime.toString());
        }

        @Override
        public FileTime lastModifiedTime() {
            return (FileTime)this.map.get(SupportedAttribute.lastModifiedTime.toString());
        }

        @Override
        public long size() {
            return (Long)this.map.get(SupportedAttribute.size.toString());
        }
    }
}

