/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.ui.widget;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.CidrWorkspaceBundle;
import com.jetbrains.cidr.lang.daemon.OCFileScopeProvider;
import com.jetbrains.cidr.project.ui.ProjectStatusHelperKt;
import com.jetbrains.cidr.project.ui.widget.DefaultWidgetStatus;
import com.jetbrains.cidr.project.ui.widget.Scope;
import com.jetbrains.cidr.project.ui.widget.Status;
import com.jetbrains.cidr.project.ui.widget.WidgetStatus;
import com.jetbrains.cidr.project.ui.widget.WidgetStatusProvider;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/project/ui/widget/DefaultWidgetStatusProvider;", "Lcom/jetbrains/cidr/project/ui/widget/WidgetStatusProvider;", "()V", "getWidgetStatus", "Lcom/jetbrains/cidr/project/ui/widget/WidgetStatus;", "project", "Lcom/intellij/openapi/project/Project;", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.cidr.workspaceModel"})
public final class DefaultWidgetStatusProvider
implements WidgetStatusProvider {
    @Override
    @NotNull
    public WidgetStatus getWidgetStatus(@NotNull Project project, @Nullable VirtualFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (CidrWorkspace.getInitializedWorkspaces(project).isEmpty()) {
            String string = CidrWorkspaceBundle.message("project.status.widget.not.configured", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new DefaultWidgetStatus(Status.Warning, Scope.Project, string);
        }
        if (currentFile != null && ProjectStatusHelperKt.isProjectAwareFile(currentFile, project) && OCFileScopeProvider.Companion.getProjectSourceLocationKind(project, currentFile).isOutProject()) {
            String string = CidrWorkspaceBundle.message("project.status.widget.file.no.project", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new DefaultWidgetStatus(Status.Warning, Scope.File, string);
        }
        String string = CidrWorkspaceBundle.message("project.status.widget.configured", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return new DefaultWidgetStatus(Status.OK, Scope.Project, string);
    }
}

